/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.usergrant;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TripUserGrantPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TripUserGrantPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        try {
            IDataModel model = this.getModel();
            RequestContext context = RequestContext.get();
            model.setValue("grantusername", (Object)context.getUserName());
            DynamicObject user = QueryServiceHelper.queryOne((String)"bos_user", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getCurrUserId())});
            if (user != null) {
                model.setValue("grantuserno", (Object)user.getString("number"));
                model.setValue("grantuser", (Object)context.getCurrUserId());
            }
            this.setComboItems();
        }
        catch (Exception exception) {
            logger.error("\u9875\u9762 afterCreateNewData error", (Object)e);
        }
    }

    private void setComboItems() {
        DynamicObjectCollection enableServers = QueryServiceHelper.query((String)"er_biz_info", (String)"number,id,name", (QFilter[])new QFilter[]{new QFilter("authorizresyncuser", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")});
        if (CollectionUtils.isEmpty((Collection)enableServers)) {
            return;
        }
        ArrayList comboItems = Lists.newArrayListWithCapacity((int)enableServers.size());
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("grantservers");
        for (DynamicObject enableServer : enableServers) {
            ComboItem item = new ComboItem();
            item.setValue(enableServer.getString("number"));
            LocaleString cn = new LocaleString();
            cn.setLocaleValue(String.valueOf(enableServer.get("name")));
            item.setCaption(cn);
            item.setItemVisible(true);
            comboItems.add(item);
        }
        comboEdit.setComboItems((List)comboItems);
    }

    public void afterBindData(EventObject e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        switch (name) {
            case "grantservers": {
                Object newValue = changeSet[0].getNewValue();
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_biz_info", (String)"authroziedcontent_tag", (QFilter[])new QFilter[]{new QFilter("number", "in", newValue)});
                model.setValue("grantcontent_tag", (Object)dynamicObject.getString("authroziedcontent_tag"));
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"bar_save")) {
            this.getView().invokeOperation("refresh");
        }
    }
}

