/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.tripreimbursebill.botp.wb;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(TripReimburseBillWriteBackPlugin.class);
    private static String TARGET_BILL_ID = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        try {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            String name = e.getSrcSubMainType().getName();
            logger.info("\u5f53\u524d\u8868\u5355ID" + name);
            if (!name.equals("er_tripreqbill")) {
                return;
            }
            if (!this.compareByGrade(name, "er_tripreqbill")) {
                return;
            }
            for (int i = 0; i < srcDataEntities.length; ++i) {
                DynamicObject srcDataEntity = srcDataEntities[i];
                Long companyId = ErCommonUtils.getPk((Object)srcDataEntity.get("company"));
                int count = SystemParamterUtil.getloancheckparam((long)companyId, (String)"reqbilltoreimbursecount");
                if (count > 0) {
                    return;
                }
                boolean loan = srcDataEntity.getBoolean("isloan");
                if (loan) {
                    return;
                }
                String billStatus = srcDataEntity.getString("billstatus");
                if ("I".equals(billStatus) || !"E".equals(billStatus)) continue;
                TripCommonUtil.pushReqbillToMQ((String)"er_tripreimbursebill", (Long)Long.parseLong(TARGET_BILL_ID), null, (String)"alreadyApproved", (String)"3");
            }
        }
        catch (Exception exception) {
            logger.error("LINE 69 ", (Throwable)exception);
        }
        finally {
            TARGET_BILL_ID = "";
        }
    }

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("company");
        fieldKeys.add("id");
        fieldKeys.add("billstatus");
        fieldKeys.add("isloan");
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        String name = e.getSrcSubMainType().getName();
        if (!name.equals("er_tripreqbill")) {
            logger.info("Line 93 \u5f53\u524d\u8868\u5355ID" + name);
            return;
        }
        if (!this.compareByGrade(name, "er_tripreqbill")) {
            logger.info("Line 98 \u5f53\u524d\u8868\u5355ID" + name);
            return;
        }
        if (StringUtils.equals((CharSequence)"", (CharSequence)TARGET_BILL_ID)) {
            TARGET_BILL_ID = e.getTargetActiveRow().getParent() == null ? e.getTargetActiveRow().getPkValue().toString() : ((DynamicObject)e.getTargetActiveRow().getParent()).getPkValue().toString();
        }
    }

    private boolean compareByGrade(String formId, String compareFormId) {
        if (formId.equals(compareFormId)) {
            return true;
        }
        DynamicObject formmeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,parentid.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId)});
        if (formmeta == null && formId.endsWith("_mob")) {
            formmeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,parentid.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId.replace("_mob", ""))});
        }
        if (formmeta != null) {
            return this.compareByGrade(formmeta.getString("parentid.number"), compareFormId);
        }
        return false;
    }
}

