/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang.StringUtils;

public class BizOrgCheckEdit
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        BasedataEdit entityType = (BasedataEdit)this.getControl("entitytype");
        entityType.addBeforeF7SelectListener(selectEvent -> {
            ListShowParameter list = (ListShowParameter)selectEvent.getFormShowParameter();
            list.getListFilterParameter().getQFilters().add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initEntityDropdown();
        this.initKeyDropdown();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"actionbars"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((String)"bar_add", (String)itemKey)) {
            Object entity = this.getModel().getValue("entitycomb");
            Object key = this.getModel().getValue("keycomb");
            if (StringUtils.isBlank((String)((String)entity)) || StringUtils.isBlank((String)((String)key))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b9e\u4f53\u5217\u8868\u548c\u5b57\u6bb5\u5217\u8868\u540e\uff0c\u518d\u8fdb\u884c\u6dfb\u52a0\u3002", (String)"BizOrgCheckEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = this.getModel().createNewEntryRow("checkcolumn");
            this.getModel().setValue("entity", entity, rowIndex);
            this.getModel().setValue("key", key, rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        switch (name) {
            case "entitytype": {
                if (newValue != null) {
                    this.initEntityDropdown();
                }
                this.getModel().setValue("entitycomb", null);
                this.getModel().setValue("keycomb", null);
                break;
            }
            case "entitycomb": {
                if (newValue == null) break;
                this.initKeyDropdown();
                this.getModel().setValue("preview", newValue);
                break;
            }
            case "keycomb": {
                String entity = (String)this.getModel().getValue("entitycomb");
                String key = (String)this.getModel().getValue("keycomb");
                this.getModel().setValue("preview", (Object)(entity + "." + key));
                break;
            }
        }
    }

    private void initKeyDropdown() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("entitytype");
        if (billType == null) {
            return;
        }
        String entityType = billType.getString("number");
        MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)entityType);
        Map allEntities = billEntity.getAllEntities();
        String entity = (String)this.getModel().getValue("entitycomb");
        if (entity == null || StringUtils.isEmpty((String)entity)) {
            return;
        }
        EntityType entryEntity = (EntityType)allEntities.get(entity);
        Map keys = entryEntity.getFields();
        ComboEdit keyDropdown = (ComboEdit)this.getControl("keycomb");
        ArrayList keyDropdownItems = new ArrayList();
        keys.forEach((key, prop) -> {
            if (prop instanceof OrgProp) {
                keyDropdownItems.add(new ComboItem(prop.getDisplayName(), key));
            }
        });
        keyDropdown.setComboItems(keyDropdownItems);
    }

    private void initEntityDropdown() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("entitytype");
        if (billType == null) {
            return;
        }
        String entityType = billType.getString("number");
        MainEntityType billEntity = MetadataServiceHelper.getDataEntityType((String)entityType);
        Map allEntities = billEntity.getAllEntities();
        ArrayList entityDropdownItems = new ArrayList();
        allEntities.forEach((key, entity) -> entityDropdownItems.add(new ComboItem(entity.getDisplayName(), key)));
        ComboEdit entity2 = (ComboEdit)this.getControl("entitycomb");
        entity2.setComboItems(entityDropdownItems);
    }
}

