/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.report.ReportShowParameter;
import kd.fi.er.business.billingpool.model.BillingPoolConfigModel;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.externalsystem.SyncReqBillToYzj;
import kd.fi.er.business.servicehelper.LoanBalanceServiceHelper;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang.StringUtils;

public class BtnSettingPlugin
extends AbstractBillPlugIn {
    private static final String IMPORT_BTN = "importbilling";
    private static final String INVOICE_FLEX = "invoice_entry_container";
    private static final String ADD_INVOICE = "addinvoicerow";

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String appid = this.getView().getFormShowParameter().getAppId();
        BillShowParameter billShowParam = (BillShowParameter)this.getView().getFormShowParameter();
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (ErStdConfig.getBillLockAppId().contains(appid) && property != null) {
            String entityId;
            String billstatus = (String)this.getModel().getValue("billstatus");
            BillOperationStatus billOperationStatus = billShowParam.getBillStatus();
            if (billOperationStatus == BillOperationStatus.EDIT && (StringUtils.equals((String)"A", (String)billstatus) || StringUtils.equals((String)"D", (String)billstatus)) && !ErEntityTypeUtils.isRepaymentBill((String)(entityId = this.getModel().getDataEntity(true).getDataEntityType().getName()))) {
                this.getView().setStatus(OperationStatus.VIEW);
                if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"addexpense"});
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_reim", "bar_sncyyzj"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initToolBar();
        this.initaccbalamount();
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (Boolean.parseBoolean((String)map.get("hiddenTbmain"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbmain"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKeys = ",copy,save,submit,unsubmit,invalid,unassign,assign,audit,unaudit,statusconvert,valid,submitandnew,tripchange,";
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKeys.contains("," + operateKey + ",") && ((operationResult = afterDoOperationEventArgs.getOperationResult()) == null || operationResult.isSuccess())) {
            this.initToolBar();
        }
        this.initaccbalamount();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"printpreview")) {
            OperateOption printOp = operate.getOption();
            printOp.setVariableValue("BOS_AUDIT_CUSTOMAUDITVALUE", "E,F,G,H,I");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("bar_save".equals(key) && this.getModel().getProperty("costcompany") != null && Objects.equal(null, (Object)this.getModel().getValue("costcompany"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\u3002", (String)"BtnSettingPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_viewloan".equals(key)) {
            String appid = this.getView().getFormShowParameter().getAppId();
            DynamicObject userinfo = (DynamicObject)this.getModel().getValue("applier");
            if (userinfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"BtnSettingPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            Long userid = userinfo.getLong("id");
            FilterInfo filterinfo = new FilterInfo();
            String formId = "";
            switch (appid) {
                case "18X6P1ZSXS44": 
                case "exp": 
                case "18XD+/5EDN8X": 
                case "tra": {
                    formId = "er_employee_loan_repay";
                    filterinfo.getFilterItems().clear();
                    filterinfo.addFilterItem("applier", (Object)userid, "=");
                    break;
                }
                case "10MYBGBYHXDU": 
                case "em": 
                case "/J5TH+OKHVUA": 
                case "kdem": {
                    formId = "er_employee_loan_repay_fi";
                    filterinfo.getFilterItems().clear();
                    filterinfo.addFilterItem("loanpayer", (Object)new Long[]{userid}, "IN");
                    break;
                }
                default: {
                    formId = "er_employee_loan_repay";
                    filterinfo.getFilterItems().clear();
                    filterinfo.addFilterItem("applier", (Object)userid, "=");
                }
            }
            this.showReportList(formId, filterinfo);
        } else if ("bar_sncyyzj".equals(key)) {
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            SyncReqBillToYzj.SyncBatchReqBillToYzjOneTime((Date)startDate, (Date)endDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        if ("applier".equals(property.getName()) || "currency".equals(property.getName())) {
            this.initaccbalamount();
        }
        if ("costcompany".equals(property.getName())) {
            this.setBillingPoolBtn();
        }
    }

    private void showReportList(String formid, FilterInfo filterinfo) {
        ReportShowParameter showForm = new ReportShowParameter();
        if (filterinfo != null) {
            filterinfo.addFilterItem("paramstatus", (Object)0, "=");
            ReportQueryParam queryParam = new ReportQueryParam();
            queryParam.setFilter(filterinfo);
            showForm.setQueryParam(queryParam);
        }
        showForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showForm.setFormId(formid);
        this.getView().showForm((FormShowParameter)showForm);
    }

    private void initToolBar() {
        String appid = this.getView().getFormShowParameter().getAppId();
        IDataModel model = this.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        String billStatus = model.getValue("billstatus").toString();
        String[] showBtns = new String[]{};
        String[] unShowBtns = new String[]{};
        IFormView view = this.getView();
        if (null == dataEntityType) {
            return;
        }
        switch (billStatus) {
            case "A": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    Boolean isChange = (Boolean)model.getValue("ischange");
                    if (isChange.booleanValue()) {
                        showBtns = new String[]{"copy", "bar_save", "bar_submit1", "print", "bar_print", "bar_close"};
                        unShowBtns = new String[]{"bar_image", "delete", "bar_viewflow", "bar_unsubmit", "bar_waste", "pushdown", "pushrepay", "bar_cloasebill"};
                    } else {
                        showBtns = new String[]{"copy", "delete", "bar_save", "bar_submit1", "print", "bar_print", "bar_close"};
                        unShowBtns = new String[]{"bar_image", "bar_viewflow", "bar_unsubmit", "bar_waste", "pushdown", "pushrepay", "bar_cloasebill"};
                    }
                }
                if ("er_dailyapplybill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_del", "bar_save", "bar_submit", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_unsubmitp", "bar_viewflow", "bar_wastep", "loan", "reimburse", "bar_close_bill"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_del", "bar_save", "bar_submit", "bar_image", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_unsubmit", "bar_waste", "bar_viewflow", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"addtriplabel1", "bar_copy", "bar_del", "bar_save", "bar_submit", "bar_submit1", "bar_image", "bar_print", "bar_close", "copy"};
                    unShowBtns = new String[]{"bar_unsubmitp", "bar_unsubmit", "bar_viewflow", "bar_wastep", "bar_waste", "bar_payp", "bar_closebill"};
                }
                if ("er_repaymentbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"delete", "bar_save", "bar_submit", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_cancel", "bar_ivalid", "bar_audit", "bar_viewflow", "bar_repayment"};
                }
                if ("er_dailyvehiclebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_close"};
                    unShowBtns = new String[]{"bar_unsubmitp", "bar_viewflow"};
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_save", "bar_submit", "bar_close"};
                    unShowBtns = new String[]{"unsubmit"};
                }
                if ("er_accountchangebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_save", "bar_submit", "bar_del", "bar_close", "bar_trackup"};
                    unShowBtns = new String[]{"bar_new", "bar_viewflow", "bar_unsubmit", "bar_waste"};
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                this.setBillingPoolBtn();
                break;
            }
            case "B": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"copy", "bar_unsubmit", "bar_waste", "print", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit1", "bar_image", "pushdown", "pushrepay", "bar_cloasebill"};
                }
                if ("er_dailyapplybill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_unsubmitp", "bar_wastep", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "loan", "reimburse", "bar_close_bill"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_unsubmit", "bar_waste", "bar_image", "bar_viewflow", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_unsubmitp", "bar_wastep", "bar_unsubmit", "bar_viewflow", "bar_waste", "bar_image", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_submit1", "bar_payp", "bar_closebill"};
                }
                if ("er_repaymentbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_cancel", "bar_ivalid", "bar_print", "bar_close", "bar_viewflow"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit", "bar_audit", "bar_repayment"};
                }
                if ("er_dailyvehiclebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_unsubmitp", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit"};
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"unsubmit", "bar_close"};
                    unShowBtns = new String[]{"bar_save", "bar_submit"};
                }
                if ("er_accountchangebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_unsubmit", "bar_waste", "bar_viewflow", "bar_trackup", "bar_close"};
                    unShowBtns = new String[]{"bar_save", "bar_submit", "bar_new", "bar_del"};
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                break;
            }
            case "C": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"copy", "print", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit1", "bar_image", "bar_unsubmit", "bar_waste", "pushdown", "pushrepay", "bar_cloasebill"};
                }
                if ("er_dailyapplybill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmitp", "bar_wastep", "loan", "reimburse", "bar_close_bill"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmit", "bar_waste", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_submit1", "bar_unsubmitp", "bar_unsubmit", "bar_wastep", "bar_waste", "bar_payp", "bar_closebill"};
                }
                if ("er_repaymentbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit", "bar_audit", "bar_repayment", "bar_cancel", "bar_ivalid"};
                }
                if ("er_dailyvehiclebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmitp"};
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_close"};
                    unShowBtns = new String[]{"bar_save", "bar_submit", "unsubmit"};
                }
                if ("er_accountchangebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_viewflow", "bar_trackup", "bar_close"};
                    unShowBtns = new String[]{"bar_save", "bar_submit", "bar_new", "bar_unsubmit", "bar_waste", "bar_del"};
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                break;
            }
            case "D": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_submit1", "print", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "copy", "bar_image", "bar_unsubmit", "bar_waste", "pushdown", "pushrepay", "bar_cloasebill"};
                }
                if ("er_dailyapplybill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_submit", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"bar_copy", "bar_del", "bar_save", "bar_unsubmitp", "bar_wastep", "loan", "reimburse", "bar_close_bill"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_submit", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_copy", "bar_unsubmit", "bar_waste", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_save", "bar_image", "bar_viewflow", "bar_print", "bar_close", "bar_submit", "bar_submit1"};
                    unShowBtns = new String[]{"bar_del", "bar_unsubmitp", "bar_wastep", "bar_unsubmit", "bar_waste", "bar_payp", "bar_closebill"};
                }
                if ("er_repaymentbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_submit", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_audit", "bar_repayment", "bar_cancel", "bar_ivalid"};
                }
                if ("er_dailyvehiclebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_submit", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"bar_copy", "bar_del", "bar_save", "bar_unsubmitp"};
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_submit", "bar_close"};
                    unShowBtns = new String[]{"bar_save", "unsubmit"};
                }
                if ("er_accountchangebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_save", "bar_submit", "bar_del", "bar_close", "bar_trackup"};
                    unShowBtns = new String[]{"bar_new", "bar_viewflow", "bar_unsubmit", "bar_waste"};
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                break;
            }
            case "E": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"copy", "pushdown", "print", "bar_viewflow", "bar_print", "bar_cloasebill", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit1", "bar_image", "bar_unsubmit", "bar_waste", "pushrepay"};
                }
                if ("er_dailyapplybill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "loan", "reimburse", "bar_viewflow", "bar_print", "bar_close_bill", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_unsubmitp", "bar_submit", "bar_wastep"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmit", "bar_waste", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_payp", "bar_save", "bar_submit", "bar_submit1", "bar_unsubmitp", "bar_wastep", "bar_unsubmit", "bar_waste", "bar_closebill"};
                }
                if ("er_repaymentbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_copy", "bar_image", "delete", "bar_save", "bar_submit", "bar_cancel", "bar_ivalid", "bar_audit", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyvehiclebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_viewflow", "bar_close_bill", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_unsubmitp", "bar_submit"};
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_close"};
                    unShowBtns = new String[]{"bar_save", "unsubmit", "bar_submit"};
                }
                if ("er_accountchangebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_viewflow", "bar_trackup", "bar_close"};
                    unShowBtns = new String[]{"bar_save", "bar_submit", "bar_new", "bar_unsubmit", "bar_waste", "bar_del"};
                    ((IBillView)view).setBillStatus(BillOperationStatus.AUDIT);
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                break;
            }
            case "F": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"copy", "print", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit1", "bar_image", "bar_unsubmit", "bar_waste", "pushdown", "pushrepay", "bar_cloasebill"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmit", "bar_waste", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmitp", "bar_wastep", "bar_submit1", "bar_unsubmit", "bar_waste", "bar_payp", "bar_closebill"};
                }
                if ("er_repaymentbill".equals(dataEntityType.toString())) {
                    if ("exp".equals(appid)) {
                        showBtns = new String[]{"bar_viewflow", "bar_print", "bar_close"};
                        unShowBtns = new String[]{"bar_copy", "bar_image", "delete", "bar_save", "bar_submit", "bar_cancel", "bar_ivalid", "bar_audit", "bar_reimburse", "bar_repayment", "bar_closebill"};
                    } else {
                        showBtns = new String[]{"bar_viewflow", "bar_print", "bar_close", "bar_repayment"};
                        unShowBtns = new String[]{"bar_copy", "bar_image", "delete", "bar_save", "bar_submit", "bar_cancel", "bar_ivalid", "bar_audit", "bar_reimburse", "bar_closebill"};
                    }
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_close"};
                    unShowBtns = new String[]{"bar_save", "unsubmit", "bar_submit"};
                }
                if ("er_accountchangebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_save", "bar_submit", "bar_del", "bar_close", "bar_trackup"};
                    unShowBtns = new String[]{"bar_new", "bar_viewflow", "bar_unsubmit", "bar_waste"};
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                break;
            }
            case "G": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"copy", "pushdown", "bar_viewflow", "pushrepay", "print", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit1", "bar_image", "bar_unsubmit", "bar_waste", "bar_cloasebill"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_reimburse", "bar_viewflow", "bar_repayment", "bar_image", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmit", "bar_waste", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmitp", "bar_wastep", "bar_submit1", "bar_unsubmit", "bar_waste", "bar_payp", "bar_closebill"};
                }
                if ("er_repaymentbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_audit", "bar_repayment", "bar_submit", "bar_cancel", "bar_ivalid"};
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_close"};
                    unShowBtns = new String[]{"bar_save", "unsubmit", "bar_submit"};
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                break;
            }
            case "H": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"copy", "print", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit1", "bar_image", "bar_unsubmit", "bar_waste", "pushdown", "pushrepay", "bar_cloasebill"};
                }
                if ("er_dailyapplybill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_print", "bar_viewflow", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmitp", "bar_wastep", "loan", "reimburse", "bar_close_bill"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmit", "bar_waste", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmitp", "bar_wastep", "bar_submit1", "bar_unsubmit", "bar_waste", "bar_payp", "bar_closebill"};
                }
                if ("er_repaymentbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_copy", "bar_image", "delete", "bar_save", "bar_submit", "bar_cancel", "bar_ivalid", "bar_audit", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_close"};
                    unShowBtns = new String[]{"bar_save", "unsubmit", "bar_submit"};
                }
                if ("er_accountchangebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_viewflow", "bar_trackup", "bar_close"};
                    unShowBtns = new String[]{"bar_save", "bar_submit", "bar_new", "bar_unsubmit", "bar_waste", "bar_del"};
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                break;
            }
            case "I": {
                if ("er_tripreqbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"copy", "print", "bar_print", "bar_viewflow", "bar_close", "bar_close"};
                    unShowBtns = new String[]{"delete", "bar_save", "bar_submit1", "bar_image", "bar_waste", "pushdown", "pushrepay", "bar_cloasebill", "bar_unsubmit"};
                }
                if ("er_dailyapplybill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmitp", "bar_wastep", "loan", "reimburse", "bar_close_bill"};
                }
                if ("er_dailyloanbill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmit", "bar_waste", "bar_reimburse", "bar_repayment", "bar_closebill"};
                }
                if ("er_dailyreimbursebill".equals(dataEntityType.toString()) || "er_tripreimbursebill".equals(dataEntityType.toString()) || "er_publicreimbursebill".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_copy", "bar_image", "bar_viewflow", "bar_print", "bar_close"};
                    unShowBtns = new String[]{"bar_del", "bar_save", "bar_submit", "bar_unsubmitp", "bar_wastep", "bar_submit1", "bar_unsubmit", "bar_waste", "bar_payp", "bar_closebill"};
                }
                if ("er_checking_exp_list".equals(dataEntityType.toString())) {
                    showBtns = new String[]{"bar_close"};
                    unShowBtns = new String[]{"bar_save", "unsubmit", "bar_submit"};
                }
                this.setBtnStatus(true, showBtns, view);
                this.setBtnStatus(false, unShowBtns, view);
                break;
            }
        }
    }

    private void setBtnStatus(Boolean isShow, String[] btns, IFormView view) {
        if (null != btns) {
            int len = btns.length;
            for (int i = 0; i < len; ++i) {
                view.setVisible(isShow, new String[]{btns[i]});
            }
        }
    }

    private void initaccbalamount() {
        boolean isloan;
        if (this.getControl("flex_norepay") == null) {
            return;
        }
        DynamicObject user = (DynamicObject)this.getModel().getValue("applier");
        String appid = this.getView().getFormShowParameter().getAppId();
        String entityId = this.getView().getEntityId();
        String billStatus = this.getModel().getValue("billstatus").toString();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (user == null || appid == null || entityId == null || billStatus == null || currency == null) {
            this.hideNoRepayPanel();
            return;
        }
        if (ErEntityTypeUtils.isTripReqBill((String)entityId) && !(isloan = ((Boolean)this.getModel().getValue("isloan")).booleanValue())) {
            this.hideNoRepayPanel();
            return;
        }
        Label labUser = (Label)this.getControl("lab_user");
        labUser.setText(user.getString("name") + "  | ");
        Label labCurrencySign = (Label)this.getControl("lab_moneytype");
        labCurrencySign.setText("");
        Label labAmount = (Label)this.getControl("lab_totalencashamount");
        BigDecimal amount = LoanBalanceServiceHelper.getPersonalLoanBalance((Long)user.getLong("id"), (Long)currency.getLong("id"));
        AmountFormatsUtil.setAmountLabel((Label)labAmount, (DynamicObject)currency, (BigDecimal)amount);
        if (amount.doubleValue() == 0.0) {
            this.hideNoRepayPanel();
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lab_user", "lab_norepay", "lab_moneytype", "lab_totalencashamount", "labelap2"});
        }
    }

    private void hideNoRepayPanel() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"lab_user", "lab_norepay", "lab_moneytype", "lab_totalencashamount", "labelap2"});
    }

    private void setBillingPoolBtn() {
        String proName;
        boolean hasProperty;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (!ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
            return;
        }
        Object company = model.getValue("costcompany");
        Boolean canImport = false;
        Boolean canManualAdd = false;
        if (null != company) {
            BillingPoolConfigModel config = null;
            List poolConfigs = BillingPoolConfigUtils.queryPoolConfigs((Long)ErCommonUtils.getPk((Object)company));
            if (!poolConfigs.isEmpty()) {
                config = (BillingPoolConfigModel)poolConfigs.get(0);
            }
            if (null != config) {
                canImport = config.canImport();
                canManualAdd = config.canManualAdd();
            }
        }
        if (model.getProperty("automapinvoice") != null && canImport.booleanValue() && canManualAdd.booleanValue()) {
            model.setValue("automapinvoice", (Object)false);
            view.setVisible(Boolean.valueOf(false), new String[]{"automapinvoice"});
        }
        view.setVisible(canImport, new String[]{IMPORT_BTN});
        view.setVisible(canManualAdd, new String[]{ADD_INVOICE});
        if (canImport.booleanValue() || canManualAdd.booleanValue()) {
            AdvContainer invoiceAdvContainer = (AdvContainer)this.getControl(INVOICE_FLEX);
            invoiceAdvContainer.setCollapse(false);
        }
        boolean bl = hasProperty = model.getProperty(proName = "canmanualadd") != null;
        if (hasProperty) {
            model.setValue(proName, (Object)canManualAdd);
        }
    }
}

