/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.UserEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.ChangeMainOrgUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripReimOpenTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class ChangeApplier
extends AbstractFormPlugin {
    public static final String BTN_OK = "btnok";
    public static final String BTN_CANCLE = "btncancel";
    public static final String SWITCH_MAIN_ORG = "switchmainorg";
    public static final String SWITCH_TRIP_TYPE = "switchtriptype";
    private static final Log logger = LogFactory.getLog(ChangeApplier.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCLE});
        this.initF7();
    }

    public void initF7() {
        UserEdit applierF7 = (UserEdit)this.getControl("applier");
        applierF7.setIsIncludeAllSub(Boolean.valueOf(true));
        applierF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject dept = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).getModel().getDataEntity().getDynamicObject("org");
            Long deptId = dept != null ? (Long)dept.getPkValue() : Long.valueOf(0L);
            String billtype = (String)this.getModel().getValue("formid");
            boolean isloan = (Boolean)this.getModel().getValue("isloan");
            if (isloan && ErEntityTypeUtils.isTripReqBill((String)billtype)) {
                billtype = "er_loanbill";
            }
            QFilter qFilterApplierF7 = CoreBaseBillServiceHelper.getApplierSelectFilterByCurOrgId((Long)deptId, (String)billtype);
            listShowParameter.getListFilterParameter().getQFilters().add(qFilterApplierF7);
            if (qFilterApplierF7 != null) {
                listShowParameter.getListFilterParameter().getQFilters().add(qFilterApplierF7);
                List nests = qFilterApplierF7.getNests(true);
                if (nests.size() != 0) {
                    QFilter idFilter = null;
                    for (QFilter.QFilterNest nest : nests) {
                        if (!Arrays.toString(nest.getFilter().getProperties()).contains("id")) continue;
                        idFilter = nest.getFilter();
                    }
                    if (idFilter != null) {
                        Set applierIds = (Set)idFilter.getValue();
                        idFilter.and(new QFilter("entryentity.dpt", "in", (Object)BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)applierIds)}).values().stream().flatMap(e -> e.getDynamicObjectCollection("entryentity").stream()).map(r -> ErCommonUtils.getPk((Object)r.get("dpt"))).distinct().toArray()));
                        listShowParameter.getListFilterParameter().setFilter(idFilter);
                    }
                }
            }
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_changeapplier"));
            listShowParameter.setCustomParam("ismergerows", (Object)false);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            logger.info("\u5f53\u524dprop" + propName + " \u7236\u9875\u9762\u5c5e\u6027" + parentModel.getProperty(propName));
            if (parentModel.getProperty(propName) == null) continue;
            model.setValue(propName, ErCommonUtils.getObjectValue((Object)parentModel.getValue(propName)));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propName) {
            case "applier": {
                DynamicObject applier = (DynamicObject)newValue;
                if (applier == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u4eba\u3002", (String)"ChangeApplier_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
                Long applierid = (Long)applier.getPkValue();
                Map userInfo = CommonServiceHelper.getUserMap((Long)applierid);
                String tel = (String)userInfo.get("tel");
                model.setValue("org", userInfo.get("org"));
                model.setValue("applierpositionstr", userInfo.get("applierpositionstr"));
                model.setValue("tel", (Object)tel);
                break;
            }
            case "org": {
                DynamicObject selectedDept = (DynamicObject)newValue;
                if (selectedDept == null || (Long)selectedDept.getPkValue() == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ChangeApplier_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)((Long)selectedDept.getPkValue()));
                if (companyId == null || companyId == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ChangeApplier_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                Long userId = (Long)((DynamicObject)model.getValue("applier")).getPkValue();
                DynamicObject user = CommonServiceHelper.getUser((Long)userId);
                DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
                for (DynamicObject userEntry : userEntrys) {
                    DynamicObject dept = userEntry.getDynamicObject("dpt");
                    Object pkValue = dept.getPkValue();
                    if (selectedDept.getPkValue() != pkValue) continue;
                    model.setValue("applierpositionstr", (Object)userEntry.getString("position"));
                }
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
                if (applier == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u4eba\u3002", (String)"ChangeApplier_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
                Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)((Long)dept.getPkValue()));
                String billtype = (String)this.getModel().getValue("formid");
                if (!ErEntityTypeUtils.isReimCtlApplyBill((String)billtype) && !ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                    DynamicObject payer;
                    DynamicObject costCenter;
                    Long costCompany = CoreBaseBillServiceHelper.getAccountOrgId((boolean)true, (Long)((Long)dept.getPkValue()));
                    IDataEntityProperty costorgusemode = (IDataEntityProperty)this.getView().getParentView().getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"costorgusemode");
                    String orgUseMode = ErCommonUtils.getCostOrgUseMode((Long)companyId);
                    if (costorgusemode != null && (StringUtils.equals((CharSequence)"1", (CharSequence)orgUseMode) || StringUtils.equals((CharSequence)"2", (CharSequence)orgUseMode)) && ((costCompany = ErCommonUtils.getPk((Object)ErCostCenterUtil.getCostCompanyByCostCenter((DynamicObject)(costCenter = ErCostCenterUtil.getCostCenterByCostDept((Long)ErCommonUtils.getPk((Object)dept)))))) == null || costCompany == 0L)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErExpenseBaseEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    }
                    DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Object)companyId, (Object)costCompany);
                    if (currency == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"ChangeApplier_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    }
                    String confirmMessage = ChangeMainOrgUtil.confirmMessage((IDataModel)this.getModel(), (IFormView)this.getView());
                    MessageBoxOptions messageBoxOptions = MessageBoxOptions.OKCancel;
                    String switchKey = SWITCH_MAIN_ORG;
                    IFormView pView = this.getView().getParentView();
                    String isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)companyId);
                    if (pView != null && "1".equals(isgetaccountcurrency) && (ErEntityTypeUtils.isDailyLoanBill((String)pView.getEntityId()) || ErEntityTypeUtils.isDailyReimburseBill((String)pView.getEntityId()) || ErEntityTypeUtils.isTripReimburseBill((String)pView.getEntityId()) || ErEntityTypeUtils.isTripReqBill((String)pView.getEntityId()) || "er_tripreimbill_grid".equals(pView.getEntityId())) && (payer = PayeeServiceHelper.getDefaultAccount((Long)((Long)applier.getPkValue()))) != null && payer.get("currency") == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7533\u8bf7\u4eba\u9ed8\u8ba4\u6536\u6b3e\u4fe1\u606f\u7684\u5e01\u79cd\u3002", (String)"ChangeApplier_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    }
                    if (pView != null && ErEntityTypeUtils.isTripReimburseBill((String)pView.getEntityId())) {
                        Long oldCompanyId = ErCommonUtils.getPk((Object)pView.getModel().getValue("company"));
                        Long userId = (Long)((DynamicObject)this.getModel().getValue("applier")).getPkValue();
                        if (!TripReimOpenTypeUtils.isSameType((IFormView)pView, (Long)userId, (Long)oldCompanyId, (Long)companyId)) {
                            confirmMessage = ResManager.loadKDString((String)"\u5207\u6362\u7533\u8bf7\u4eba\u540e\uff0c\u7533\u8bf7\u4eba\u516c\u53f8\u7684\u5dee\u65c5\u62a5\u9500\u5355\u586b\u5355\u754c\u9762\u4e0e\u5f53\u524d\u754c\u9762\u4e0d\u540c\uff0c\u7cfb\u7edf\u5c06\u9000\u51fa\u5f53\u524d\u754c\u9762\uff0c\u6253\u5f00\u65b0\u754c\u9762\u3002", (String)"ChangeApplier_4", (String)"fi-er-formplugin", (Object[])new Object[0]);
                            switchKey = SWITCH_TRIP_TYPE;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)confirmMessage)) {
                        this.getView().showConfirm(confirmMessage, messageBoxOptions, new ConfirmCallBackListener(switchKey, (IFormPlugin)this));
                        break;
                    }
                    this.clickOk();
                    break;
                }
                this.clickOk();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (SWITCH_MAIN_ORG.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.clickOk();
        } else if (SWITCH_TRIP_TYPE.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.clickOk();
        }
    }

    private void clickOk() {
        IDataModel model = this.getModel();
        DynamicObject dept = (DynamicObject)model.getValue("org");
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        String positionStr = model.getValue("applierpositionstr").toString();
        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)((Long)dept.getPkValue()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("newOrgNumber", dept.get("number"));
        String billtype = (String)this.getModel().getValue("formid");
        if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
            CoreBaseBillServiceHelper.getAccountOrgId((boolean)true, (Long)((Long)dept.getPkValue()));
        }
        map.put("deptId", dept.get("id"));
        map.put("consignorId", applier.getPkValue());
        map.put("newCompanyId", companyId);
        map.put("newPositionStr", positionStr);
        map.put("newtel", model.getValue("tel"));
        this.getView().returnDataToParent(map);
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        if (null == e.getReturnData()) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        if (returnData.size() < 1) {
            return;
        }
        ListSelectedRow selectedRow = returnData.get(0);
        Long userId = (Long)selectedRow.getPrimaryKeyValue();
        model.setValue("applier", (Object)userId);
        Long entryPkValue = (Long)selectedRow.getEntryPrimaryKeyValue();
        DynamicObject user = CommonServiceHelper.getUser((Long)userId);
        String tel = (String)user.get("phone");
        model.setValue("tel", (Object)tel);
        DynamicObjectCollection deptEntrys = user.getDynamicObjectCollection("entryentity");
        DynamicObject deptEntry = null;
        deptEntry = entryPkValue == null ? (DynamicObject)deptEntrys.stream().filter(deptE -> !deptE.getBoolean("ispartjob")).findAny().orElse(null) : (DynamicObject)deptEntrys.stream().filter(deptE -> Objects.equals(entryPkValue, deptE.getPkValue())).findAny().orElse(null);
        if (deptEntry != null) {
            model.setValue("applierpositionstr", (Object)deptEntry.getString("position"));
            model.setValue("org", (Object)ErCommonUtils.getPk((Object)deptEntry.getDynamicObject("dpt")));
        }
    }
}

