/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;

public class EnTrustReimburseEdit
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(EnTrustReimburseEdit.class);
    private static final String MULTRUSTEE = "multrustee";
    private static final String MULCONSIGNOR = "mulconsignor";
    private static final String TRUSTEE = "trustee";
    private static final String CONSIGNOR = "consignor";

    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CommonServiceHelper.isFullApp((String)appId)) {
            this.getModel().setValue(MULCONSIGNOR, (Object)new Object[]{RequestContext.get().getUserId()});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{MULCONSIGNOR});
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{MULTRUSTEE, MULCONSIGNOR});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TRUSTEE, CONSIGNOR});
    }

    protected IDataModel fillDefaultValue() {
        SimpleDateFormat sdf;
        IDataModel model = this.getModel();
        Object[] pks = QueryServiceHelper.query((String)"er_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "like", (Object)"er%")}).stream().map(id -> id.getLong("id")).collect(Collectors.toList()).toArray();
        model.setValue("entrustedscope", (Object)pks);
        Date currendate = TimeServiceHelper.getCurrentSystemTime();
        String language = ResManager.getLanguage();
        String dateStr = "12-31-2099";
        if (!"zh_CN".equals(language) && !"zh_TW".equals(language)) {
            sdf = new SimpleDateFormat("dd.MM.yyyy");
            dateStr = "31.12.2099";
        } else {
            sdf = new SimpleDateFormat("MM-dd-yyyy");
        }
        try {
            model.setValue("startdate", (Object)currendate);
            Date endDate = sdf.parse(dateStr);
            model.setValue("enddate", (Object)endDate);
        }
        catch (ParseException e1) {
            logger.error((Throwable)e1);
        }
        return model;
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MULTRUSTEE, MULCONSIGNOR});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{TRUSTEE, CONSIGNOR});
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CommonServiceHelper.isFullApp((String)appId)) {
            this.setViewStatus();
        }
        this.getModel().setDataChanged(false);
    }

    protected void setViewStatus() {
        DynamicObject consigor = (DynamicObject)this.getModel().getValue(CONSIGNOR);
        if (consigor != null) {
            if (!RequestContext.get().getUserId().equals(consigor.getPkValue().toString())) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"operatepanel", "bar_save"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{CONSIGNOR});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            if (!this.check().booleanValue()) {
                args.setCancel(true);
                return;
            }
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            IDataModel model = this.getModel();
            if (OperationStatus.ADDNEW.equals((Object)status)) {
                DynamicObjectCollection mulconsignor = (DynamicObjectCollection)model.getValue(MULCONSIGNOR);
                DynamicObjectCollection multrustee = (DynamicObjectCollection)model.getValue(MULTRUSTEE);
                if (!mulconsignor.isEmpty() && !multrustee.isEmpty()) {
                    ArrayList<DynamicObject> addNewList = new ArrayList<DynamicObject>();
                    DynamicObjectCollection value = (DynamicObjectCollection)model.getValue("entrustedscope");
                    long[] PKids = DBServiceHelper.genLongIds((String)"t_er_entrustreimbursescop", (int)(mulconsignor.size() * multrustee.size() * value.size()));
                    QFilter qFilter = null;
                    int i = 0;
                    for (int m = 0; m < mulconsignor.size(); ++m) {
                        DynamicObject consignor = (DynamicObject)mulconsignor.get(m);
                        for (int t = 0; t < multrustee.size(); ++t) {
                            Map trusteerMap;
                            DynamicObject trusteedpt;
                            DynamicObject trustee = (DynamicObject)multrustee.get(t);
                            Long consignorid = (Long)consignor.get(2);
                            Long trusteeid = (Long)trustee.get(2);
                            if (consignorid == null || trusteeid == null || trusteeid.equals(consignorid)) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u59d4\u6258\u4eba\u548c\u53d7\u6258\u4eba\u76f8\u540c\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"EnTrustReimburseEdit_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                            }
                            QFilter filter = QFilter.of((String)"consignor=? and trustee = ?", (Object[])new Object[]{consignorid, trusteeid});
                            qFilter = qFilter == null ? filter : qFilter.or(filter);
                            model.setValue(CONSIGNOR, (Object)consignorid);
                            model.setValue(TRUSTEE, (Object)trusteeid);
                            Map consignorMap = CommonServiceHelper.getUserMap((Long)consignorid);
                            DynamicObject consignordpt = (DynamicObject)consignorMap.get("org");
                            if (consignordpt != null) {
                                model.setValue("consignororg", (Object)consignordpt.getLong("id"));
                            }
                            if ((trusteedpt = (DynamicObject)(trusteerMap = CommonServiceHelper.getUserMap((Long)trusteeid)).get("org")) != null) {
                                model.setValue("trusteeorg", (Object)trusteedpt.getLong("id"));
                            }
                            Date startDate = (Date)model.getValue("startdate");
                            String language = ResManager.getLanguage();
                            SimpleDateFormat sdf = !"zh_CN".equals(language) && !"zh_TW".equals(language) ? new SimpleDateFormat("dd.MM.yyyy") : new SimpleDateFormat("yyyy-MM-dd");
                            String startDateStr = sdf.format(startDate);
                            Date endDate = (Date)model.getValue("enddate");
                            String endDateStr = sdf.format(endDate);
                            model.setValue("rentrustdate", (Object)(startDateStr + "~" + endDateStr));
                            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"er_entrustreimburse");
                            DynamicObjectCollection packagetEntrys = newDynamicObject.getDynamicObjectCollection("entrustedscope");
                            StringBuilder rentrustedscopeBuilder = new StringBuilder();
                            for (DynamicObject ob : value) {
                                DynamicObject billTypeObject = ob.getDynamicObject("FBaseDataId");
                                rentrustedscopeBuilder.append(billTypeObject.getLocaleString("name").getLocaleValue_zh_CN()).append(";");
                                DynamicObject newscope = packagetEntrys.addNew();
                                newscope.set("fbasedataid", (Object)billTypeObject);
                                newscope.set("fbasedataid_id", billTypeObject.getPkValue());
                                newscope.set("pkid", (Object)PKids[i]);
                                ++i;
                            }
                            model.setValue("rentrustedscope", (Object)rentrustedscopeBuilder.toString());
                            DataEntityPropertyCollection props = model.getDataEntityType().getProperties();
                            for (IDataEntityProperty property : props) {
                                String propertyName = property.getName();
                                if ("id".equals(propertyName) || "entrustedscope".equals(propertyName)) continue;
                                newDynamicObject.set(propertyName, model.getValue(propertyName));
                            }
                            addNewList.add(newDynamicObject);
                        }
                    }
                    args.setCancel(true);
                    if (addNewList.size() > 0) {
                        DynamicObject object = QueryServiceHelper.queryOne((String)"er_entrustreimburse", (String)"id", (QFilter[])new QFilter[]{qFilter});
                        if (object != null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u59d4\u6258\u5173\u7cfb\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u3002", (String)"EnTrustReimburseEdit_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        OperationServiceHelper.executeOperate((String)"save", (String)"er_entrustreimburse", (DynamicObject[])addNewList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                    }
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                }
            } else {
                DynamicObject consignor = (DynamicObject)model.getValue(CONSIGNOR);
                DynamicObject trustee = (DynamicObject)model.getValue(TRUSTEE);
                if (Objects.nonNull(consignor) && Objects.nonNull(trustee)) {
                    Map trusteerMap;
                    DynamicObject trusteedpt;
                    Long consignorid = (Long)consignor.getPkValue();
                    Long trusteeid = (Long)trustee.getPkValue();
                    Map consignorMap = CommonServiceHelper.getUserMap((Long)consignorid);
                    DynamicObject consignordpt = (DynamicObject)consignorMap.get("org");
                    if (consignordpt != null) {
                        model.setValue("consignororg", (Object)consignordpt.getLong("id"));
                    }
                    if ((trusteedpt = (DynamicObject)(trusteerMap = CommonServiceHelper.getUserMap((Long)trusteeid)).get("org")) != null) {
                        model.setValue("trusteeorg", (Object)trusteedpt.getLong("id"));
                    }
                    Date startDate = (Date)model.getValue("startdate");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String startDateStr = sdf.format(startDate);
                    Date endDate = (Date)model.getValue("enddate");
                    String endDateStr = sdf.format(endDate);
                    model.setValue("rentrustdate", (Object)(startDateStr + "~" + endDateStr));
                    DynamicObjectCollection value = (DynamicObjectCollection)model.getValue("entrustedscope");
                    StringBuilder rentrustedscopeBuilder = new StringBuilder();
                    for (DynamicObject ob : value) {
                        DynamicObject billTypeObject = ob.getDynamicObject("FBaseDataId");
                        rentrustedscopeBuilder.append(billTypeObject.getLocaleString("name").getLocaleValue_zh_CN()).append(";");
                    }
                    model.setValue("rentrustedscope", (Object)rentrustedscopeBuilder.toString());
                }
            }
        }
    }

    private Boolean check() {
        boolean result = true;
        Object trustee = this.getModel().getValue(TRUSTEE);
        Object consignor = this.getModel().getValue(CONSIGNOR);
        Object mulconsignor = this.getModel().getValue(MULCONSIGNOR);
        Object multrustee = this.getModel().getValue(MULTRUSTEE);
        if (consignor == null && (mulconsignor == null || ((Collection)mulconsignor).isEmpty())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u59d4\u6258\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EnTrustReimburseEdit_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            result = false;
        }
        if (trustee == null && (multrustee == null || ((Collection)multrustee).isEmpty())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d7\u6258\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EnTrustReimburseEdit_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            result = false;
        }
        return result;
    }
}

