/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.messagepublish.ErMessagePublisher;

public class ExceptionInfoListPlugin
extends AbstractListPlugin {
    private static final String BTN_DO_ACTION = "btn_doaction";
    private static final String BTN_DONT_DEAL = "btn_dontdeal";

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("createtime desc");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        switch (itemKey) {
            case "btn_doaction": {
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ExceptionInfoListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u62a5\u9500\u3002", (String)"ExceptionInfoListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListSelectedRow selectedRow = selectedRows.get(0);
                Long selectedRowId = (Long)selectedRow.getPrimaryKeyValue();
                IErDao erdao = ErDaoFactory.getInstance((String)"er_exceptioninfo");
                DynamicObject object = erdao.queryOne("businessid,businesstype,operate,status,formid,otherinfo,modifytime", (Object)selectedRowId);
                this.execute(object);
                billList.refresh();
                break;
            }
            case "btn_dontdeal": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u529f\u80fd\u6682\u505c\u4f7f\u7528\u3002", (String)"ExceptionInfoListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void execute(DynamicObject object) {
        ExceptionInfoListPlugin.dealExceptionInfo(object);
    }

    public static void dealExceptionInfo(DynamicObject object) {
        String businessId = object.getString("businessid");
        String formId = object.getString("formid");
        String businessType = object.getString("businesstype");
        String operate = object.getString("operate");
        String otherInfo = object.getString("otherinfo");
        switch (operate) {
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "checked": {
                HashMap<String, String> msgMap = new HashMap<String, String>();
                msgMap.put("billId", businessId);
                msgMap.put("operate", operate);
                msgMap.put("businesstype", businessType);
                if ("tripreqbill".equals(businessType)) {
                    ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripReqBill.submit", msgMap);
                    break;
                }
                if ("tripreqbill(loan)".equals(businessType)) {
                    ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripLoanBill.submit", msgMap);
                    break;
                }
                if ("tripreimbursebill".equals(businessType)) {
                    ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripReimburseBill.submit", msgMap);
                    break;
                }
                if ("dailyloanbill".equals(businessType)) {
                    ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.dailyLoanBill.approval", msgMap);
                    break;
                }
                if (!"dailyreimbursebill".equals(businessType)) break;
                ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.dailyReimburseBill.approval", msgMap);
                break;
            }
            case "delete": {
                HashMap<String, String> deleteMsgMap = new HashMap<String, String>();
                deleteMsgMap.put("billId", businessId);
                deleteMsgMap.put("easBillId", otherInfo);
                if ("tripreqbill".equals(businessType)) {
                    ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripReqBill.delete", deleteMsgMap);
                    break;
                }
                if ("tripreqbill(loan)".equals(businessType)) {
                    ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripLoanBill.delete", deleteMsgMap);
                    break;
                }
                if (!"tripreimbursebill".equals(businessType)) break;
                ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripReimburseBill.delete", deleteMsgMap);
                break;
            }
            case "fileUpload": {
                HashMap<String, String> uploadMsgMap = new HashMap<String, String>();
                uploadMsgMap.put("billId", businessId);
                uploadMsgMap.put("easBillId", otherInfo);
                uploadMsgMap.put("formId", formId);
                uploadMsgMap.put("businesstype", businessType);
                ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripAttachment.upload", uploadMsgMap);
                break;
            }
            case "updateApprover": {
                HashMap<String, String> pushMap = new HashMap<String, String>();
                pushMap.put("ngId", businessId);
                pushMap.put("ngType", businessType);
                pushMap.put("currentApprover", otherInfo);
                ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.ext.tripLoanBill.delete", pushMap);
            }
        }
    }
}

