/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class MultiPayeeTripReqPlugin
extends AbstractBillPlugIn {
    private static final String T_MAIN = "advcontoolbarap2";
    private static final String MULTRAVELERSRECIPT = "multravelersrecipt";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{T_MAIN});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        CommonServiceHelper.setIsMulTravelers((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)MULTRAVELERSRECIPT, (CharSequence)evt.getItemKey())) {
            this.deleteOldReciptInformation();
            this.mulTravelersReceive();
        }
    }

    private void mulTravelersReceive() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tripEntry = dataEntity.getDynamicObjectCollection("tripentry");
        HashSet<Long> idSet = new HashSet<Long>();
        HashSet<Long> errIdSet = new HashSet<Long>();
        for (DynamicObject entry : tripEntry) {
            DynamicObjectCollection travelers = entry.getDynamicObjectCollection("travelers");
            for (DynamicObject traveler : travelers) {
                idSet.add(ErCommonUtils.getPk((Object)traveler.getDynamicObject("fbasedataid")));
            }
        }
        idSet.remove(null);
        for (Long travelerId : idSet) {
            List defaultAccounts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)travelerId, null, (boolean)false);
            if (defaultAccounts == null || defaultAccounts.isEmpty()) {
                errIdSet.add(travelerId);
                continue;
            }
            DynamicObject defaultAccount = (DynamicObject)defaultAccounts.get(0);
            if (null == defaultAccount) {
                errIdSet.add(travelerId);
                continue;
            }
            int rowIndex = model.createNewEntryRow("accountentry");
            CoreBaseBillServiceHelper.fillAccountEntry((IDataModel)model, (int)rowIndex, (DynamicObject)defaultAccount);
            Map currencyMap = AmountChangeUtil.getCurrencyPayerAndParam((IDataModel)model, (int)rowIndex, (Long)travelerId);
            model.setValue("accountcurrency", currencyMap.get("currencyId"), rowIndex);
            model.setValue("accexchangerate", currencyMap.get("exchangeRate"), rowIndex);
            model.setValue("receiveamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("orireceiveamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("accnotpayamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("oriaccnotpayamount", (Object)BigDecimal.ZERO, rowIndex);
        }
        int entryRowCount = model.getEntryRowCount("accountentry");
        if (entryRowCount == 1) {
            BigDecimal approveamount = dataEntity.getBigDecimal("approveamount");
            model.beginInit();
            model.setValue("approveamount", (Object)BigDecimal.ZERO);
            model.endInit();
            model.setValue("approveamount", (Object)approveamount);
        }
        this.showConfirm(errIdSet);
    }

    protected void showConfirm(Set<Long> reimburseIds) {
        Map userArray;
        if (!reimburseIds.isEmpty() && (userArray = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", reimburseIds)})) != null && !userArray.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : userArray.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                builder.append(dynamicObject.getLocaleString("name").getLocaleValue()).append('\uff0c');
            }
            builder.deleteCharAt(builder.lastIndexOf("\uff0c"));
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u672a\u81ea\u52a8\u4ea7\u751f\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u624b\u5de5\u6dfb\u52a0\u3002", (String)"MultiTripReimburserPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), builder), MessageBoxOptions.OK);
        }
    }

    private void deleteOldReciptInformation() {
        this.getModel().deleteEntryData("accountentry");
    }
}

