/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PayeeListPlugin
extends AbstractListPlugin {
    private static final String CLEARAUTH_CONFIRM = "clearauthConfirm";
    private static final String CLEAR_AND_EDIT_AUTH = "clearandeditauth";
    private static final String EDIT_AUTH = "editauth";
    private static final String CLEAR_AUTH = "clearauth";
    private static final double MAX_BASE_NUM = 10000.0;
    private static final String ER_DBKEY = "er";
    private static final String USERID_TB_NAME = "t_er_payeeuser";
    private static final String ENABLE = "enable";
    private static final Log logger = LogFactory.getLog(PayeeListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs e) {
        super.filterContainerInit(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!this.isFullApp(appId) && !StringUtils.equals((CharSequence)"dhc", (CharSequence)appId)) {
            List commonFilterColumns = e.getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!ENABLE.equals(fieldName)) continue;
                filterColumn.setDefaultValue("1");
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_editauth"});
        }
    }

    private boolean isFullApp(String appId) {
        String datafilter = (String)this.getView().getFormShowParameter().getCustomParam("datafilter");
        if (StringUtils.isNotEmpty((CharSequence)datafilter)) {
            return Boolean.parseBoolean(datafilter);
        }
        return CommonServiceHelper.isFullApp((String)appId);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        String appid = this.getView().getFormShowParameter().getAppId();
        QFilter listFilter = null;
        String string = appid = appid == null ? "" : appid.trim().toLowerCase();
        if (!"bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            Long userId = CommonServiceHelper.getCurrentUserID();
            if (this.isFullApp(appid) || StringUtils.equals((CharSequence)"dhc", (CharSequence)appid)) {
                listFilter = new QFilter("creator", "=", (Object)userId);
                listFilter = listFilter.or("userid.fbasedataid", "=", (Object)userId);
                listFilter = listFilter.or("payer", "=", (Object)userId);
            } else if (!qFilters.stream().anyMatch(v -> "createorg.id".equals(v.getProperty()))) {
                if (StringUtils.isBlank((CharSequence)appid)) {
                    throw new KDBizException(ResManager.loadKDString((String)"appid\u4e3a\u7a7a\uff0c\u6b63\u786e\u914d\u7f6eappid\u3002", (String)"PayeeListPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                HasPermOrgResult orgsResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)"er_payeer", (String)"47150e89000000ac");
                logger.info(String.format("\u5f53\u524d\u7528\u6237:%s,\u5bf9\u5e94\u7528:%s,\u5b9e\u4f53:%s,\u6743\u9650\u9879id:%s,\u662f\u5426\u5177\u6709\u5168\u90e8\u7ec4\u7ec7\u6743\u9650:%s,\u5177\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u4e3a:%s", userId, appid, "er_payeer", "47150e89000000ac", orgsResult.hasAllOrgPerm(), SerializationUtils.toJsonString((Object)orgsResult.getHasPermOrgs())));
                if (!orgsResult.hasAllOrgPerm()) {
                    listFilter = new QFilter("createorg.id", "in", (Object)orgsResult.getHasPermOrgs());
                }
            }
        }
        if (listFilter != null) {
            qFilters.add(listFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "editauth": 
            case "clearandeditauth": 
            case "clearauth": {
                this.editAuth(operateKey);
            }
        }
    }

    private void editAuth(String type) {
        ListSelectedRowCollection rows = this.getListSelectedRows();
        if (rows == null || rows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PayeeListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (rows.size() > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u6027\u80fd\uff0c\u8bf7\u9009\u62e9\u4e0d\u8d85\u8fc750\u6761\u6570\u636e\u3002", (String)"PayeeListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (type) {
            case "editauth": 
            case "clearandeditauth": {
                ListShowParameter userList = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
                ListFilterParameter lfp = new ListFilterParameter();
                lfp.setFilter(new QFilter(ENABLE, "=", (Object)Boolean.TRUE));
                userList.setListFilterParameter(lfp);
                userList.setCloseCallBack(new CloseCallBack((IFormPlugin)this, type));
                this.getView().showForm((FormShowParameter)userList);
                break;
            }
            case "clearauth": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u6e05\u9664\u4f7f\u7528\u4eba\u5417\uff1f", (String)"PayeeListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CLEARAUTH_CONFIRM));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "clearandeditauth": 
            case "editauth": {
                ListSelectedRowCollection users = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (users == null) break;
                if ((double)users.size() > 10000.0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u6027\u80fd\uff0c\u9009\u62e9\u7684\u4eba\u5458\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u6761\u3002", (String)"PayeeListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.updatePayeeUser(users, actionId);
            }
        }
    }

    private void updatePayeeUser(ListSelectedRowCollection users, String operateNum) {
        ListSelectedRowCollection payees = this.getListSelectedRows();
        if (payees == null || payees.size() < 1) {
            return;
        }
        boolean isClearOld = !EDIT_AUTH.equals(operateNum);
        Object[] payeeIds = payees.getPrimaryKeyValues();
        Object[] userIds = users.getPrimaryKeyValues();
        Map userDOMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userIds)});
        List payeeDyms = CommonServiceHelper.transferArrayToList((Object[])BusinessDataServiceHelper.load((String)"er_payeer", (String)"id,userid,isshare", (QFilter[])new QFilter("id", "in", (Object)payeeIds).toArray()));
        if (this.getAuthResult(payeeDyms, userDOMap, isClearOld)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f\u3002", (String)"PayeeListPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean getAuthResult(List<DynamicObject> payeeDyms, Map<Object, DynamicObject> userDOMap, boolean isClearOld) {
        int objectNum;
        if (payeeDyms == null || userDOMap == null) {
            return false;
        }
        boolean isAuth = false;
        int userSize = userDOMap.size();
        int payInfoSize = payeeDyms.size();
        int groupPayerInfoNum = objectNum = (int)Math.ceil((double)(userSize * payInfoSize) / 10000.0);
        int groupPayerInfoSize = payInfoSize / objectNum;
        int groupUserNum = 1;
        int groupUserSize = userSize;
        if (groupPayerInfoSize < 1) {
            groupPayerInfoNum = 1;
            groupPayerInfoSize = payInfoSize;
            while (groupPayerInfoSize > 1 && (double)(groupPayerInfoSize * groupUserSize) > 10000.0) {
                groupPayerInfoSize = (int)Math.ceil((double)payInfoSize / (double)(groupPayerInfoNum <<= 1));
            }
            if ((double)(groupPayerInfoSize * groupUserSize) > 10000.0) {
                groupUserNum = (int)Math.ceil((double)groupUserSize / 10000.0);
                groupUserSize = userSize / groupUserNum;
            }
        }
        ArrayList payeePkIds = new ArrayList();
        ArrayList<DynamicObject> payDymInOneGroup = new ArrayList<DynamicObject>();
        HashMap<Object, DynamicObject> userMapInOneGroup = new HashMap<Object, DynamicObject>();
        Iterator<DynamicObject> payerIterator = payeeDyms.iterator();
        for (int i = 0; i < groupPayerInfoNum; ++i) {
            int j = 0;
            payDymInOneGroup.clear();
            while (j++ < groupPayerInfoSize && payerIterator.hasNext()) {
                DynamicObject payeeDym = payerIterator.next();
                payDymInOneGroup.add(payeeDym);
                payerIterator.remove();
            }
            if (isClearOld) {
                payeePkIds.clear();
                payDymInOneGroup.stream().forEach(payDym -> payeePkIds.add(payDym.getPkValue()));
                this.deleteUseridByPayeeID(payeePkIds.toArray());
            }
            Map userMap = (Map)((HashMap)userDOMap).clone();
            Iterator userIterator = userMap.entrySet().iterator();
            for (int m = 0; m < groupUserNum; ++m) {
                int n = 0;
                userMapInOneGroup.clear();
                while (n++ < groupUserSize && userIterator.hasNext()) {
                    Map.Entry entry = userIterator.next();
                    userMapInOneGroup.put(entry.getKey(), (DynamicObject)entry.getValue());
                    userIterator.remove();
                }
                Iterator payInOneGroupIterator = payDymInOneGroup.iterator();
                while (payInOneGroupIterator.hasNext() && userMapInOneGroup.size() > 0) {
                    DynamicObject payeeDym = (DynamicObject)payInOneGroupIterator.next();
                    payeeDym.set("isshare", (Object)Boolean.TRUE);
                    payeeDym.set("userid", (Object)this.generateMultiPropValue(payeeDym, "userid", userMapInOneGroup));
                }
                if (payDymInOneGroup.size() <= 0 || userMapInOneGroup.size() <= 0) continue;
                if (!isAuth) {
                    isAuth = true;
                }
                SaveServiceHelper.save((DynamicObject[])payDymInOneGroup.toArray(new DynamicObject[payDymInOneGroup.size()]));
            }
        }
        return isAuth;
    }

    private DynamicObjectCollection generateMultiPropValue(DynamicObject entity, String propName, Map<Object, DynamicObject> userDOMap) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity.getDataEntityType().getName());
        DynamicCollectionProperty currentProp = (DynamicCollectionProperty)entityType.getProperty(propName);
        DynamicObjectCollection collection = entity.getDynamicObjectCollection("userid");
        HashMap<Object, Object> userIDSet = new HashMap<Object, Object>();
        for (DynamicObject user : collection) {
            Object userId = user.get("fbasedataid");
            if (userId instanceof Long) {
                userIDSet.put(userId, user);
                continue;
            }
            if (!(userId instanceof DynamicObject)) continue;
            userIDSet.put(((DynamicObject)userId).getPkValue(), user);
        }
        HashMap finalUserIDSet = new HashMap();
        userDOMap.forEach((key, userDO) -> {
            DynamicObject newObj = new DynamicObject(currentProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", userDO.getPkValue());
            finalUserIDSet.put(userDO.getPkValue(), newObj);
        });
        userIDSet.putAll(finalUserIDSet);
        collection = new DynamicObjectCollection(currentProp.getDynamicCollectionItemPropertyType(), (Object)entity);
        for (Map.Entry entry : userIDSet.entrySet()) {
            collection.add(entry.getValue());
        }
        return collection;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "clearauthConfirm": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.gotoClearAuth();
            }
        }
    }

    private void gotoClearAuth() {
        ListSelectedRowCollection listSelectedRows = this.getListSelectedRows();
        if (listSelectedRows == null || listSelectedRows.size() < 1) {
            return;
        }
        Object[] payeePkIds = listSelectedRows.getPrimaryKeyValues();
        boolean isSuccess = this.deleteUseridByPayeeID(payeePkIds);
        DynamicObject[] payeeDyms = BusinessDataServiceHelper.load((String)"er_payeer", (String)"id,isshare", (QFilter[])new QFilter("id", "in", (Object)payeePkIds).toArray());
        if (isSuccess) {
            for (DynamicObject payeeDym : payeeDyms) {
                payeeDym.set("isshare", (Object)Boolean.FALSE);
            }
            if (payeeDyms.length > 0) {
                SaveServiceHelper.save((DynamicObject[])payeeDyms);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6388\u6743\u6210\u529f\u3002", (String)"PayeeListPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private ListSelectedRowCollection getListSelectedRows() {
        IFormView formView = this.getView();
        if (formView instanceof ListView) {
            ListView list = (ListView)formView;
            return list.getSelectedRows();
        }
        return null;
    }

    private boolean deleteUseridByPayeeID(Object[] payeePkIds) {
        if (payeePkIds == null || payeePkIds.length < 1) {
            return false;
        }
        StringBuilder deleteSQLSb = new StringBuilder("delete from ").append(USERID_TB_NAME).append(" where fid in (");
        for (int i = 0; i < payeePkIds.length; ++i) {
            if (i > 0) {
                deleteSQLSb.append(',');
            }
            deleteSQLSb.append('?');
        }
        deleteSQLSb.append(')');
        return DB.execute((DBRoute)DBRoute.of((String)ER_DBKEY), (String)deleteSQLSb.toString(), (Object[])payeePkIds);
    }
}

