/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ReimburseReceiveEntry
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(ReimburseReceiveEntry.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshLoanType();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        PayeeServiceHelper.clearLimitInfo((IDataModel)this.getModel());
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (ErBillStatusEnum.A.toString().equals(billStatus) || ErBillStatusEnum.D.toString().equals(billStatus)) {
            this.refreshLoanType();
        }
        AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (StringUtils.equalsIgnoreCase((CharSequence)((String)this.getModel().getValue("billstatus")), (CharSequence)"A") && ((BigDecimal)this.getModel().getValue("monthsettleamount")).compareTo(BigDecimal.ZERO) > 0) {
            AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)this.getModel().getValue("loanchecktype")));
            AmountChangeUtil.showPayAmountLable((IDataModel)this.getModel(), (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
            this.getModel().setDataChanged(false);
        }
        this.multiReceiveControl();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Long companyId;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        String loanType = (String)model.getValue("loanchecktype");
        if (StringUtils.isEmpty((CharSequence)loanType) && (companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"))) != null) {
            loanType = (String)ErCommonUtils.getLoanCheckType((long)companyId);
            this.getModel().setValue("loanchecktype", (Object)loanType);
        }
        switch (propName) {
            case "tripappamount": {
                AmountChangeUtil.loanClearEntryChange((IFormView)view, (IDataModel)model, (String)loanType);
                AmountChangeUtil.refreshPayAmount((IFormView)view, (IDataModel)model, (String)loanType);
                AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
                break;
            }
            case "loanclearoriamount": {
                BigDecimal loanBalanceAMount = (BigDecimal)this.getModel().getValue("loanoribalanceamount", rowIndex);
                if (loanBalanceAMount.compareTo((BigDecimal)propValue) < 0) {
                    this.getModel().setValue("loanclearoriamount", valueSet[0].getOldValue(), rowIndex);
                    break;
                }
                if (StringUtils.equals((CharSequence)"1", (CharSequence)loanType)) {
                    if (!this.upDateTripCleAmountValidator(rowIndex)) {
                        return;
                    }
                    model.beginInit();
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)((BigDecimal)propValue), (String)"loanclearamount", (String)"loanexchangerate", (String)"loanentryquotetype", (int)rowIndex);
                    model.endInit();
                    view.updateView("loanclearamount", rowIndex);
                }
                AmountChangeUtil.refreshPayAmount((IFormView)view, (IDataModel)model, (String)loanType);
                AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
                BigDecimal totalClearLoanAmount = AmountUtils.getEntryAmount((IDataModel)model, (String)"clearloanentry", (String)"loanclearamount");
                model.setValue("checkloanamount", (Object)totalClearLoanAmount);
                break;
            }
            case "loanclearamount": {
                BigDecimal loanBalance = (BigDecimal)this.getModel().getValue("loanaccbalanceamount", rowIndex);
                if (loanBalance.compareTo((BigDecimal)propValue) < 0) {
                    this.getModel().setValue("loanclearamount", valueSet[0].getOldValue(), rowIndex);
                    break;
                }
                model.beginInit();
                BigDecimal loanexchangerate = (BigDecimal)model.getValue("loanexchangerate", rowIndex);
                BigDecimal loanclearamount = (BigDecimal)model.getValue("loanclearamount", rowIndex);
                BigDecimal loanclearoriamount = BigDecimal.ZERO;
                if (loanexchangerate.abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0) {
                    DynamicObject curClearLoanEntry = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("clearloanentry").get(rowIndex);
                    int precision = AmountUtils.getAmountFieldPrecision((DynamicObject)curClearLoanEntry, (String)"loanclearoriamount");
                    loanclearoriamount = AmountUtils.getOriAmount((BigDecimal)loanclearamount, (BigDecimal)loanexchangerate, (int)precision, (String)((String)model.getValue("loanentryquotetype", rowIndex)));
                }
                model.setValue("loanclearoriamount", (Object)loanclearoriamount, rowIndex);
                model.endInit();
                AmountChangeUtil.refreshPayAmount((IFormView)view, (IDataModel)model, (String)loanType);
                AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
                BigDecimal totalClearLoanAmount = AmountUtils.getEntryAmount((IDataModel)model, (String)"clearloanentry", (String)"loanclearamount");
                model.setValue("checkloanamount", (Object)totalClearLoanAmount);
                break;
            }
            case "monthsettleamount": {
                AmountChangeUtil.refreshPayAmount((IFormView)view, (IDataModel)model, (String)loanType);
                break;
            }
            case "encashamount": {
                AmountChangeUtil.refreshReceiveAmount((IFormView)view, (IDataModel)model, (BigDecimal)((BigDecimal)propValue), (String)loanType);
                model.setValue("notpayamount", (Object)((BigDecimal)propValue));
                AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
                break;
            }
            case "accountcurrency": {
                Map exchangeRateMap = AmountChangeUtil.refreshEnrtyExchangeRate((IDataModel)model, (IFormView)view, (DynamicObject)((DynamicObject)propValue));
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                String accQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateMap.get("quoteType")), (Object)"0");
                if (model.getProperty("accquotetype") != null) {
                    model.setValue("accquotetype", (Object)accQuoteType, rowIndex);
                }
                String isgetaccountcurrency = "0";
                if (model.getValue("company") != null) {
                    isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
                }
                if ("1".equals(isgetaccountcurrency) && model.getEntryRowCount("accountentry") == 1 && BigDecimal.ZERO.compareTo((BigDecimal)model.getValue("receiveamount", rowIndex)) == 0) {
                    BigDecimal encashAmount = AmountChangeUtil.getCashAmount((IDataModel)model);
                    model.beginInit();
                    model.setValue("receiveamount", (Object)encashAmount, rowIndex);
                    model.endInit();
                    this.getView().updateView("receiveamount", rowIndex);
                }
                model.setValue("accexchangerate", (Object)exchangeRate, rowIndex);
                break;
            }
            case "accexchangerate": {
                this.accExchangeRateChange(propValue, rowIndex, model, this.getView());
                break;
            }
            case "orireceiveamount": {
                this.orireceiveamountChange(propValue, rowIndex, model);
                break;
            }
            case "istravelers": 
            case "travelers": {
                this.multiReceiveControl();
                break;
            }
            case "currency": {
                AmountChangeUtil.refreshPayAmount((IFormView)view, (IDataModel)model, (String)loanType);
                AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
            }
        }
    }

    protected void orireceiveamountChange(Object propValue, int rowIndex, IDataModel model) {
        AmountChangeUtil.orireceiveamountChange((Object)propValue, (int)rowIndex, (IDataModel)model);
    }

    protected void accExchangeRateChange(Object propValue, int rowIndex, IDataModel model, IFormView view) {
        AmountChangeUtil.accExchangeRateChange((Object)propValue, (int)rowIndex, (IDataModel)model, (IFormView)view);
    }

    private void multiReceiveControl() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"multravelersrecipt"});
    }

    private void refreshLoanType() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            logger.info(((Object)((Object)this)).getClass().getName() + "->got company is null!");
            return;
        }
        Long companyid = (Long)company.getPkValue();
        Object loanCheckType = ErCommonUtils.getLoanCheckType((long)companyid);
        String loanType = loanCheckType == null ? "1" : loanCheckType.toString();
        boolean ischanged = this.getModel().getDataChanged();
        this.getModel().setValue("loanchecktype", (Object)loanType);
        this.getModel().setDataChanged(ischanged);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (entryName) {
            case "accountentry": {
                RowDataEntity[] rowDataEntities;
                if (model.getProperty("acccostcompany") == null) break;
                for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                    model.setValue("acccostcompany", model.getValue("costcompany"), rowDataEntity.getRowIndex());
                }
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        super.afterDeleteRow(e);
        IDataModel model = this.getModel();
        switch (entryName = e.getEntryProp().getName()) {
            case "tripentry": {
                this.refreshEncashedAmount(model);
                break;
            }
            case "accountentry": {
                AmountChangeUtil.handleDiiff((IDataModel)this.getModel(), (String)"accountentry", (String)"receiveamount", (String)"orireceiveamount", (String)"accexchangerate", (String)"currency");
            }
        }
    }

    protected void refreshEncashedAmount(IDataModel model) {
        Object checkType = this.getModel().getValue("loanchecktype");
        String loanCheckType = checkType == null ? "1" : checkType.toString();
        AmountChangeUtil.loanClearEntryChange((IFormView)this.getView(), (IDataModel)model, (String)loanCheckType);
        AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)model, (String)loanCheckType);
        BigDecimal payAmount = (BigDecimal)model.getValue("encashamount");
        AmountChangeUtil.showPayAmountLable((IDataModel)model, (Label)((Label)this.getControl("totalencashamountlabel")), (String)"encashamount");
        AmountChangeUtil.refreshReceiveAmount((IFormView)this.getView(), (IDataModel)model, (BigDecimal)payAmount, (String)loanCheckType);
    }

    private void whenTaxAmountChange(int tripEntryRowIndex, int tripItemRowIndex) {
        Boolean isOffset;
        DynamicObject itemRow;
        String tripItemEntityName = "entryentity";
        String parentEntityName = "tripentry";
        IDataModel model = this.getModel();
        DynamicObject parentRow = model.getEntryRowEntity("tripentry", tripEntryRowIndex);
        if (parentRow == null || parentRow.getDynamicObjectCollection("entryentity").isEmpty() || (itemRow = (DynamicObject)parentRow.getDynamicObjectCollection("entryentity").get(tripItemRowIndex)) == null) {
            return;
        }
        BigDecimal taxAmount = itemRow.getBigDecimal("taxamount");
        BigDecimal entryAmountOri = itemRow.getBigDecimal("orientryamount");
        BigDecimal noTaxAmout = entryAmountOri.subtract(taxAmount);
        model.beginInit();
        model.setValue("notaxamount", (Object)noTaxAmout, tripItemRowIndex, tripEntryRowIndex);
        model.endInit();
        Control noTaxAmountCtl = this.getView().getControl("notaxamount");
        int curParentRowIndex = model.getEntryCurrentRowIndex("tripentry");
        if (noTaxAmountCtl != null && curParentRowIndex == tripEntryRowIndex) {
            this.getView().updateView("notaxamount", tripItemRowIndex);
        }
        if ((isOffset = Boolean.valueOf(itemRow.getBoolean("offset"))).booleanValue()) {
            model.setValue("deductibletax", (Object)taxAmount, tripItemRowIndex, tripEntryRowIndex);
        } else {
            model.setValue("deductibletax", (Object)BigDecimal.ZERO, tripItemRowIndex, tripEntryRowIndex);
        }
        AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)tripEntryRowIndex);
    }

    private boolean upDateTripCleAmountValidator(int rowIndex) {
        Set currencyIds = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").stream().flatMap(card -> card.getDynamicObjectCollection("entryentity").stream()).map(row -> ErCommonUtils.getPk((Object)row.get("entrycurrency"))).collect(Collectors.toSet());
        BigDecimal clearAmount = (BigDecimal)this.getModel().getValue("loanclearoriamount", rowIndex);
        if (!currencyIds.contains(ErCommonUtils.getPk((Object)this.getModel().getValue("loancurrency", rowIndex))) && clearAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u4e0d\u5728\u5dee\u65c5\u660e\u7ec6\u4e2d\uff0c\u4e0d\u80fd\u51b2\u9500\u3002", (String)"ErReimburseBaseBillEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("loanclearoriamount", (Object)0.0, rowIndex);
            this.getModel().setValue("loanclearamount", (Object)0.0, rowIndex);
            return false;
        }
        return true;
    }
}

