/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.Copy;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.form.IFormController;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripReimOpenTypeUtils;
import kd.fi.er.common.model.UserCurrentDeptInfo;
import kd.fi.er.common.model.trip.TripReimburseOpenType;
import kd.fi.er.formplugin.web.CoreBaseBillList;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseBillList
extends CoreBaseBillList {
    private static final String CLOSE_CLOSE_KEY = "listNewOperationCreateBill";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String parameterStr;
        BillShowParameter billShowParameter = e.getParameter();
        Object billId = billShowParameter.getPkId();
        if (billId != null) {
            billShowParameter.setCustomParam("edit-from-list", (Object)true);
            super.beforeShowBill(e);
        }
        if ((parameterStr = this.getView().getPageCache().get("userInfo")) != null) {
            UserCurrentDeptInfo userInfo = (UserCurrentDeptInfo)JSON.parseObject((String)parameterStr, UserCurrentDeptInfo.class);
            String tripOpenType = TripReimOpenTypeUtils.getTripReimburseOpenType((Long)userInfo.getOldCompanyId(), (Long)userInfo.getCompanyId(), (Long)userInfo.getUserId());
            String formId = ErStdConfig.getExtTripReimFormId((String)TripReimburseOpenType.getTripReimburseOpenType((String)tripOpenType).getFormId());
            billShowParameter.setFormId(formId);
            billShowParameter.setCustomParam("userInfo", (Object)parameterStr);
            this.getView().getPageCache().remove("userInfo");
        }
        billShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), CLOSE_CLOSE_KEY));
    }

    @Override
    public void afterBindData(EventObject e) {
        String tripReimType = SystemParamterUtil.getTripReimburseTypeByCurrentUser();
        if (StringUtils.equals((CharSequence)tripReimType, (CharSequence)"card")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_newtripreim"});
        } else if (StringUtils.equals((CharSequence)tripReimType, (CharSequence)"grid")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_newtripreim"});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate source = (FormOperate)e.getSource();
        ListSelectedRowCollection listSelectedData = e.getListSelectedData();
        if (source instanceof Copy && listSelectedData != null && listSelectedData.size() == 1) {
            Long billTypeID;
            Copy copy = (Copy)source;
            if (StringUtils.equals((CharSequence)copy.getOperateKey(), (CharSequence)"copy") && (billTypeID = listSelectedData.get(0).getBillTypeID()) != null && !Objects.equals(billTypeID, 0L)) {
                String formId;
                DynamicObject billTypeDO = BusinessDataServiceHelper.loadSingleFromCache((Object)billTypeID, (String)"bos_billtype", (String)"id,layoutsolution");
                String layoutMetadatFormId = null;
                if (billTypeDO != null && StringUtils.isNotBlank((CharSequence)(layoutMetadatFormId = billTypeDO.getString("layoutsolution"))) && (formId = TripReimburseBillList.getNumberByMetadataId(layoutMetadatFormId)) != null) {
                    copy.setViewBillFormId(formId);
                }
            }
        } else if (StringUtils.equals((CharSequence)source.getOperateKey(), (CharSequence)"printpreview")) {
            OperateOption printOp = source.getOption();
            printOp.setVariableValue("BOS_AUDIT_CUSTOMAUDITVALUE", "E,F,G,H,I");
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("genbeforeshare".equalsIgnoreCase(args.getOperateKey())) {
            this.refreshList();
        }
    }

    private void refreshList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private static String getNumberByMetadataId(String metadataId) {
        DynamicObject metadata = BusinessDataServiceHelper.loadSingleFromCache((Object)metadataId, (String)"bos_formmeta", (String)"id,number");
        return metadata == null ? null : metadata.getString("number");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSE_CLOSE_KEY.equals(actionId)) {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.operate.New", "listoperation");
            CloseCallBackWraper closeCallBackWraper = new CloseCallBackWraper(this.getView().getPageId(), closeCallBack, this.getModel().getDataEntity().getPkValue(), true);
            IFormController srv = (IFormController)this.getView().getService(IFormController.class);
            srv.formClosedCallBack(closeCallBackWraper);
            UserCurrentDeptInfo userInfo = (UserCurrentDeptInfo)closedCallBackEvent.getReturnData();
            if (userInfo != null) {
                this.getView().getPageCache().put("userInfo", JSON.toJSONString((Object)userInfo));
                this.getView().invokeOperation("new");
            }
        }
        this.getView().invokeOperation("refresh");
    }
}

