/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.BillRelateUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripReimburseTypeControlUtils;
import kd.fi.er.business.utils.TripReqBillUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.web.CoreBaseBillList;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.BooleanUtils;

public class TripReqBillList
extends CoreBaseBillList {
    private static final String CONFIRM_AFTERTRIPCHANGE = "confrimtripchange";
    private static final String CONFIRM_AFTERTRIPREVOKE = "confrimtriprevoke";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("baritemap".equals(itemKey)) {
            if (this.getPageCache().get("isloan") != null) {
                return;
            }
            FormModel formModel = new FormModel("er_tripreqadd", ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355", (String)"TripReqBillList_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true);
            formModel.setShowType(ShowType.Modal);
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
            evt.setCancel(true);
        }
        if ("bar_pushpay".equals(itemKey)) {
            List reqBillList;
            String warningStr;
            int reqbilltoreimbursecount;
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() == 0) {
                return;
            }
            Object[] billsId = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            String tripreqbillProperties = String.join((CharSequence)",", "isloan", "tripentry.id", "billno", "istravelers", "company");
            DynamicObject[] tripreqbillsInfo = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)tripreqbillProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billsId)});
            Map<Object, Integer> reqToReimburseMap = Arrays.stream(tripreqbillsInfo).collect(Collectors.toMap(DataEntityBase::getPkValue, key -> SystemParamterUtil.getloancheckparam((long)Optional.ofNullable(ErCommonUtils.getPk((Object)key.getDynamicObject("company"))).orElseGet(() -> 0L), (String)"reqbilltoreimbursecount"), (a, b) -> a));
            if (tripreqbillsInfo.length == 1 && (reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam((long)Optional.ofNullable(ErCommonUtils.getPk((Object)tripreqbillsInfo[0].getDynamicObject("company"))).orElseGet(() -> 0L), (String)"reqbilltoreimbursecount")) == 0 && BillRelateUtils.existReimburse((DynamicObject)tripreqbillsInfo[0], (IFormView)this.getView())) {
                evt.setCancel(true);
                return;
            }
            List reqExistReimburseBills = Arrays.stream(tripreqbillsInfo).filter(bill -> !bill.getBoolean("isloan") && reqToReimburseMap.entrySet().stream().filter(entryset -> 0 == (Integer)entryset.getValue() && BillRelateUtils.getExistReimburseBills((Long)((Long)entryset.getKey())).stream().filter(key -> "A".equals(key.getString("billstatus")) || "D".equals(key.getString("billstatus"))).count() >= 1L).map(Map.Entry::getKey).collect(Collectors.toList()).contains(bill.getPkValue())).collect(Collectors.toList());
            if (reqExistReimburseBills.size() >= 1) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject row : reqExistReimburseBills) {
                    sb.append(row.getString("billno"));
                    sb.append(",");
                }
                evt.setCancel(true);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\u51fa\u5dee\u7533\u8bf7\u5355\u5df2\u7ecf\u751f\u6210\u4e86\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u6b21\u751f\u6210\u3002", (String)"TripReqBillList_18", (String)"fi-er-formplugin", (Object[])new Object[0]), sb.substring(0, sb.lastIndexOf(","))));
            }
            if (StringUtils.isNotBlank((CharSequence)(warningStr = TripNotReimbursedOrderUtil.getNotUsedOrderWarningStrByReq(reqBillList = Arrays.stream(tripreqbillsInfo).collect(Collectors.toList()))))) {
                evt.setCancel(true);
                this.getView().showTipNotification(warningStr);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("er_tripreqadd".equals(actionId) && e.getReturnData() != null) {
            Map returnData = (Map)e.getReturnData();
            Boolean isLoan = (Boolean)returnData.get("isloan");
            this.getPageCache().put("isloan", isLoan.toString());
            this.getView().invokeOperation("new");
            this.getPageCache().remove("isloan");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "tripchange": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                Object selectId = selectedRows.get(0).getPrimaryKeyValue();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CONFIRM_AFTERTRIPCHANGE, "true");
                OperationResult operationResult = this.getView().invokeOperation("tripchange", operateOption);
                if (!operationResult.isSuccess()) break;
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setFormId(((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
                formShowParameter.setBillStatus(BillOperationStatus.EDIT);
                formShowParameter.setPkId(selectId);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "triprevoke": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                Object selectId = selectedRows.get(0).getPrimaryKeyValue();
                int row = selectedRows.get(0).getRowKey();
                Long workId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)String.valueOf(selectId));
                List approveres = WorkflowServiceHelper.getApproverByBusinessKey((String)String.valueOf(selectId));
                if (workId != null && !workId.equals(0L) && !approveres.isEmpty()) {
                    WorkflowServiceHelper.abandon((Long)workId);
                    BillList list = (BillList)this.getControl("billlistap");
                    list.refresh();
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(CONFIRM_AFTERTRIPREVOKE, "true");
                try {
                    this.getView().invokeOperation("triprevoke", operateOption);
                }
                catch (KDException e) {
                    this.getView().showTipNotification(e.getMessage());
                }
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String isLoanStr = this.getPageCache().get("isloan");
        BillShowParameter billShowParameter = e.getParameter();
        Object billId = billShowParameter.getPkId();
        if (billId == null) {
            boolean isLoan = Boolean.parseBoolean(isLoanStr);
            if (BooleanUtils.toBooleanDefaultIfNull((Boolean)isLoan, (boolean)false)) {
                HashMap<String, Boolean> customParams = new HashMap<String, Boolean>();
                customParams.put("isloan", true);
                billShowParameter.setCustomParams(customParams);
                billShowParameter.setCaption(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355(\u501f)", (String)"TripReqBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        } else {
            DynamicObject reqbill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"isloan", (QFilter[])new QFilter[]{new QFilter("id", "=", billId)});
            if (reqbill != null && reqbill.getBoolean("isloan")) {
                billShowParameter.setCustomParam("isloan", (Object)true);
                billShowParameter.setCaption(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355(\u501f)", (String)"TripReqBillList_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Push push;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Push && StringUtils.equals((CharSequence)(push = (Push)source).getOperateKey(), (CharSequence)"pushreimburse")) {
            List selectedIds = args.getListSelectedData().stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
            if (TripReimburseTypeControlUtils.companyIsSame(selectedIds)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u51fa\u5dee\u7533\u8bf7\u5355\u7684\u7533\u8bf7\u4eba\u516c\u53f8\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TripReqBillList_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String formId = TripReimburseTypeControlUtils.getTripReqBillReimType(selectedIds, (boolean)false);
            push.getOption().setVariableValue("botp_push_target_bill_formid", formId);
            TripReimburseTypeControlUtils.setTripReqBillReimType(selectedIds);
        }
        String opKey = ((AbstractOperate)source).getOperateKey();
        Set<Long> selectedDatas = args.getListSelectedData().stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toSet());
        switch (opKey) {
            case "tripchange": {
                if (((FormOperate)source).getOption().tryGetVariableValue(CONFIRM_AFTERTRIPCHANGE, new RefObject())) break;
                if (!this.checkBeforeTripChange(selectedDatas)) {
                    args.setCancel(true);
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tripchange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u884c\u7a0b\u53d8\u66f4\u540e\uff0c\u6570\u636e\u65e0\u6cd5\u6062\u590d\u5230\u539f\u884c\u7a0b\u3002\u662f\u5426\u786e\u8ba4\u53d8\u66f4\uff1f", (String)"TripReqBillList_6", (String)"fi-er-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
            case "triprevoke": {
                if (selectedDatas.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u6761\u8bb0\u5f55\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u786e\u8ba4\u53ea\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"TripReqBillList_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (selectedDatas.size() == 1) {
                    ListSelectedRow row = args.getListSelectedData().get(0);
                    String entityName = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                    DynamicObject item = QueryServiceHelper.queryOne((String)entityName, (String)"ischange,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", row.getPrimaryKeyValue())});
                    if (!item.getBoolean("ischange")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u64cd\u4f5c\u6761\u4ef6\uff1a\u53ea\u6709\u8fdb\u884c\u8fc7\u53d8\u66f4\u7684\u5355\u636e\u624d\u5141\u8bb8\u64a4\u9500\u53d8\u66f4\u3002", (String)"TripReqBillList_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        break;
                    }
                    if (!item.getString("billstatus").equals("A") && !item.getString("billstatus").equals("D")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff1a\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u6216\u201c\u5ba1\u6838\u4e0d\u901a\u8fc7\u201d\u7684\u5355\u636e\u624d\u53ef\u64a4\u9500\u53d8\u66f4\u3002", (String)"TripReqBillList_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        break;
                    }
                }
                if (((FormOperate)source).getOption().tryGetVariableValue(CONFIRM_AFTERTRIPREVOKE, new RefObject())) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("triprevoke", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u64a4\u9500\u53d8\u66f4\u4f1a\u5c06\u6570\u636e\u6062\u590d\u5230\u539f\u884c\u7a0b\uff0c\u6b64\u8fc7\u7a0b\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u786e\u8ba4\u64a4\u9500\uff1f", (String)"TripReqBillList_8", (String)"fi-er-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if ("triprevoke".equalsIgnoreCase(opKey)) {
            OperationResult result = e.getOperationResult();
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u884c\u7a0b\u5df2\u6210\u529f\u64a4\u9500\u3002", (String)"TripReqBillList_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7a0b\u64a4\u9500\u5931\u8d25\u3002", (String)"TripReqBillList_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            BillList list = (BillList)this.getControl("billlistap");
            list.refresh();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean emParameter = TripSyncConfigUtil.getBoolean((String)"Reservation_ personnel_range");
        if (emParameter) {
            List metaItems = new ArrayList();
            IFormView view = this.getView();
            if (view instanceof ListView) {
                ListView listView = (ListView)view;
                String billFormId = listView.getBillFormId();
                try {
                    metaItems = TripReqBillUtil.getMetaItems((String)billFormId);
                }
                catch (Exception ex) {
                    metaItems = new ArrayList();
                }
            }
            Boolean existProp = TripReqBillUtil.judgeIsExistProp(metaItems, (String)"multitravelers");
            if (e.getSpecialDataPermQFilter() != null && existProp.booleanValue()) {
                QFilter qf = new QFilter("multitravelers.fbasedataid_id", "=", (Object)userId);
                e.getSpecialDataPermQFilter().or(qf);
            }
        }
    }

    private boolean checkBeforeTripChange(Set<Long> selectedDatas) {
        if (selectedDatas.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u9009\u51fa\u5dee\u7533\u8bf7\u5355\u8fdb\u884c\u884c\u7a0b\u53d8\u66f4\u3002", (String)"TripReqBillList_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long selectReqBillId = (Long)selectedDatas.stream().findFirst().get();
        DynamicObject reqBill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"billno,billstatus,isloan", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectReqBillId)});
        if (reqBill == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u65e0\u6cd5\u67e5\u8be2\u5230\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u5c1d\u8bd5\u3002", (String)"TripAutoOpenedListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!"E".equals(reqBill.get("billstatus")) && !reqBill.getBoolean("isloan")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5ba1\u6838\u901a\u8fc7\u201d\u7684\u51fa\u5dee\u7533\u8bf7\u5355\u624d\u80fd\u8fdb\u884c\u884c\u7a0b\u53d8\u66f4\u3002", (String)"TripReqBillList_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])Collections.singleton(selectReqBillId).toArray(new Long[0]));
        if (targetBills.isEmpty()) {
            return true;
        }
        HashSet targetBillIds = (HashSet)targetBills.get("er_tripreimbursebill");
        if (targetBillIds != null && !targetBillIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u51fa\u5dee\u7533\u8bf7\u5355\u5b58\u5728\u5df2\u5173\u8054\u7684\u5dee\u65c5\u62a5\u9500\u5355\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u884c\u7a0b\u3002", (String)"TripReqBillList_15", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

