/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tips;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.formplugin.daily.web.tips.ReimburseTipsUtils;
import org.apache.commons.lang3.StringUtils;

public class ReimburseTipsPlugin
extends AbstractBillPlugIn {
    Log log = LogFactory.getLog(ReimburseTipsPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lbl_showreimburtips", "lbl_closereimburtips", "alltipsflex"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshTips();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"lbl_showreimburtips")) {
            ReimburseTipsUtils.showDetailsControl((Boolean)Boolean.TRUE, (IFormView)view);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"lbl_closereimburtips")) {
            ReimburseTipsUtils.showDetailsControl((Boolean)Boolean.FALSE, (IFormView)view);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"alltipsflex")) {
            ReimburseTipsUtils.showSpecialOrTips((AbstractFormPlugin)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"company")) {
            this.refreshTips();
        }
    }

    private void refreshTips() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String detailTips = ReimburseTipsUtils.pageCacheTips((AbstractFormPlugin)this, (boolean)this.isMob());
        boolean isSpecialType = ReimburseTipsUtils.isSpecialType((IFormView)view, (IDataModel)model);
        if (this.isMob()) {
            ReimburseTipsUtils.refreshMobTips((boolean)isSpecialType, (String)detailTips, (IDataModel)model, (IFormView)view);
        } else {
            long lineNumber = 0L;
            if (detailTips != null) {
                LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(detailTips));
                try {
                    lineNumberReader.skip(Long.MAX_VALUE);
                }
                catch (IOException e) {
                    this.log.error("\u62a5\u9500\u63d0\u793a\u5185\u5bb9\u6709\u95ee\u9898", (Throwable)e);
                }
                lineNumber = lineNumberReader.getLineNumber() + 1;
            }
            if (lineNumber == 1L) {
                view.setVisible(Boolean.valueOf(false), new String[]{"lbl_closereimburtips", "lbl_showreimburtips", "text_tips"});
                view.setVisible(Boolean.valueOf(true), new String[]{"lbl_reimbursetips_simple"});
                ReimburseTipsUtils.refreshPcTips((boolean)false, (String)detailTips, (IDataModel)model, (IFormView)view);
            } else {
                ReimburseTipsUtils.showDetailsControl((Boolean)ReimburseTipsUtils.pageCacheDefaultShow((AbstractFormPlugin)this, (boolean)this.isMob()), (IFormView)view);
                ReimburseTipsUtils.refreshPcTips((boolean)isSpecialType, (String)detailTips, (IDataModel)model, (IFormView)view);
            }
        }
    }

    protected boolean isMob() {
        return false;
    }
}

