/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class TripAreaEdit
extends AbstractBasePlugIn
implements ClickListener,
RowClickEventListener {
    private static final String ADD_ENTRY = "addentry";
    private static final String CITY_F7 = "cityf7";
    private static final String DATE_GRID = "dateentry";
    private static final String START_MONTH = "startmonth";
    private static final String START_DAY = "startday";
    private static final String END_MONTH = "endmonth";
    private static final String END_DAY = "endday";
    private static final String ENTRY_TOOLBAR = "advcontoolbarap";
    private static final String CITY_STR = "citystr";
    private static final String CITY = "city";
    private static final Set<String> LUNAR_MONTH = Collections.unmodifiableSet(Arrays.stream(new String[]{"4", "6", "9", "11"}).collect(Collectors.toSet()));
    private static final Log log = LogFactory.getLog(TripAreaEdit.class);

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{ENTRY_TOOLBAR});
        BasedataEdit cityF7 = (BasedataEdit)this.getView().getControl(CITY_F7);
        cityF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject useOrg = (DynamicObject)this.getModel().getValue("createorg");
            log.info("\u57fa\u7ebf\u5355\u5143\u6d4b\u8bd5\u5f02\u5e38\u6392\u67e5, userOrg: " + useOrg);
            QFilter qFilter = new QFilter("iscity", "=", (Object)"1");
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity();
            Object currentId = dataEntity.getPkValue();
            if (currentId != null) {
                QFilter cityFilter = new QFilter("id", "!=", currentId);
                cityFilter.and("createorg", "=", useOrg.get("id"));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(cityFilter);
                DynamicObject[] assignCitys = BusinessDataServiceHelper.load((String)"er_triparea", (String)"id,entryentity.id,entryentity.city", (QFilter[])qFilters.toArray(new QFilter[0]));
                HashSet<Long> cityIds = new HashSet<Long>();
                for (DynamicObject tripAreas : assignCitys) {
                    DynamicObjectCollection cityEntrys = tripAreas.getDynamicObjectCollection("entryentity");
                    if (cityEntrys == null || cityEntrys.size() <= 0) continue;
                    for (DynamicObject cityEntry : cityEntrys) {
                        DynamicObject city = cityEntry.getDynamicObject(CITY);
                        if (city == null) continue;
                        cityIds.add((Long)city.getPkValue());
                    }
                }
                DynamicObjectCollection cityEntrys = model.getEntryEntity("entryentity");
                if (cityEntrys != null && cityEntrys.size() > 0) {
                    for (DynamicObject cityEntry : cityEntrys) {
                        DynamicObject city = cityEntry.getDynamicObject(CITY);
                        if (city == null) continue;
                        cityIds.add((Long)city.getPkValue());
                    }
                }
                if (cityIds.size() > 0) {
                    qFilter = qFilter.and(new QFilter("id", "not in", cityIds));
                }
            }
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DATE_GRID, START_MONTH, START_DAY, END_MONTH, END_DAY, "fs_baseinfo"});
        BasedataEdit cityF7 = (BasedataEdit)this.getControl(CITY);
        cityF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject useOrg = (DynamicObject)this.getModel().getValue("createorg");
            log.info("\u57fa\u7ebf\u5355\u5143\u6d4b\u8bd5\u5f02\u5e38\u6392\u67e5, userOrg: " + useOrg);
            QFilter qFilter = new QFilter("iscity", "=", (Object)"1");
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity();
            Object currentId = dataEntity.getPkValue();
            if (currentId != null) {
                QFilter cityFilter = new QFilter("id", "!=", currentId);
                cityFilter.and("createorg", "=", useOrg.get("id"));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(cityFilter);
                DynamicObject[] assignCitys = BusinessDataServiceHelper.load((String)"er_triparea", (String)"id,entryentity.id,entryentity.city", (QFilter[])qFilters.toArray(new QFilter[0]));
                HashSet<Long> cityIds = new HashSet<Long>();
                for (DynamicObject tripAreas : assignCitys) {
                    DynamicObjectCollection cityEntrys = tripAreas.getDynamicObjectCollection("entryentity");
                    if (cityEntrys == null || cityEntrys.size() <= 0) continue;
                    for (DynamicObject cityEntry : cityEntrys) {
                        DynamicObject city = cityEntry.getDynamicObject(CITY);
                        if (city == null) continue;
                        cityIds.add((Long)city.getPkValue());
                    }
                }
                DynamicObjectCollection cityEntrys = model.getEntryEntity("entryentity");
                if (cityEntrys != null && cityEntrys.size() > 0) {
                    for (DynamicObject cityEntry : cityEntrys) {
                        DynamicObject city = cityEntry.getDynamicObject(CITY);
                        if (city == null) continue;
                        cityIds.add((Long)city.getPkValue());
                    }
                }
                if (cityIds.size() > 0) {
                    qFilter = qFilter.and(new QFilter("id", "not in", cityIds));
                }
            }
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "addentry": {
                BasedataEdit cityF7 = (BasedataEdit)this.getControl(CITY_F7);
                IDataModel model = this.getModel();
                model.setValue(CITY_F7, null);
                cityF7.click();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object propValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "startmonth": 
            case "endmonth": 
            case "startday": 
            case "endday": {
                if (propValue == null) break;
                if (this.validateDate(rowIndex, propName, (String)changeSet[0].getOldValue())) {
                    this.initDay(propName, (String)propValue, rowIndex);
                }
                if (!StringUtils.equalsAny((CharSequence)propName, (CharSequence[])new CharSequence[]{START_DAY, END_DAY})) break;
                this.dayValidate(propName, changeSet[0], rowIndex);
                break;
            }
            case "cityf7": {
                DynamicObjectCollection citys = (DynamicObjectCollection)propValue;
                if (citys.size() <= 0) break;
                int[] rowIndexs = model.batchCreateNewEntryRow("entryentity", citys.size());
                int is = rowIndexs.length;
                for (int i = 0; i < is; ++i) {
                    DynamicObject tmpCity = (DynamicObject)citys.get(i);
                    int index = rowIndexs[i];
                    DynamicObject city = tmpCity.getDynamicObject("FBaseDataId");
                    model.setValue(CITY, city.getPkValue(), index);
                }
                break;
            }
        }
    }

    private void initDay(String propName, String propValue, int rowIndex) {
        if (StringUtils.equals((CharSequence)propName, (CharSequence)START_MONTH)) {
            String startDay = (String)this.getModel().getValue(START_DAY, rowIndex);
            if (startDay == null || LUNAR_MONTH.contains(propValue) && StringUtils.equals((CharSequence)startDay, (CharSequence)"31") || StringUtils.equals((CharSequence)propValue, (CharSequence)"2") && StringUtils.equalsAny((CharSequence)startDay, (CharSequence[])new CharSequence[]{"30", "31"})) {
                this.getModel().setValue(START_DAY, (Object)"1", rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)END_MONTH)) {
            if (LUNAR_MONTH.contains(propValue)) {
                this.getModel().setValue(END_DAY, (Object)"30", rowIndex);
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)propValue)) {
                this.getModel().setValue(END_DAY, (Object)"29", rowIndex);
            } else {
                this.getModel().setValue(END_DAY, (Object)"31", rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            int citystrFieldLength;
            IDataModel model = this.getModel();
            DynamicObjectCollection collection = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
            collection.removeIf(m -> m.get(CITY) == null);
            int entryRowCount = model.getEntryRowCount("entryentity");
            ArrayList<String> cityNames = new ArrayList<String>();
            for (int i = 0; i < entryRowCount && i <= 80; ++i) {
                DynamicObject city = (DynamicObject)model.getValue(CITY, i);
                if (city == null) continue;
                cityNames.add(city.getLocaleString("name").getLocaleValue());
            }
            String cityStr = StringUtils.join(cityNames, (String)"\u3001");
            int cityNamesLength = cityStr.length();
            if (cityNamesLength > (citystrFieldLength = 255)) {
                cityStr = cityStr.substring(0, citystrFieldLength);
            }
            model.setValue(CITY_STR, (Object)cityStr);
            model.updateCache();
            this.getView().updateView("entryentity");
        }
    }

    private boolean validateDate(int rowIndex, String propName, String oldValue) {
        String dateTemplate = "yyyy-MM-dd";
        String startMonth = (String)this.getModel().getValue(START_MONTH, rowIndex);
        String startDay = (String)this.getModel().getValue(START_DAY, rowIndex);
        String endMonth = (String)this.getModel().getValue(END_MONTH, rowIndex);
        String endDay = (String)this.getModel().getValue(END_DAY, rowIndex);
        if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{startMonth, startDay, endDay, endDay})) {
            return true;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateTemplate);
            Date startDate = dateFormat.parse("2020" + "-" + startMonth + "-" + startDay);
            Date endDate = dateFormat.parse("2020" + "-" + endMonth + "-" + endDay);
            if (endDate.before(startDate)) {
                if (StringUtils.equals((CharSequence)END_DAY, (CharSequence)propName)) {
                    this.getModel().setValue(END_DAY, (Object)oldValue, rowIndex);
                } else {
                    this.getModel().setValue(END_MONTH, null, rowIndex);
                    this.getModel().setValue(END_DAY, null, rowIndex);
                }
            }
        }
        catch (ParseException e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)out, true));
            String errMsg = out.toString();
            log.error(errMsg);
        }
        return true;
    }

    private void dayValidate(String propName, ChangeData changeData, int rowIndex) {
        String monthName = StringUtils.equals((CharSequence)propName, (CharSequence)START_DAY) ? START_MONTH : END_MONTH;
        String month = (String)this.getModel().getValue(monthName, rowIndex);
        if (StringUtils.equals((CharSequence)((String)changeData.getNewValue()), (CharSequence)"31") && StringUtils.equalsAny((CharSequence)month, (CharSequence[])new CharSequence[]{"4", "6", "9", "11"}) || StringUtils.equalsAny((CharSequence)((String)changeData.getNewValue()), (CharSequence[])new CharSequence[]{"30", "31"}) && StringUtils.equals((CharSequence)month, (CharSequence)"2")) {
            this.getModel().setValue(propName, changeData.getOldValue(), rowIndex);
            this.getView().updateView(propName, rowIndex);
        }
    }
}

