/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.common.type.AircraftCabinEnum;
import kd.fi.er.common.type.ShipCabinEnum;
import kd.fi.er.common.type.StandardTypeEnum;
import kd.fi.er.common.type.TrainCabinEnum;
import org.apache.commons.lang.StringUtils;

public class TripStandardVehicleEdit
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.displayViewByStandardType();
        this.getModel().setValue("includeperson", (Object)ResManager.loadKDString((String)"\u672a\u6dfb\u52a0", (String)"TripStandardAccomdationEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit reimLevelSelect = (BasedataEdit)this.getControl("reimburselevel");
        reimLevelSelect.addBeforeF7SelectListener(listener -> {
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            ListShowParameter tripStandard = (ListShowParameter)listener.getFormShowParameter();
            if (createOrg != null) {
                QFilter baseDataProFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_reimburselevel", (Long)createOrg.getLong("id"));
                if (null != baseDataProFilter) {
                    tripStandard.getListFilterParameter().setFilter(baseDataProFilter);
                }
            } else {
                tripStandard.getListFilterParameter().setFilter(new QFilter("1", "!=", (Object)"1"));
            }
        });
    }

    private void displayViewByStandardType() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String standardType = (String)formShowParameter.getCustomParam("standardtype");
        if (standardType == null) {
            standardType = (String)this.getModel().getValue("standardtype");
        }
        IBillModel iBillModel = (IBillModel)this.getModel();
        if (standardType != null && !iBillModel.isFromImport()) {
            this.getModel().setValue("standardtype", (Object)standardType);
        }
        if (StandardTypeEnum.AIR.getName().equalsIgnoreCase(standardType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_plane"});
        } else if (StandardTypeEnum.TRAIN.getName().equalsIgnoreCase(standardType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_train"});
        } else if (StandardTypeEnum.SHIP.getName().equalsIgnoreCase(standardType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_ship"});
        }
    }

    public void afterLoadData(EventObject e) {
        this.displayViewByStandardType();
        IDataModel model = this.getModel();
        String standardType = (String)model.getValue("standardtype");
        String cabinStr = (String)model.getValue("cabin");
        if (!StringUtils.isBlank((String)cabinStr)) {
            String[] cabinArray;
            for (String s : cabinArray = cabinStr.split(",")) {
                if (!StringUtils.isNotEmpty((String)s)) continue;
                model.setValue(standardType + "-" + s, (Object)true);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        IDataModel model = this.getModel();
        if (key != null && key.startsWith("air")) {
            AircraftCabinEnum[] aircraftCabinEnums;
            if (!((Boolean)propValue).booleanValue()) {
                return;
            }
            this.getModel().beginInit();
            int number = Integer.parseInt(key.substring(4, key.length()));
            for (AircraftCabinEnum aircraftCabinEnum : aircraftCabinEnums = AircraftCabinEnum.values()) {
                int enumNum = Integer.parseInt(aircraftCabinEnum.getName().substring(4, key.length()));
                if (enumNum <= number) continue;
                model.setValue(aircraftCabinEnum.getName(), propValue);
            }
            this.getModel().endInit();
            this.getView().updateView();
        } else if (key != null && key.startsWith("train")) {
            if (((Boolean)propValue).booleanValue()) {
                TrainCabinEnum[] trainCabinEnums;
                this.getModel().beginInit();
                int number = Integer.parseInt(key.substring(6, key.length()));
                for (TrainCabinEnum trainCabinEnum : trainCabinEnums = TrainCabinEnum.values()) {
                    int enumNum;
                    if (TrainCabinEnum.SPECIAL_SEAT.getName().equalsIgnoreCase(key) && TrainCabinEnum.BUSINESSSEAT.getName().equals(trainCabinEnum.getName()) || (enumNum = Integer.parseInt(trainCabinEnum.getName().substring(6, key.length()))) <= number) continue;
                    model.setValue(trainCabinEnum.getName(), propValue);
                }
                if (TrainCabinEnum.BUSINESSSEAT.getName().equals(key)) {
                    model.setValue(TrainCabinEnum.SPECIAL_SEAT.getName(), propValue);
                }
                this.getModel().endInit();
                this.getView().updateView();
            }
        } else if (key != null && key.startsWith("ship") && ((Boolean)propValue).booleanValue()) {
            ShipCabinEnum[] ShipCabinEnums;
            this.getModel().beginInit();
            int number = Integer.parseInt(key.substring(5, key.length()));
            for (ShipCabinEnum shipCabinEnum : ShipCabinEnums = ShipCabinEnum.values()) {
                int enumNum = Integer.parseInt(shipCabinEnum.getName().substring(5, key.length()));
                if (enumNum <= number) continue;
                model.setValue(shipCabinEnum.getName(), propValue);
            }
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            IDataModel model = this.getModel();
            StringBuilder valueBuilder = new StringBuilder();
            StringBuilder nameBuilder = new StringBuilder();
            boolean choiceFlag = true;
            String standardtype = (String)this.getModel().getValue("standardtype");
            if (StringUtils.equalsIgnoreCase((String)standardtype, (String)"air")) {
                AircraftCabinEnum[] aircraftCabinEnums;
                for (AircraftCabinEnum aircraftCabinEnum : aircraftCabinEnums = AircraftCabinEnum.values()) {
                    String airCraftName = aircraftCabinEnum.getName();
                    boolean isChoiced = (Boolean)model.getValue(airCraftName);
                    if (!isChoiced) continue;
                    choiceFlag = false;
                    this.getNameAndValue(valueBuilder, nameBuilder, airCraftName);
                }
            } else if (StringUtils.equalsIgnoreCase((String)standardtype, (String)"ship")) {
                ShipCabinEnum[] shipCabinEnums;
                for (ShipCabinEnum shipCabinEnum : shipCabinEnums = ShipCabinEnum.values()) {
                    String airName = shipCabinEnum.getName();
                    boolean isChoiced = (Boolean)model.getValue(airName);
                    if (!isChoiced) continue;
                    choiceFlag = false;
                    this.getNameAndValue(valueBuilder, nameBuilder, airName);
                }
            } else if (StringUtils.equalsIgnoreCase((String)standardtype, (String)"train")) {
                TrainCabinEnum[] trainCabinEnums;
                for (TrainCabinEnum trainCabinEnum : trainCabinEnums = TrainCabinEnum.values()) {
                    String trainName = trainCabinEnum.getName();
                    boolean isChoiced = (Boolean)model.getValue(trainName);
                    if (!isChoiced) continue;
                    choiceFlag = false;
                    this.getNameAndValue(valueBuilder, nameBuilder, trainName);
                }
            }
            if (nameBuilder.length() > 0) {
                model.setValue("cabinstr", (Object)nameBuilder.substring(0, nameBuilder.length() - 1));
            }
            if (valueBuilder.length() > 0) {
                model.setValue("cabin", (Object)valueBuilder.substring(0, valueBuilder.length() - 1));
            }
            if (choiceFlag) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8231\u4f4d", (String)"TripStandardVehicleEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void getNameAndValue(StringBuilder value, StringBuilder name, String beHandleStr) {
        String[] airCraft_values = beHandleStr.split("-");
        String airCraft = airCraft_values[0];
        String airCraftValue = airCraft_values[1];
        value.append(airCraftValue).append(',');
        name.append(this.getDesc(airCraft, beHandleStr)).append(',');
    }

    private String getDesc(String type, String propName) {
        String desc = "";
        block5 : switch (type) {
            case "air": {
                AircraftCabinEnum[] values;
                for (AircraftCabinEnum aircraftCabin : values = AircraftCabinEnum.values()) {
                    if (!aircraftCabin.getName().equals(propName)) continue;
                    desc = aircraftCabin.getValue();
                    break block5;
                }
                break;
            }
            case "train": {
                TrainCabinEnum[] trainCabinValues;
                for (TrainCabinEnum cabin : trainCabinValues = TrainCabinEnum.values()) {
                    if (!cabin.getName().equals(propName)) continue;
                    desc = cabin.getValue();
                    break block5;
                }
                break;
            }
            case "ship": {
                ShipCabinEnum[] shipCabinValues;
                for (ShipCabinEnum cabin : shipCabinValues = ShipCabinEnum.values()) {
                    if (!cabin.getName().equals(propName)) continue;
                    desc = cabin.getValue();
                    break block5;
                }
                break;
            }
        }
        return desc;
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs eventArgs) {
        Map searchResult = eventArgs.getSearchResult();
        for (Map.Entry entry : searchResult.entrySet()) {
            if (!StringUtils.equals((String)"er_reimburselevel", (String)((BasedataItem)entry.getKey()).getEntityNumber()) || !StringUtils.equals((String)"reimburselevel", (String)((BasedataItem)entry.getKey()).getFieldKey())) continue;
            List items = (List)entry.getValue();
            long createOrgId = ((DynamicObject)this.getModel().getValue("createorg")).getLong("id");
            QFilter qFilter = new QFilter("id", "in", (Object)items.toArray(new Object[items.size()]));
            qFilter.and("createorg", "=", (Object)createOrgId);
            DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)"er_reimburselevel", (String)"id,createorg", (QFilter[])new QFilter[]{qFilter});
            List oneItem = items.stream().filter(item -> ((Long)item).equals(baseData.getLong("id"))).collect(Collectors.toList());
            entry.setValue(oneItem);
        }
    }
}

