/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.opplugin.AssetCatNode;

public class AssetCategoryValidator {
    private static final Log log = LogFactory.getLog(AssetCategoryValidator.class);
    private static final String[] INCLUDEPROPS = new String[]{"assetcat", "depreeffect", "depretime", "decpolicy", "nodepre"};

    public String[] validate(DynamicObject depreSystemObj) {
        DynamicObjectCollection depreSystemAssetpolicy_entryCollection = depreSystemObj.getDynamicObjectCollection("assetpolicy_entry");
        if (depreSystemAssetpolicy_entryCollection.stream().anyMatch(v -> v.getDynamicObject("assetcat") == null)) {
            return new String[]{ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u8d44\u4ea7\u7c7b\u522b\u201d\u3002", (String)"AssetCategoryValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0])};
        }
        Set<String> assetCatNumbers = depreSystemAssetpolicy_entryCollection.stream().map(v -> v.getDynamicObject("assetcat").getString("number")).collect(Collectors.toSet());
        long createOrgId = depreSystemObj.getLong("createorg_id");
        Map<String, List<String>> assetCatNumMap = depreSystemAssetpolicy_entryCollection.stream().map(v -> v.getDynamicObject("assetcat").getString("number")).collect(Collectors.groupingBy(v -> v));
        HashSet<String> exitAssetNum = new HashSet<String>(assetCatNumMap.size());
        for (Map.Entry<String, List<String>> entry : assetCatNumMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            exitAssetNum.add(entry.getKey());
        }
        if (!exitAssetNum.isEmpty()) {
            return new String[]{String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7c7b\u522b\u7f16\u7801\uff1a%s\u3002", (String)"AssetCategoryValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), exitAssetNum)};
        }
        log.info("AssetCategoryValidator createorg_id is " + createOrgId);
        List<AssetCatNode> nodeLst = this.queryAllCategory(createOrgId);
        this.validateAssetCat(assetCatNumbers, nodeLst);
        ArrayList<String> errMsgLst = new ArrayList<String>();
        for (AssetCatNode node : nodeLst) {
            if (node.checked) continue;
            errMsgLst.add(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u4ea7\u7c7b\u522b\u201c%s\u201d\u3002", (String)"AssetCategoryValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), node.number));
        }
        return errMsgLst.toArray(new String[0]);
    }

    private boolean exitDiffer(DynamicObject assetcat, DynamicObject newAssetcat) {
        List properties = assetcat.getDataEntityType().getProperties().stream().filter(v -> Arrays.asList(INCLUDEPROPS).contains(v.getName())).collect(Collectors.toList());
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if (newAssetcat.get(propertyName) == null) continue;
            if (property instanceof BasedataProp) {
                String newCatNum = newAssetcat.getDynamicObject(propertyName).getString("number");
                String number = assetcat.getDynamicObject(propertyName).getString("number");
                if (number.equals(newCatNum)) continue;
                return true;
            }
            if (assetcat.getString(propertyName).equals(newAssetcat.getString(propertyName))) continue;
            return true;
        }
        return false;
    }

    protected void validateAssetCat(Set<String> assetCatNumbers, List<AssetCatNode> nodeLst) {
        this.checkCatNodes(assetCatNumbers, nodeLst);
        this.buildRelationship(nodeLst);
        nodeLst.forEach(AssetCatNode::validate);
    }

    protected void buildRelationship(List<AssetCatNode> nodeLst) {
        List<AssetCatNode> root = nodeLst.stream().filter(v -> v.parentId == 0L).collect(Collectors.toList());
        this.buildTree(nodeLst, root);
    }

    private void buildTree(List<AssetCatNode> nodeLst, List<AssetCatNode> rootLst) {
        for (AssetCatNode root : rootLst) {
            List<AssetCatNode> childNodeLst = nodeLst.stream().filter(v -> v.parentId == root.id).collect(Collectors.toList());
            nodeLst.removeAll(childNodeLst);
            this.buildTree(nodeLst, childNodeLst);
            root.addChildren(childNodeLst);
        }
    }

    protected void checkCatNodes(Set<String> assetCatNumbers, List<AssetCatNode> nodeLst) {
        nodeLst.stream().filter(v -> assetCatNumbers.contains(v.number)).forEach(v -> v.check());
    }

    private List<AssetCatNode> queryAllCategory(long createOrgId) {
        QFilter enableTrue = new QFilter("enable", "=", (Object)true);
        QFilter createOrgF = BaseDataServiceHelper.getBaseDataFilter((String)"fa_assetcategory", (Long)createOrgId);
        DynamicObjectCollection assetcategorys = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id,parent,number", (QFilter[])new QFilter[]{enableTrue, createOrgF});
        ArrayList<AssetCatNode> nodeLst = new ArrayList<AssetCatNode>();
        for (DynamicObject assetcategory : assetcategorys) {
            long fid = assetcategory.getLong("id");
            long fParentId = assetcategory.getLong("parent");
            String fnumber = assetcategory.getString("number");
            nodeLst.add(new AssetCatNode(fid, fParentId, fnumber));
        }
        return nodeLst;
    }
}

