/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.TypeConverUtil;
import kd.fi.fa.opplugin.AssetCategoryValidator;

public class AssetPolicySavePlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                switch (this.getOperateKey()) {
                    case "save": {
                        this.checkReferenceRelationship(dataEntities);
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            DynamicObject depreSystemObj = dataEntity.getDataEntity();
                            List<String> validateNodepre = new AssetPolicySavePlugin().validateNodepre(depreSystemObj);
                            for (String s : validateNodepre) {
                                this.setOperationName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AssetPolicySavePlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                                this.addMessage(dataEntity, s);
                            }
                            String[] errMsgs = new AssetCategoryValidator().validate(depreSystemObj);
                            for (int i = 0; i < errMsgs.length; ++i) {
                                this.setOperationName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AssetPolicySavePlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                                this.addMessage(dataEntity, errMsgs[i]);
                            }
                            DynamicObjectCollection assetPolicyEntry = depreSystemObj.getDynamicObjectCollection("assetpolicy_entry");
                            Map errorMsgMap = AssetPolicySavePlugin.this.checkExpectUse(assetPolicyEntry);
                            errorMsgMap.forEach((assetCatNumber, errorMsg) -> this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b\u7f16\u7801\uff1a%1$s\uff0c\u5b58\u5728\u4ee5\u4e0b\u9519\u8bef\uff1a%2$s", (String)"AssetPolicySavePlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetCatNumber, errorMsg)));
                        }
                        break;
                    }
                }
            }

            private void checkReferenceRelationship(ExtendedDataEntity[] dataEntities) {
                HashMap updateImportDepreSystemId2AssetCatListMap = new HashMap(16);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObjectCollection assetPolicyEntry;
                    DynamicObject depreSystemObj = dataEntity.getDataEntity();
                    Long depreSystemId = 0L;
                    Object pkValue = depreSystemObj.getPkValue();
                    if (Objects.nonNull(pkValue)) {
                        depreSystemId = (Long)pkValue;
                    }
                    if ((assetPolicyEntry = depreSystemObj.getDynamicObjectCollection("assetpolicy_entry")).size() == 0) continue;
                    List assetCatList = assetPolicyEntry.stream().filter(dynamicObject -> Objects.nonNull(dynamicObject.getPkValue()) && (Long)dynamicObject.getPkValue() != 0L).collect(Collectors.toList());
                    boolean fromDatabase = dataEntity.getDataEntity().getDataEntityState().getFromDatabase();
                    if (!fromDatabase || assetCatList.size() <= 0) continue;
                    updateImportDepreSystemId2AssetCatListMap.put(depreSystemId, assetCatList);
                }
                if (updateImportDepreSystemId2AssetCatListMap.size() == 0) {
                    return;
                }
                HashSet assetCatIdSet = new HashSet(16);
                Set depreSystemIdSet = updateImportDepreSystemId2AssetCatListMap.keySet();
                for (List value : updateImportDepreSystemId2AssetCatListMap.values()) {
                    assetCatIdSet.addAll(value.stream().map(assetPolicyDynObj -> (Long)assetPolicyDynObj.getDynamicObject("assetcat").getPkValue()).collect(Collectors.toList()));
                }
                Map depreSystemAndCatBatchMap = AssetPolicyUtil.getByDepreSystemAndCatBatch(depreSystemIdSet, assetCatIdSet);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    HashMap<Long, String> changeCatId2assetNumberMap = new HashMap<Long, String>(16);
                    DynamicObject depreSystemObj = dataEntity.getDataEntity();
                    Long depreSystemId = 0L;
                    Object pkValue = depreSystemObj.getPkValue();
                    if (Objects.nonNull(pkValue)) {
                        depreSystemId = (Long)pkValue;
                    }
                    Map dbMap = (Map)depreSystemAndCatBatchMap.get(depreSystemId);
                    List importDataAssetPolicyDynObjList = (List)updateImportDepreSystemId2AssetCatListMap.get(depreSystemId);
                    for (DynamicObject importAssetPolicyDynObj : importDataAssetPolicyDynObjList) {
                        Long assetId;
                        DynamicObject dbAssetPolicyDynObj;
                        String assetNumber = AssetPolicySavePlugin.this.checkValueChange(importAssetPolicyDynObj, dbAssetPolicyDynObj = (DynamicObject)dbMap.get(assetId = (Long)importAssetPolicyDynObj.getDynamicObject("assetcat").getPkValue()));
                        if (!Objects.nonNull(assetNumber)) continue;
                        Long catId = (Long)importAssetPolicyDynObj.getDynamicObject("assetcat").getPkValue();
                        changeCatId2assetNumberMap.put(catId, assetNumber);
                    }
                    DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)"org.id", (QFilter[])new QFilter("depresystem", "=", (Object)depreSystemId).toArray());
                    Set<Object> orgIds = books.stream().map(v -> v.get("org.id")).collect(Collectors.toSet());
                    HashSet orgIdList = new HashSet();
                    orgIds.forEach(r -> orgIdList.add(TypeConverUtil.ObjToLong((Object)r)));
                    Set changeCatIdSet = changeCatId2assetNumberMap.keySet();
                    String number = Fa.dot((String[])new String[]{"assetcat", "number"});
                    String selectFields = Fa.comma((String[])new String[]{number});
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])new QFilter("assetcat", "in", changeCatIdSet).and(new QFilter("org", "in", orgIdList)).toArray());
                    HashSet<String> errorAssetNumberSet = new HashSet<String>(dynamicObjectCollection.size());
                    for (DynamicObject dynamicObject2 : dynamicObjectCollection) {
                        errorAssetNumberSet.add(dynamicObject2.getString(number));
                    }
                    if (errorAssetNumberSet.size() <= 0) continue;
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b\uff1a%s \u5df2\u88ab\u5361\u7247\u5f15\u7528\uff0c\u4e0d\u53ef\u4fee\u6539\u8d44\u4ea7\u653f\u7b56\u3002", (String)"AssetPolicySavePlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", errorAssetNumberSet));
                    this.addMessage(dataEntity, errorMsg);
                }
            }
        });
    }

    private String checkValueChange(DynamicObject importAssetPolicyDynObj, DynamicObject dbAssetPolicyDynObj) {
        String dbDepreMethodNumber;
        String importDepreMethodNumber;
        boolean dbNoDepre;
        boolean importNoDepre;
        String dbWorkLoadUnitNumber;
        String importWorkLoadUnitNumber;
        Object dbObj;
        String assetCatNumber = importAssetPolicyDynObj.getDynamicObject("assetcat").getString("number");
        boolean isHaveChange = Boolean.FALSE;
        Object importObj = importAssetPolicyDynObj.get("workloadunit");
        if (this.isOneNullAndOneNotNull(importObj, dbObj = dbAssetPolicyDynObj.get("workloadunit"))) {
            if (Objects.isNull(dbObj) && Objects.nonNull(importObj)) {
                isHaveChange = Boolean.FALSE;
            }
            if (Objects.nonNull(dbObj) && Objects.isNull(importObj)) {
                isHaveChange = Boolean.TRUE;
            }
        } else if (this.isAllNotNull(importObj, dbObj) && !(importWorkLoadUnitNumber = ((DynamicObject)importObj).getString("number")).equals(dbWorkLoadUnitNumber = ((DynamicObject)dbObj).getString("number"))) {
            isHaveChange = Boolean.TRUE;
        }
        if (this.isOneNullAndOneNotNull(importObj = importAssetPolicyDynObj.get("nodepre"), dbObj = dbAssetPolicyDynObj.get("nodepre"))) {
            isHaveChange = Boolean.TRUE;
        } else if (this.isAllNotNull(importObj, dbObj) && (importNoDepre = ((Boolean)importObj).booleanValue()) != (dbNoDepre = ((Boolean)dbObj).booleanValue())) {
            isHaveChange = Boolean.TRUE;
        }
        importObj = importAssetPolicyDynObj.get("depremethod");
        dbObj = dbAssetPolicyDynObj.get("depremethod");
        if (this.isOneNullAndOneNotNull(importObj, dbObj)) {
            isHaveChange = Boolean.TRUE;
        } else if (this.isAllNotNull(importObj, dbObj) && !(importDepreMethodNumber = ((DynamicObject)importObj).getString("number")).equals(dbDepreMethodNumber = ((DynamicObject)dbObj).getString("number"))) {
            isHaveChange = Boolean.TRUE;
        }
        importObj = importAssetPolicyDynObj.get("depretime");
        dbObj = dbAssetPolicyDynObj.get("depretime");
        if (this.isStringNotEquals(importObj, dbObj)) {
            isHaveChange = Boolean.TRUE;
        }
        if (this.isStringNotEquals(importObj = importAssetPolicyDynObj.get("depreeffect"), dbObj = dbAssetPolicyDynObj.get("depreeffect"))) {
            isHaveChange = Boolean.TRUE;
        }
        if (this.isStringNotEquals(importObj = importAssetPolicyDynObj.get("decpolicy"), dbObj = dbAssetPolicyDynObj.get("decpolicy"))) {
            isHaveChange = Boolean.TRUE;
        }
        if (isHaveChange) {
            return assetCatNumber;
        }
        return null;
    }

    private boolean isAllNotNull(Object a, Object b) {
        return Objects.nonNull(b) && Objects.nonNull(a);
    }

    private boolean isOneNullAndOneNotNull(Object a, Object b) {
        return Objects.isNull(a) && Objects.nonNull(b) || Objects.isNull(b) && Objects.nonNull(a);
    }

    private boolean isStringNotEquals(Object a, Object b) {
        if (Objects.isNull(a) && Objects.isNull(b)) {
            return Boolean.FALSE;
        }
        if (Objects.nonNull(a) && "".equals(a.toString()) && Objects.isNull(b)) {
            return Boolean.FALSE;
        }
        if (Objects.nonNull(b) && "".equals(b.toString()) && Objects.isNull(a)) {
            return Boolean.FALSE;
        }
        if (Objects.nonNull(a) && Objects.nonNull(b)) {
            return !a.toString().equals(b);
        }
        return Boolean.TRUE;
    }

    private Map<String, String> checkExpectUse(DynamicObjectCollection assetPolicyEntry) {
        HashMap<String, String> errorMsgSet = new HashMap<String, String>(16);
        if (Objects.nonNull(assetPolicyEntry) && assetPolicyEntry.size() > 0) {
            for (DynamicObject assetPolicyDynObj : assetPolicyEntry) {
                Object depreMethod = assetPolicyDynObj.get("depremethod");
                Object workLoadUnit = assetPolicyDynObj.get("workloadunit");
                Object expectUse = assetPolicyDynObj.get("expectuse");
                HashSet<String> errorSet = new HashSet<String>(16);
                int unitPrecision = 0;
                if (Objects.nonNull(depreMethod)) {
                    if ("5".equals(((DynamicObject)depreMethod).getString("type"))) {
                        if (Objects.nonNull(workLoadUnit)) {
                            unitPrecision = ((DynamicObject)workLoadUnit).getInt("precision");
                        }
                    } else if (Objects.nonNull(workLoadUnit)) {
                        errorSet.add(ResManager.loadKDString((String)"\u975e\u5de5\u4f5c\u91cf\u6cd5\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5de5\u4f5c\u91cf\u5355\u4f4d\u3002", (String)"AssetPolicySavePlugin_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                }
                if (Objects.nonNull(expectUse)) {
                    BigDecimal expectUseBigDecimal = (BigDecimal)expectUse;
                    if (expectUseBigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                        errorSet.add(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u9884\u8ba1\u5bff\u547d\u5fc5\u987b\u5927\u4e8e\u96f6\u3002", (String)"AssetPolicySavePlugin_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    String expectUseStr = expectUseBigDecimal.stripTrailingZeros().toPlainString();
                    int expectUsePrecision = 0;
                    if (expectUseStr.split("\\.").length > 1) {
                        expectUsePrecision = expectUseStr.split("\\.")[1].length();
                    }
                    if (expectUsePrecision > unitPrecision) {
                        errorSet.add(String.format(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u9884\u8ba1\u5bff\u547d\u7684\u7cbe\u5ea6\uff1a%1$s \u4e0d\u80fd\u5927\u4e8e\u5355\u4f4d\u7cbe\u5ea6\uff1a%2$s\u3002", (String)"AssetPolicySavePlugin_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), expectUsePrecision, unitPrecision));
                    }
                }
                if (errorSet.size() <= 0) continue;
                String errorMsg = String.join((CharSequence)"\uff0c", errorSet);
                DynamicObject assetCat = (DynamicObject)assetPolicyDynObj.get("assetcat");
                errorMsgSet.put(assetCat.getString("number"), errorMsg);
            }
        }
        return errorMsgSet;
    }

    public List<String> validateNodepre(DynamicObject cc) {
        ArrayList<String> result = new ArrayList<String>();
        DynamicObjectCollection doc = cc.getDynamicObjectCollection("assetpolicy_entry");
        for (DynamicObject dobj : doc) {
            Object nodepre = dobj.get("nodepre");
            Object depreeffect = dobj.get("depreeffect");
            Object depretime = dobj.get("depretime");
            Object depremethod = dobj.get("depremethod");
            Object assetcat = dobj.get("assetcat.name");
            if (nodepre == null || ((Boolean)nodepre).booleanValue() || depreeffect != null && depretime != null && depremethod != null) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u6298\u65e7\u653f\u7b56\u7684\u8d44\u4ea7\u7c7b\u522b\u4e3a\uff08 %s\uff09\u7684\u4e0d\u63d0\u6298\u65e7\u4e3a\u5426\u65f6\uff0c\u6298\u65e7\u65b9\u6cd5\u3001\u8ba1\u63d0\u65f6\u70b9\u3001\u53d8\u52a8\u5f71\u54cd\u5747\u4e0d\u80fd\u4e3a\u7a7a", (String)"AssetPolicySavePlugin_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetcat);
            result.add(msg);
        }
        return result;
    }
}

