/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.dao.impl.FaFinCardDaoOrmImpl;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.enums.SplitMode;
import kd.fi.fa.business.operate.IFaOpHandler;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;

public class DepreAdjustBillAuditPlugin
extends AbstractBusyRecordServicePlugin
implements IFaOpHandler {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("depreuse");
        fieldKeys.add("period.id");
        fieldKeys.add("period.endDate");
        fieldKeys.add("entryentity.realcard");
        fieldKeys.add("entryentity.bfrdepreamount");
        fieldKeys.add("entryentity.aftdepreamount");
        fieldKeys.add(Fa.dot((String[])new String[]{"entryentity", "isadjustdepre"}));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject fincard;
                    DynamicObject realcard;
                    Set billNumbers;
                    DynamicObject bill = dataEntity.getDataEntity();
                    Object org = bill.get("org.id");
                    Object depreuse = bill.get("depreuse.id");
                    DynamicObject period = bill.getDynamicObject("period");
                    boolean enableSumMutilVoucher = false;
                    Long orgId = bill.getLong("org.id");
                    if (orgId2SumMutilVou.get(orgId) != null) {
                        enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
                    } else {
                        enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                        orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
                    }
                    QFilter q1 = new QFilter("org.id", "=", org);
                    QFilter q2 = new QFilter("period.id", ">", period.getPkValue());
                    QFilter q3 = new QFilter("depreuse.id", "=", depreuse);
                    if (!enableSumMutilVoucher) {
                        q2 = new QFilter("period.id", ">=", period.getPkValue());
                    }
                    DynamicObjectCollection depreSumList = QueryServiceHelper.query((String)"fa_depre_sum", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
                    ArrayList<Object> depreSumIdSet = new ArrayList<Object>();
                    for (DynamicObject depreSum : depreSumList) {
                        depreSumIdSet.add(depreSum.get("id"));
                    }
                    if (depreSumIdSet.size() > 0 && FaDepreUtil.hashVouncherV2(depreSumIdSet, (String)"fa_depre_sum")) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DepreAdjustBillAuditPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                    Set realCardIdSet = entries.stream().map(v -> v.get("realcard_id")).collect(Collectors.toSet());
                    Optional checkOp = new FutureBizChecker(bill.getPkValue(), org, realCardIdSet, period.getDate("endDate"), BusyTypeDetailEnum.FIN_CHG, Long.valueOf(bill.getLong("depreuse.id"))).check();
                    if (checkOp.isPresent()) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff1a%s", (String)"DepreAdjustBillAuditPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkOp.get()));
                        continue;
                    }
                    QFilter[] filters = new QFilter[]{new QFilter("org", "=", org), new QFilter("depreuse", "=", depreuse)};
                    DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"curperiod", (QFilter[])filters);
                    if (bill.getLong("period.id") != book.getLong("curperiod")) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5ba1\u6838/\u53cd\u5ba1\u6838\u975e\u5f53\u671f\u7684\u6298\u65e7\u8c03\u6574\u5355\u3002", (String)"DepreAdjustBillAuditPlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    Set realIdSet = entries.stream().map(v -> v.get(Fa.id((String)"realcard"))).collect(Collectors.toSet());
                    filters = new QFilter[]{new QFilter("realcardmasterid", "in", realIdSet), new QFilter("depreuse.id", "=", bill.get(Fa.id((String)"depreuse"))), new QFilter("bizperiod.id", "=", bill.get(Fa.id((String)"period"))), new QFilter("originaldata", "=", (Object)false)};
                    String field = Fa.join((String)",", (String[])new String[]{"realcard", "realcardmasterid", "originalval", "preresidualval", "decval", "accumdepre", "monthdepre"});
                    DynamicObjectCollection fincards = QueryServiceHelper.query((String)"fa_card_fin", (String)field, (QFilter[])filters);
                    Map<Object, DynamicObject> fincardCache = fincards.stream().collect(Collectors.toMap(v -> v.get("realcardmasterid"), v -> v));
                    Long orgId2 = bill.getDynamicObject("org").getLong("id");
                    DynamicObject assetBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg((Object)orgId2);
                    DynamicObject curPeriodDy = assetBook.getDynamicObject("curperiod");
                    Date endDate = curPeriodDy.getDate("enddate");
                    DynamicObjectCollection entry2 = bill.getDynamicObjectCollection("entryentity");
                    HashMap<Long, String> realId2numberMap = new HashMap<Long, String>(entry2.size(), 1.0f);
                    for (DynamicObject entryDy : entry2) {
                        realId2numberMap.put(entryDy.getLong(Fa.id((String)"realcard")), entryDy.getString("realcard.number"));
                    }
                    Set billNos = FaChangeBillUtil.getGenVoucherChangeBillNo((Long)orgId2, (Date)endDate, realId2numberMap.keySet());
                    if (billNos != null && billNos.size() > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u53d8\u66f4\u5355%s\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"DepreAdjustBillAuditPlugin_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNos.toString()));
                    }
                    if ((billNumbers = FaChangeBillUtil.checkhaveFutureRealChangeBill((Long)orgId2, (Date)endDate, realId2numberMap)) != null && billNumbers.size() > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801%s\u5b58\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\uff0c\u5f00\u542f\"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\"\u76f8\u5e94\u53c2\u6570\u6216\u5220\u9664\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u3002", (String)"DepreAdjustBillAuditPlugin_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNumbers.toString()));
                    }
                    if (DepreAdjustBillAuditPlugin.this.isAudit()) {
                        for (DynamicObject entry : entries) {
                            BigDecimal monthDepre;
                            realcard = entry.getDynamicObject("realcard");
                            fincard = fincardCache.get(realcard.get("id"));
                            BigDecimal originVal = fincard.getBigDecimal("originalval");
                            BigDecimal preResidualVal = fincard.getBigDecimal("preresidualval");
                            BigDecimal decVal = fincard.getBigDecimal("decval");
                            BigDecimal accumDepre = fincard.getBigDecimal("accumdepre");
                            BigDecimal beforeMonthDepre = entry.getBigDecimal("bfrdepreamount");
                            BigDecimal afterMonthDepre = entry.getBigDecimal("aftdepreamount");
                            if (originVal.subtract(preResidualVal).subtract(decVal).subtract(accumDepre).subtract(afterMonthDepre).add(beforeMonthDepre).compareTo(BigDecimal.ZERO) < 0) {
                                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%s]\u7684\u6298\u65e7\u989d\u8c03\u6574\u540e\uff0c\u51c0\u503c\u53d8\u6210\u4e86\u8d1f\u6570", (String)"DepreAdjustBillAuditPlugin_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), realcard.getString("number")));
                            }
                            if (accumDepre.subtract(beforeMonthDepre).add(afterMonthDepre).compareTo(BigDecimal.ZERO) < 0) {
                                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%s]\u7684\u6298\u65e7\u989d\u8c03\u6574\u540e\uff0c\u7d2f\u8ba1\u6298\u65e7\u53d8\u6210\u4e86\u8d1f\u6570", (String)"DepreAdjustBillAuditPlugin_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), realcard.getString("number")));
                            }
                            if ((monthDepre = fincard.getBigDecimal("monthdepre")).compareTo(beforeMonthDepre) == 0) continue;
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u5f53\u671f\u6298\u65e7\u989d[%2$s]\u4e0e\u8c03\u6574\u524d\u6298\u65e7\u989d[%3$s]\u4e0d\u76f8\u7b49\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreAdjustBillAuditPlugin_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), realcard.getString("number"), monthDepre, beforeMonthDepre));
                        }
                        continue;
                    }
                    for (DynamicObject entry : entries) {
                        realcard = entry.getDynamicObject("realcard");
                        fincard = fincardCache.get(realcard.get("id"));
                        BigDecimal afterMonthDepre = entry.getBigDecimal("aftdepreamount");
                        BigDecimal monthDepre = fincard.getBigDecimal("monthdepre");
                        if (monthDepre.compareTo(afterMonthDepre) == 0) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u5f53\u671f\u6298\u65e7\u989d[%2$s]\u4e0e\u8c03\u6574\u540e\u6298\u65e7\u989d[%3$s]\u4e0d\u76f8\u7b49\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreAdjustBillAuditPlugin_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), realcard.getString("number"), monthDepre, afterMonthDepre));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        FunctionMutexHelperV2Utils.doFaOpWithWithBookPcChildLock((String)operationKey, (String)"fa_depreadjustbill", (DynamicObject[])e.getDataEntities(), null, (IFaOpHandler)this);
    }

    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        for (DynamicObject depreAdjustBill : dataEntities) {
            this.update(depreAdjustBill, this.isAudit());
            FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)depreAdjustBill, (String)"entryentity", (String)"realcard", (BizStatusEnum)(this.isAudit() ? BizStatusEnum.READY : BizStatusEnum.DEPREADJUST), (BizStatusEnum)(this.isAudit() ? BizStatusEnum.DEPREADJUST : BizStatusEnum.READY));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject depreAdjustBill : e.getDataEntities()) {
            this.updateDepreSplit(depreAdjustBill, this.isAudit());
        }
    }

    protected boolean isAudit() {
        return true;
    }

    protected void handleDynamicCard(DynamicObject depreAdjustBill) {
        DynamicObjectCollection entries = depreAdjustBill.getDynamicObjectCollection("entryentity");
        Set adjustRealCardPkSet = entries.stream().filter(v -> v.getBoolean("isadjustdepre")).map(v -> v.getDynamicObject("realcard").getPkValue()).collect(Collectors.toSet());
        if (adjustRealCardPkSet.isEmpty()) {
            return;
        }
        DynamicObject org = depreAdjustBill.getDynamicObject("org");
        DynamicObject depreuse = depreAdjustBill.getDynamicObject("depreuse");
        long depreUseId = depreuse.getLong("id");
        DynamicObjectCollection dynamicCards = QueryServiceHelper.query((String)"fa_card_dynamic", (String)Fa.join((String)",", (String[])new String[]{"realcard"}), (QFilter[])new QFilter[]{new QFilter("realcard", "in", adjustRealCardPkSet), new QFilter("depreuse", "=", (Object)depreUseId)});
        for (DynamicObject dynCard : dynamicCards) {
            long cardId = dynCard.getLong("realcard");
            adjustRealCardPkSet.remove(cardId);
        }
        if (adjustRealCardPkSet.isEmpty()) {
            return;
        }
        DynamicObject orgAssetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", (Object)depreUseId)});
        DynamicObject curPeriod = depreAdjustBill.getDynamicObject("period");
        DynamicObject nextPeriod = PeriodUtil.getNextPeriod((long)curPeriod.getLong("id"), (boolean)false);
        Date applyDate = nextPeriod.getDate("begindate");
        ArrayList<DynamicObject> newDynCards = new ArrayList<DynamicObject>(adjustRealCardPkSet.size());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        for (Object cardId : adjustRealCardPkSet) {
            DynamicObject dynCard = new DynamicObject((DynamicObjectType)type);
            dynCard.set("realcard", cardId);
            dynCard.set("assetbook", orgAssetBook.get("id"));
            dynCard.set("depreuse", (Object)depreUseId);
            dynCard.set("date", (Object)applyDate);
            dynCard.set("entityname", (Object)"fa_depreadjustbill");
            dynCard.set("changebillid", depreAdjustBill.get("id"));
            dynCard.set("sourcename", (Object)depreAdjustBill.getString("billno"));
            newDynCards.add(dynCard);
        }
        SaveServiceHelper.save((DynamicObject[])newDynCards.toArray(new DynamicObject[0]));
    }

    private void update(DynamicObject depreAdjustBill, boolean isAudit) {
        DynamicObject[] finCards;
        DynamicObject org = depreAdjustBill.getDynamicObject("org");
        DynamicObject depreuse = depreAdjustBill.getDynamicObject("depreuse");
        long depreUseId = depreuse.getLong("id");
        DynamicObject period = depreAdjustBill.getDynamicObject("period");
        DynamicObjectCollection entries = depreAdjustBill.getDynamicObjectCollection("entryentity");
        Object[] realCardIds = entries.stream().map(v -> v.get("realcard_id")).toArray();
        new FaFinCardDaoOrmImpl().copyFinCards(period.getLong("id"), depreUseId, realCardIds, null, null, null);
        Function<DynamicObject, BigDecimal[]> depreAmtFn = v -> {
            BigDecimal[] bigDecimalArray;
            if (isAudit) {
                BigDecimal[] bigDecimalArray2 = new BigDecimal[2];
                bigDecimalArray2[0] = v.getBigDecimal("bfrdepreamount");
                bigDecimalArray = bigDecimalArray2;
                bigDecimalArray2[1] = v.getBigDecimal("aftdepreamount");
            } else {
                BigDecimal[] bigDecimalArray3 = new BigDecimal[2];
                bigDecimalArray3[0] = v.getBigDecimal("aftdepreamount");
                bigDecimalArray = bigDecimalArray3;
                bigDecimalArray3[1] = v.getBigDecimal("bfrdepreamount");
            }
            return bigDecimalArray;
        };
        Map<Object, BigDecimal[]> rCardPk_depreAmt = entries.stream().collect(Collectors.toMap(v -> v.getDynamicObject("realcard").getPkValue(), depreAmtFn));
        Set realCardPkSet = entries.stream().map(v -> v.getDynamicObject("realcard").getPkValue()).collect(Collectors.toSet());
        String selector = Fa.join((String)",", (String[])new String[]{"realcard.id", "realcardmasterid", "monthdepre", "accumdepre", "addupyeardepre", "originalval", "networth", "decval", "netamount", "depredept.id", "assetcat.id", "monthdeprerate", "isneeddepre"});
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", depreuse.getPkValue()), new QFilter("bizperiod", "=", period.getPkValue()), new QFilter("realcardmasterid", "in", realCardPkSet), new QFilter("originaldata", "=", (Object)false)};
        for (DynamicObject fincard : finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters)) {
            Object realCardPk = fincard.get("realcardmasterid");
            BigDecimal[] depreAmt = rCardPk_depreAmt.get(realCardPk);
            fincard.set("monthdepre", (Object)depreAmt[1]);
            BigDecimal oldAccumDepre = fincard.getBigDecimal("accumdepre");
            BigDecimal newAccumDepre = oldAccumDepre.add(depreAmt[1]).subtract(depreAmt[0]);
            fincard.set("accumdepre", (Object)newAccumDepre);
            BigDecimal originalVal = fincard.getBigDecimal("originalval");
            BigDecimal newNetWorth = originalVal.subtract(newAccumDepre);
            fincard.set("networth", (Object)newNetWorth);
            BigDecimal decVal = fincard.getBigDecimal("decval");
            BigDecimal newNetAmount = newNetWorth.subtract(decVal);
            fincard.set("netamount", (Object)newNetAmount);
            BigDecimal oldYearDepre = fincard.getBigDecimal("addupyeardepre");
            fincard.set("addupyeardepre", (Object)oldYearDepre.add(depreAmt[1]).subtract(depreAmt[0]));
            BigDecimal monthDepreRate = depreAmt[1].divide(originalVal, 4, RoundingMode.HALF_UP);
            fincard.set("monthdeprerate", (Object)monthDepreRate);
            fincard.set("isneeddepre", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])finCards);
        this.handleDynamicCard(depreAdjustBill);
    }

    private void updateDepreSplit(DynamicObject depreAdjustBill, boolean isAudit) {
        DynamicObject org = depreAdjustBill.getDynamicObject("org");
        DynamicObject depreuse = depreAdjustBill.getDynamicObject("depreuse");
        DynamicObject period = depreAdjustBill.getDynamicObject("period");
        DynamicObjectCollection entries = depreAdjustBill.getDynamicObjectCollection("entryentity");
        Set realCardPkSet = entries.stream().map(v -> v.getDynamicObject("realcard").getLong("id")).collect(Collectors.toSet());
        new DepreSplitSum().updateDepreSplit(Long.valueOf(org.getLong("id")), Long.valueOf(depreuse.getLong("id")), Long.valueOf(period.getLong("id")), true, realCardPkSet, SplitMode.DETAILADDREVERSE);
    }
}

