/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaDepreAdjustUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class DepreAdjustBillSaveValidator
extends AbstractValidator {
    public void validate() {
        this.checkBillNo(this.dataEntities);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Set billNumbers;
            String msg;
            DynamicObject depreUse;
            DynamicObject bill = dataEntity.getDataEntity();
            List<String> errorInfo = this.checkDuplicateCard(bill);
            if (!errorInfo.isEmpty()) {
                errorInfo.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
            }
            if ((depreUse = bill.getDynamicObject("depreuse")) == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e3a\u7a7a", (String)"DepreAdjustBillSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            errorInfo = this.checkCardInfo(bill);
            if (!errorInfo.isEmpty()) {
                errorInfo.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
            }
            if ((msg = this.checkCardCurPeriodhasDepAdjust(bill)) != null) {
                this.addErrorMessage(dataEntity, msg);
            }
            Long orgId2 = bill.getDynamicObject("org").getLong("id");
            DynamicObject assetBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg((Object)orgId2);
            DynamicObject curPeriodDy = assetBook.getDynamicObject("curperiod");
            Date endDate = curPeriodDy.getDate("enddate");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entryentity");
            HashMap<Long, String> realId2numberMap = new HashMap<Long, String>(entry.size(), 1.0f);
            for (DynamicObject entryDy : entry) {
                realId2numberMap.put(entryDy.getLong(Fa.id((String)"realcard")), entryDy.getString("realcard.number"));
            }
            Set billNos = FaChangeBillUtil.getGenVoucherChangeBillNo((Long)orgId2, (Date)endDate, realId2numberMap.keySet());
            if (billNos != null && billNos.size() > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u53d8\u66f4\u5355%s\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"DepreAdjustBillSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNos.toString()));
            }
            if ((billNumbers = FaChangeBillUtil.checkhaveFutureRealChangeBill((Long)orgId2, (Date)endDate, realId2numberMap)) == null || billNumbers.size() <= 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801%s\u5b58\u5728\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\uff0c\u5f00\u542f\"\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\"\u76f8\u5e94\u53c2\u6570\u6216\u5220\u9664\u672a\u6765\u5b9e\u7269\u4e1a\u52a1\u3002", (String)"DepreAdjustBillSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNumbers.toString()));
        }
    }

    private void checkBillNo(ExtendedDataEntity[] dataEntities) {
        ArrayList<String> billNoList = new ArrayList<String>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            billNoList.add(bill.getString("billno"));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNoList)});
        Set existsBillNo = query.stream().map(v -> v.getString("billno")).collect(Collectors.toSet());
        if (!existsBillNo.isEmpty()) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                boolean fromDatabase = bill.getDataEntityState().getFromDatabase();
                String billNo = bill.getString("billno");
                if (fromDatabase || !existsBillNo.contains(billNo)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6298\u65e7\u8c03\u6574\u5355\u53f7\uff1a%s \u5b58\u5728\u91cd\u590d\u503c\u3002", (String)"DepreAdjustBillSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNo));
            }
        }
    }

    private String checkCardCurPeriodhasDepAdjust(DynamicObject bill) {
        DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
        HashSet<Long> cardIdSet = new HashSet<Long>(entity.size());
        for (DynamicObject row : entity) {
            DynamicObject realCard = row.getDynamicObject("realcard");
            if (realCard == null) continue;
            long realCardId = realCard.getLong("id");
            cardIdSet.add(realCardId);
        }
        if (!cardIdSet.isEmpty()) {
            Object orgPk = bill.getDynamicObject("org").getPkValue();
            Object depreUsePk = bill.getDynamicObject("depreuse").getPkValue();
            Object periodPK = bill.getDynamicObject("period").getPkValue();
            return FaDepreAdjustUtils.getAlreadyDepAdjustCardMsg((Object)orgPk, (Object)depreUsePk, (Object)periodPK, cardIdSet, (Object)bill.getPkValue());
        }
        return null;
    }

    private List<String> checkDuplicateCard(DynamicObject bill) {
        DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
        HashSet<Long> cardIdSet = new HashSet<Long>(entity.size());
        ArrayList<String> errorInfo = new ArrayList<String>(entity.size());
        for (DynamicObject row : entity) {
            long realCardId;
            boolean exist;
            DynamicObject realCard = row.getDynamicObject("realcard");
            if (realCard == null || (exist = cardIdSet.add(realCardId = realCard.getLong("id")))) continue;
            String number = realCard.getString("number");
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%s \u5b58\u5728\u91cd\u590d\u503c\u3002", (String)"DepreAdjustBillSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
        }
        return errorInfo;
    }

    private List<String> checkCardInfo(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        long orgId = org.getLong("id");
        DynamicObject depreUse = bill.getDynamicObject("depreuse");
        long depreUseId = depreUse.getLong("id");
        DynamicObject period = bill.getDynamicObject("period");
        long periodId = period.getLong("id");
        DynamicObjectCollection entity = bill.getDynamicObjectCollection("entryentity");
        Set realCardIds = entity.stream().map(v -> v.getLong(Fa.id((String)"realcard"))).collect(Collectors.toSet());
        ArrayList<String> errorInfo = new ArrayList<String>(entity.size());
        Date endDate = period.getDate("enddate");
        endDate = DateUtil.getDateFormat((Date)endDate, (boolean)true);
        Set masterIds = entity.stream().map(v -> v.get("realcard.masterid")).collect(Collectors.toSet());
        Optional check = new FutureBizChecker(null, (Object)orgId, masterIds, endDate, BusyTypeDetailEnum.FIN_CHG, Long.valueOf(depreUseId)).check();
        check.ifPresent(s -> errorInfo.add(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u8bf7\u5220\u9664\u4ee5\u4e0b\u540e\u7eed\u4e1a\u52a1\u518d\u505a\u6298\u65e7\u8c03\u6574\u3002%s", (String)"DepreAdjustBillSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), s)));
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("bizperiod", "=", (Object)periodId), new QFilter("realcardmasterid", "in", realCardIds), new QFilter("originaldata", "=", (Object)false)};
        String selectFields = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"realcard", "id"}), Fa.dot((String[])new String[]{"realcard", "bizstatus"}), "isneeddepre", Fa.dot((String[])new String[]{"depremethod", "type"}), "monthdepre", "realcardmasterid"});
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])filters);
        Map<Long, DynamicObject> cardMap = finCards.stream().collect(Collectors.toMap(v -> v.getLong("realcardmasterid"), v -> v));
        for (DynamicObject row : entity) {
            BigDecimal befDepreAmount;
            BigDecimal monthDepre;
            String depreMethodType;
            boolean isNeedDepre;
            int seq = row.getInt("seq");
            long realCardId = row.getLong(Fa.id((String)"realcard"));
            DynamicObject finCard = cardMap.get(realCardId);
            if (finCard == null) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6839\u636e\u8d26\u7c3f\u3001\u671f\u95f4\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"DepreAdjustBillSaveValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq));
                continue;
            }
            String bizStatus = finCard.getString(Fa.dot((String[])new String[]{"realcard", "bizstatus"}));
            if (!"READY".equals(bizStatus) && !"DEPREADJUST".equals(bizStatus)) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5361\u7247\u5b58\u5728\u672a\u5b8c\u6210\u4e1a\u52a1\uff0c\u8bf7\u5b8c\u6210\u5bf9\u5e94\u4e1a\u52a1\u540e\u518d\u505a\u6298\u65e7\u8c03\u6574\u3002", (String)"DepreAdjustBillSaveValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq));
            }
            if (isNeedDepre = finCard.getBoolean("isneeddepre")) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5361\u7247\u9700\u8981\u91cd\u63d0\u6298\u65e7\uff0c\u8bf7\u5148\u8ba1\u63d0\u6298\u65e7\u518d\u505a\u6298\u65e7\u8c03\u6574\u3002", (String)"DepreAdjustBillSaveValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq));
            }
            if ("5".equals(depreMethodType = finCard.getString(Fa.dot((String[])new String[]{"depremethod", "type"})))) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5de5\u4f5c\u91cf\u6cd5\u6298\u65e7\u7684\u5361\u7247\u4e0d\u5141\u8bb8\u505a\u6298\u65e7\u8c03\u6574\uff0c\u8bf7\u76f4\u63a5\u8c03\u6574\u5f53\u671f\u5de5\u4f5c\u91cf\u3002", (String)"DepreAdjustBillSaveValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq));
            }
            if ((monthDepre = finCard.getBigDecimal("monthdepre")).compareTo(befDepreAmount = row.getBigDecimal("bfrdepreamount")) == 0) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u5361\u7247\u5f53\u671f\u6298\u65e7\u989d\u4e0e\u8c03\u6574\u524d\u6298\u65e7\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5361\u7247\u3002", (String)"DepreAdjustBillSaveValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq));
        }
        return errorInfo;
    }
}

