/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.common.util.Fa;

public class DepreSplitSetUpSaveValidator
extends AbstractValidator {
    public void validate() {
        Set orgIds = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).filter(Objects::nonNull).map(v -> v.getLong(Fa.id((String)"createorg"))).collect(Collectors.toSet());
        QFilter qFilter = new QFilter(Fa.id((String)"org"), "in", orgIds).and("status", "=", (Object)"C");
        Set enableBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "depreuse"}), (QFilter[])qFilter.toArray()).stream().map(v -> v.getLong("org") + "_" + v.getLong("depreuse")).collect(Collectors.toSet());
        HashSet<Long> updateIds = new HashSet<Long>(10);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject setup = dataEntity.getDataEntity();
            if (setup.getDataEntityState().getFromDatabase()) {
                updateIds.add(setup.getLong("id"));
            }
            long orgId = setup.getLong(Fa.id((String)"createorg"));
            long depreUseId = setup.getLong(Fa.id((String)"depreuse"));
            if (enableBooks.contains(orgId + "_" + depreUseId)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u521d\u59cb\u5316\u672a\u7ed3\u675f\uff0c\u4e0d\u5141\u8bb8\u5bf9\u8d44\u4ea7\u4e1a\u52a1\u8fdb\u884c\u5904\u7406\u3002", (String)"DepreSplitSetUpSaveValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        if (updateIds.size() > 0) {
            DynamicObjectCollection dbDatas = QueryServiceHelper.query((String)"fa_depresplitsetup", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "in", updateIds)});
            Map<Long, DynamicObject> dbDataMap = dbDatas.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String status;
                Long id;
                DynamicObject oldData;
                DynamicObject setup = dataEntity.getDataEntity();
                if (!setup.getDataEntityState().getFromDatabase() || (oldData = dbDataMap.get(id = Long.valueOf(setup.getLong("id")))) == null || "A".equals(status = oldData.getString("status"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6682\u5b58\u72b6\u6001\u4e0b\u7684\u5355\u636e\u624d\u5141\u8bb8\u4fee\u6539", (String)"DepreSplitSetUpSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
        }
        BigDecimal handred = new BigDecimal("100");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            EntryProp assEntryProp;
            SubEntryProp assSubEntryProp;
            DynamicProperty assidProp;
            DynamicObject setup = dataEntity.getDataEntity();
            DynamicObjectCollection asstypes = setup.getDynamicObjectCollection("asstypes");
            this.checkAssTypes(asstypes);
            if (setup.getLong("id") == 0L || this.dataEntities.length > 1 && "submit".equals(this.getOperateType())) continue;
            if (this.dataEntities.length == 1 && (assidProp = (assSubEntryProp = (SubEntryProp)(assEntryProp = (EntryProp)setup.getDynamicObjectType().getProperty("assentry")).getDynamicCollectionItemPropertyType().getProperty("asssubentry")).getDynamicCollectionItemPropertyType().getProperty("assid")) == null) {
                setup = BusinessDataServiceHelper.loadSingle((Object)setup.getPkValue(), (String)this.getEntityKey());
            }
            DynamicObjectCollection assEntries = setup.getDynamicObjectCollection("assentry");
            BigDecimal total = BigDecimal.ZERO;
            HashSet<String> assTotalKeySet = new HashSet<String>();
            DynamicObject org = setup.getDynamicObject("createorg");
            DynamicObject realCard = setup.getDynamicObject("realcard");
            DynamicObject assetUnit = realCard.getDynamicObject("assetunit");
            for (DynamicObject assentry : assEntries) {
                if (assentry.getBigDecimal("percent").compareTo(BigDecimal.ZERO) <= 0) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0", (String)"DepreSplitSetUpSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    break;
                }
                total = total.add(assentry.getBigDecimal("percent"));
                DynamicObjectCollection assSubEntries = assentry.getDynamicObjectCollection("asssubentry");
                String totalKey = "orgduty|" + assentry.get("orgduty.id") + ";" + assentry.getString("assinfo");
                if (assSubEntries.size() < asstypes.size()) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u644a\u7ef4\u5ea6\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DepreSplitSetUpSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    break;
                }
                for (DynamicObject subEntry : assSubEntries) {
                    Long useDept;
                    boolean checkResult;
                    if (!"bos_org_duty".equalsIgnoreCase(subEntry.getString("asstype")) && subEntry.getLong("assid") == 0L) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u644a\u7ef4\u5ea6\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DepreSplitSetUpSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        break;
                    }
                    if (!"bos_adminorg".equalsIgnoreCase(subEntry.getString("asstype")) || (checkResult = FaAssetUnitAndUseDeptUnits.checkUseDeptByAssetUnit((DynamicObject)org, (DynamicObject)assetUnit, (Long)(useDept = Long.valueOf(subEntry.getLong("assid")))))) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff1a%s\u4f7f\u7528\u90e8\u95e8\u4e0d\u5728\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u7684\u53ef\u7528\u8303\u56f4\u4e4b\u5185", (String)"DepreSplitSetUpSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), realCard.get("number")));
                }
                if (assentry.getDynamicObject("orgduty") == null) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u90e8\u95e8\u5c5e\u6027\u5fc5\u5f55", (String)"DepreSplitSetUpSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if (assTotalKeySet.contains(totalKey)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u4e2a\u5206\u644a\u6bd4\u4f8b\u7684\u201c\u5206\u644a\u7ef4\u5ea6\u7ec4\u5408\u201d\u91cd\u590d\u3002", (String)"DepreSplitSetUpSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                assTotalKeySet.add(totalKey);
            }
            if (total.compareTo(handred) == 0) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u7b49\u4e8e100%\u3002", (String)"DepreSplitSetUpSaveValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void checkAssTypes(DynamicObjectCollection asstypes) {
        ArrayList<String> errList = new ArrayList<String>(5);
        HashMap<String, String> existsEntities = new HashMap<String, String>(5);
        for (DynamicObject o : asstypes) {
            DynamicObject entityObject = (DynamicObject)o.get("fbasedataid");
            String fbdtype = entityObject.getString("valuetype");
            String astName = entityObject.getString("name");
            String sourceNumber = "";
            if ("1".equals(fbdtype)) {
                sourceNumber = entityObject.getString("valuesource.number");
            } else if ("2".equals(fbdtype)) {
                sourceNumber = entityObject.getString("assistanttype.id");
            }
            String mapKey = fbdtype + sourceNumber;
            if (existsEntities.containsKey(mapKey)) {
                errList.add(astName);
                String dumpName = (String)existsEntities.get(mapKey);
                errList.add(dumpName);
                continue;
            }
            existsEntities.put(mapKey, astName);
        }
        if (errList.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u503c\u6765\u6e90\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\uff0c[%s]", (String)"DepreSplitSetUpSaveValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", errList)));
        }
    }
}

