/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.DepreTimeEnum;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.utils.FaAssetCardUtils;

public class DepredAmountValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(DepredAmountValidator.class);

    /*
     * WARNING - void declaration
     */
    public void validate() {
        List<Object> finCards = new ArrayList<DynamicObject>(16);
        String entityKey = this.getEntityKey();
        HashMap<Long, ExtendedDataEntity> map = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        if ("fa_asset_card".equals(entityKey)) {
            void var7_11;
            ArrayList<DynamicObject> assetCardFinList = new ArrayList<DynamicObject>(this.dataEntities.length);
            ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
            int n = extendedDataEntityArray.length;
            boolean bl = false;
            while (var7_11 < n) {
                ExtendedDataEntity dataEntity = extendedDataEntityArray[var7_11];
                DynamicObject assetCard = dataEntity.getDataEntity();
                DynamicObjectCollection assetCardFins = assetCard.getDynamicObjectCollection("finentry");
                for (DynamicObject entry : assetCardFins) {
                    DynamicObject finCard = entry.getDynamicObject("fincard");
                    if (Objects.isNull(finCard)) continue;
                    assetCardFinList.add(finCard);
                    map.put(finCard.getLong("id"), dataEntity);
                }
                ++var7_11;
            }
            boolean containsFinInfo = this.getOption().containsVariable("assetCardFinInfo");
            if (!containsFinInfo) {
                List<Long> finCardIds = assetCardFinList.stream().map(card -> card.getLong("id")).collect(Collectors.toList());
                finCards = this.queryFinCardDynObjList(finCardIds);
            } else {
                finCards = Arrays.asList(FaAssetCardUtils.getFinCardsForOperate(this.getOption(), null, assetCardFinList));
                for (DynamicObject dynamicObject : finCards) {
                    long finCardId = dynamicObject.getLong("id");
                    if (map.containsKey(finCardId)) continue;
                    ExtendedDataEntity curDataEntity = this.dataEntities[0];
                    map.put(finCardId, curDataEntity);
                }
            }
        }
        if ("fa_card_fin".equals(entityKey)) {
            finCards = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject finCard = extendedDataEntity.getDataEntity();
                if (finCard == null) continue;
                map.put(finCard.getLong("id"), extendedDataEntity);
            }
        }
        this.getErrInfo(finCards, map);
    }

    private List<DynamicObject> queryFinCardDynObjList(List<Long> finCardIdList) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", finCardIdList)};
        String selectFields = String.join((CharSequence)",", "assetbook.depresystem", "assetbook.periodtype", "assetcat", "realcard.realaccountdate", "realcard.sourceflag", "depredamount", "depremethod", "finaccountdate");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectFields, (QFilter[])filters);
        return Arrays.asList(dynamicObjects);
    }

    private void getErrInfo(List<DynamicObject> validatorParamList, Map<Long, ExtendedDataEntity> map) {
        HashSet<Long> assetCatIdSet = new HashSet<Long>(validatorParamList.size());
        HashSet<Long> depreSystemIdSet = new HashSet<Long>(validatorParamList.size());
        for (DynamicObject findCard : validatorParamList) {
            assetCatIdSet.add((Long)findCard.getDynamicObject("assetcat").getPkValue());
            depreSystemIdSet.add((Long)findCard.getDynamicObject("assetbook").getDynamicObject("depresystem").getPkValue());
        }
        Map depreSystemAndCatBatch = AssetPolicyUtil.getByDepreSystemAndCatBatch(depreSystemIdSet, assetCatIdSet);
        List<String> sourceFlagList = this.getSourceFlagList();
        for (DynamicObject findCard : validatorParamList) {
            long finCardId = findCard.getLong("id");
            int depredamount = findCard.getBigDecimal("depredamount").intValue();
            DynamicObject depremethod = findCard.getDynamicObject("depremethod");
            String sourceFlag = findCard.getString("realcard.sourceflag");
            if (!sourceFlagList.contains(sourceFlag) || depredamount == 0) continue;
            Long depreSystemId = (Long)findCard.getDynamicObject("assetbook").getDynamicObject("depresystem").getPkValue();
            Map assetCat2DepreSystemEntry = (Map)depreSystemAndCatBatch.get(depreSystemId);
            if (assetCat2DepreSystemEntry.isEmpty()) {
                log.info("\u6839\u636e\u8d44\u4ea7\u653f\u7b56ID\uff1a{} \u83b7\u53d6\u4e0d\u5230 Map<\u8d44\u4ea7\u7c7b\u522bid, \u8d44\u4ea7\u653f\u7b56\u5206\u5f55>>", (Object)depreSystemId);
                continue;
            }
            Long assetCatId = (Long)findCard.getDynamicObject("assetcat").getPkValue();
            DynamicObject depreSystemEntryDynObj = (DynamicObject)assetCat2DepreSystemEntry.get(assetCatId);
            if (Objects.isNull(depreSystemEntryDynObj)) {
                log.info("\u6839\u636e\u8d44\u4ea7\u7c7b\u522bID\uff1a{} \u83b7\u53d6\u4e0d\u5230\u8d44\u4ea7\u653f\u7b56\u5206\u5f55", (Object)assetCatId);
                continue;
            }
            String depretime = depreSystemEntryDynObj.getString("depretime");
            String errMsg = ResManager.loadKDString((String)"\u5f55\u5165\u7684\u5df2\u6298\u65e7\u671f\u95f4\u6570\u5927\u4e8e\u6839\u636e\u8d44\u4ea7\u653f\u7b56\u5e94\u8be5\u8ba1\u63d0\u7684\u6700\u5927\u671f\u95f4\u6570\u3002", (String)"DepredAmountValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
            Date realaccountdate = findCard.getDate("realcard.realaccountdate");
            Date finaccountDate = findCard.getDate("finaccountdate");
            Object periodTypeId = findCard.getDynamicObject("assetbook").getDynamicObject("periodtype").getPkValue();
            int diffBetweenPeriods = PeriodUtil.getDiffBetweenPeriods((Date)realaccountdate, (Date)finaccountDate, (Object)periodTypeId);
            if (depremethod == null || "5".equals(depremethod.getString("type"))) continue;
            if (diffBetweenPeriods == 0 && depredamount > 0) {
                this.addErrorMessage(map.get(finCardId), errMsg);
                continue;
            }
            if ((!DepreTimeEnum.NEW.name().equals(depretime) || depredamount <= diffBetweenPeriods) && (!DepreTimeEnum.CLEAR.name().equals(depretime) || depredamount <= diffBetweenPeriods - 1)) continue;
            this.addErrorMessage(map.get(finCardId), errMsg);
        }
    }

    private List<String> getSourceFlagList() {
        ArrayList<String> sourceFlag = new ArrayList<String>(5);
        sourceFlag.add("ADD");
        sourceFlag.add("IMPORT");
        sourceFlag.add("PURCHASE");
        sourceFlag.add("ENGINEERINGTRANS");
        sourceFlag.add("INVENTORYPROFIT");
        return sourceFlag;
    }
}

