/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaAssetBookSaveValidator;

public class FaAssetBookSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FaAssetBookSaveOp.class);
    private static String SQL_INSERT = "INSERT INTO t_fa_billparam (fid, forgid, fcreatedate, fparam, fvalue, fenable, fsyspre, fbizcloudid, fbizappid, fparamtypeid, fcanmodify) VALUES(?, ?, ?, 'split.currentperiod.enable', ?, '1', '1', '83bfebc8000002ac', '83bfebc800001aac', 1819718086002160640, '0');";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("startperiod");
        fieldKeys.add("ismainbook");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FaAssetBookSaveValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            Long orgId = data.getLong(Fa.id((String)"org"));
            orgIds.add(orgId);
        }
        DynamicObjectCollection billParams = QueryServiceHelper.query((String)"fa_billparam", (String)Fa.comma((String[])new String[]{"org"}), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("param", "=", (Object)"split.currentperiod.enable")});
        HashSet existOrgIds = new HashSet(billParams.size());
        billParams.stream().forEach(t -> existOrgIds.add(t.getLong("org")));
        orgIds.removeAll(existOrgIds);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            this.insertBillParams(orgIds);
        }
    }

    private void insertBillParams(Set<Long> orgIds) {
        boolean isNewCustomer = FaBizUtils.isNewCustomer();
        boolean allSuccess = FaAssetBookDataUpgradeLogUtils.allOrgEnableCurPeriodSplit();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(orgIds.size());
        long[] ids = DB.genLongIds((String)"t_fa_billparam", (int)orgIds.size());
        int i = 0;
        for (Long orgId : orgIds) {
            paramsList.add(new Object[]{ids[i], orgId, new Date(), String.valueOf(!isNewCustomer && allSuccess)});
            ++i;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)SQL_INSERT, paramsList);
    }
}

