/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaAssetBookSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject book = dataEntity.getDataEntity();
            List<String> errorInfo = this.checkModifyEnable(book);
            if (errorInfo.isEmpty()) continue;
            errorInfo.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
        }
        this.checkAssetBookData4LeaseInit();
    }

    private void checkAssetBookData4LeaseInit() {
        HashMap<Long, ExtendedDataEntity> org2AssetBook = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject assetBook = dataEntity.getDataEntity();
            if (!assetBook.getBoolean("ismainbook")) continue;
            org2AssetBook.put(assetBook.getLong(Fa.id((String)"org")), dataEntity);
        }
        if (!org2AssetBook.isEmpty()) {
            String field = Fa.comma((String[])new String[]{"org", "depresystem", "basecurrency", "exchangetable", "periodtype", "startperiod"});
            DynamicObjectCollection leaseInits = QueryServiceHelper.query((String)"fa_lease_init", (String)field, (QFilter[])new QFilter[]{new QFilter("org", "in", org2AssetBook.keySet())});
            if (!leaseInits.isEmpty()) {
                for (DynamicObject leaseInit : leaseInits) {
                    long startPeriodId;
                    long periodTypeId;
                    long exchangeTableId;
                    long baseCurrencyId;
                    long orgId = leaseInit.getLong("org");
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)org2AssetBook.get(orgId);
                    long depreSystemId = leaseInit.getLong("depresystem");
                    if (depreSystemId != (Long)dataEntity.getValue(Fa.id((String)"depresystem"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u8d44\u4ea7\u653f\u7b56\u4e0e\u4e3b\u8d26\u7c3f\u653f\u7b56\u4e0d\u4e00\u81f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaAssetBookSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if ((baseCurrencyId = leaseInit.getLong("basecurrency")) != (Long)dataEntity.getValue(Fa.id((String)"basecurrency"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u4e3b\u4e1a\u52a1\u5e01\u522b\u4e0e\u4e3b\u8d26\u7c3f\u653f\u7b56\u4e0d\u4e00\u81f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaAssetBookSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if ((exchangeTableId = leaseInit.getLong("exchangetable")) != (Long)dataEntity.getValue(Fa.id((String)"exchangetable"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u6c47\u7387\u8868\u4e0e\u4e3b\u8d26\u7c3f\u653f\u7b56\u4e0d\u4e00\u81f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaAssetBookSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if ((periodTypeId = leaseInit.getLong("periodtype")) != (Long)dataEntity.getValue(Fa.id((String)"periodtype"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u671f\u95f4\u7c7b\u578b\u4e0e\u4e3b\u8d26\u7c3f\u653f\u7b56\u4e0d\u4e00\u81f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaAssetBookSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if ((startPeriodId = leaseInit.getLong("startperiod")) >= (Long)dataEntity.getValue(Fa.id((String)"startperiod"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u542f\u7528\u671f\u95f4\u65e9\u4e8e\u4e3b\u8d26\u7c3f\u542f\u7528\u671f\u95f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaAssetBookSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private List<String> checkModifyEnable(DynamicObject book) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        boolean fromDatabase = book.getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            return errorInfo;
        }
        DynamicObject bookFromDataBase = BusinessDataServiceHelper.loadSingle((Object)book.getPkValue(), (String)"fa_assetbook");
        DynamicObject org = bookFromDataBase.getDynamicObject("org");
        Iterable properties = book.getDataEntityState().getBizChangedProperties();
        Iterator iterator = properties.iterator();
        String status = bookFromDataBase.getString("status");
        boolean existsLeaseRealCard = FaUtils.existsLeaseRealCard((long)org.getLong("id"));
        long depreuse = book.getLong("depreuse_id");
        boolean existsFinCard = FaUtils.existsFincardByOrgAndDepreuse((long)org.getLong("id"), (long)depreuse);
        while (iterator.hasNext()) {
            IDataEntityProperty property = (IDataEntityProperty)iterator.next();
            if (property.getName().equals("name") || property.getName().equals("accdatevalidate")) {
                iterator.remove();
            }
            if (!property.getName().equals("number") || "C".equals(status) || existsFinCard || existsLeaseRealCard) continue;
            iterator.remove();
        }
        if (properties.iterator().hasNext()) {
            if ("C".equals(status)) {
                errorInfo.add(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u201c%s\u201d\u8d26\u7c3f\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"FaAssetBookSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[]{org.getString("number")}));
            }
            if (existsLeaseRealCard) {
                errorInfo.add(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u5b58\u5728\u79df\u8d41\u5408\u540c\u751f\u6210\u7684\u5b9e\u7269\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8d26\u7c3f\u3002", (String)"FaAssetBookSaveValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (existsFinCard) {
                errorInfo.add(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u5b58\u5728\u8d22\u52a1\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8d26\u7c3f\u3002", (String)"FaAssetBookSaveValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
        }
        return errorInfo;
    }
}

