/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class FaBizBaseValidator
extends AbstractValidator {
    public void validate() {
        FaBizBaseValidator.checkFinCardExist4BizBill(this.dataEntities, this.entityKey);
    }

    private static String checkFinCardExist4BizBill(ExtendedDataEntity[] dataEntities, String entityName) {
        HashSet<String> failedNumbers = new HashSet<String>();
        switch (entityName) {
            case "fa_change_dept": {
                FaBizBaseValidator.check4ChangeBill(dataEntities, failedNumbers);
                break;
            }
            case "fa_assetsplitbill": {
                FaBizBaseValidator.check4SplitBill(dataEntities, failedNumbers);
                break;
            }
            case "fa_mergebill": {
                FaBizBaseValidator.check4MergeBill(dataEntities, failedNumbers);
            }
        }
        if (CollectionUtils.isNotEmpty(failedNumbers)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u4e3a[%s]\u7684\u8d22\u52a1\u5361\u7247\u5df2\u7ecf\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5361\u7247\u3002", (String)"FaBizBaseValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), failedNumbers.stream().collect(Collectors.joining(","))));
        }
        return null;
    }

    public static void check4ChangeBill(ExtendedDataEntity[] dataEntities, Set<String> failedNumbers) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject changeBill = dataEntity.getDataEntity();
            DynamicObjectCollection fieldEntry = changeBill.getDynamicObjectCollection("fieldentry");
            for (DynamicObject dynamicObject : fieldEntry) {
                DynamicObject finCard = dynamicObject.getDynamicObject("fincard1");
                DynamicObject realCard = dynamicObject.getDynamicObject("realcard1");
                String cardNumber = null;
                if (realCard != null) {
                    cardNumber = realCard.getString("number");
                }
                if (finCard != null || !StringUtils.isNotEmpty((String)cardNumber)) continue;
                failedNumbers.add(cardNumber);
            }
        }
    }

    public static void check4SplitBill(ExtendedDataEntity[] dataEntities, Set<String> failedNumbers) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject splitBill = dataEntity.getDataEntity();
            DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
            for (DynamicObject befSplit : befSplitEntry) {
                DynamicObject finCard = befSplit.getDynamicObject("bef_fincard");
                DynamicObject realCard = befSplit.getDynamicObject("realcard");
                String cardNumber = null;
                if (realCard != null) {
                    cardNumber = realCard.getString("number");
                }
                if (finCard != null || !StringUtils.isNotEmpty((String)cardNumber)) continue;
                failedNumbers.add(cardNumber);
            }
        }
    }

    public static void check4MergeBill(ExtendedDataEntity[] dataEntities, Set<String> failedNumbers) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject mergeBill = dataEntity.getDataEntity();
            DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
            for (DynamicObject inEntry : inEntryEntity) {
                DynamicObject finCard = inEntry.getDynamicObject("infincard");
                DynamicObject realCard = inEntry.getDynamicObject("inrealcard");
                String cardNumber = null;
                if (realCard != null) {
                    cardNumber = realCard.getString("number");
                }
                if (finCard != null || !StringUtils.isNotEmpty((String)cardNumber)) continue;
                failedNumbers.add(cardNumber);
            }
        }
    }
}

