/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.utils.FaCheckBaseDataRef;

public class FaCardDeleteRelationValidator
extends AbstractValidator {
    private String billNumber;

    public FaCardDeleteRelationValidator(String billNumber) {
        this.billNumber = billNumber;
    }

    public void validate() {
        PKFieldProp pkProp = (PKFieldProp)this.getValidateContext().getSubEntityType().getPrimaryKey();
        if (pkProp == null) {
            return;
        }
        HashMap<Object, String> idToNumber = new HashMap<Object, String>(this.dataEntities.length);
        HashMap<String, ExtendedDataEntity> numberToExtendedDateEntity = new HashMap<String, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataObj : this.dataEntities) {
            if (this.validateContext.getValidateResults().getErrorDataIndexs().contains(dataObj.getDataEntityIndex())) continue;
            Object idValue = dataObj.getBillPkId();
            if (pkProp.getValueComparator().compareValue(idValue)) continue;
            String number = dataObj.getDataEntity().getString("number");
            idToNumber.put(idValue, number);
            numberToExtendedDateEntity.put(number, dataObj);
        }
        if (idToNumber.isEmpty()) {
            return;
        }
        this.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", "fa_clearapplybill", "fa_additiondevrecord"));
        try {
            Map checkRefResult = FaCheckBaseDataRef.checkRef((String)this.billNumber, (OperateOption)this.getOption(), idToNumber);
            for (Map.Entry checkRef : checkRefResult.entrySet()) {
                String number = (String)checkRef.getKey();
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)numberToExtendedDateEntity.get(number);
                this.addErrorMessage(extendedDataEntity, (String)checkRef.getValue());
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u68c0\u67e5\u5f15\u7528\u5f02\u5e38\uff1a%s", (String)"FaCardDeleteRelationValidator_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

