/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.utils.FaFindPeriodHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaCurrencyUtil;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.ClearApplyFinData;
import kd.fi.fa.opplugin.changebill.validator.FaClearApplyBillSaveValidator;
import kd.fi.fa.opplugin.changebill.validator.FaClearApplyBillSubmitValidator;
import kd.fi.fa.opplugin.changebill.validator.FaSourceFlagValidator;

public class FaClearApplyBillSubmitOp
extends AbstractBizCtrOperationServicePlugIn {
    private static final String FIN_CARD_QUERY_FIELDS = Fa.comma((String[])new String[]{"realcardmasterid", "number", "bizperiod", "endperiod", "originalval", "accumdepre", "decval", "preresidualval"});

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("cleardate");
        fieldKeys.add("realcard");
        fieldKeys.add("clearqty");
        fieldKeys.add("currency");
        fieldKeys.add("clearoriginalval");
        fieldKeys.add("clearaccumdepre");
        fieldKeys.add("cleardecval");
        fieldKeys.add("clearpreresidualval");
        fieldKeys.add("clearnetworth");
        fieldKeys.add("clearnetamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaClearApplyBillSaveValidator());
        e.addValidator((AbstractValidator)new FaClearApplyBillSubmitValidator());
        e.addValidator((AbstractValidator)new FaSourceFlagValidator("clrapplybill_entry", "realcard"));
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, DynamicObject> org2MainBook = new HashMap<Long, DynamicObject>(4);
        HashMap<Long, DynamicObject> currencyId2Currency = new HashMap<Long, DynamicObject>(4);
        HashMap<String, List<DynamicObject>> orgAndBizPeriod2ClearApplyBills = new HashMap<String, List<DynamicObject>>(4);
        HashMap<Long, FaFindPeriodHelper> periodType2PeriodHelper = new HashMap<Long, FaFindPeriodHelper>(4);
        for (DynamicObject dataEntity : dataEntities) {
            long orgId = dataEntity.getLong(Fa.id((String)"org"));
            DynamicObject mainBook = org2MainBook.computeIfAbsent(orgId, v -> FaUtils.getMainBookByOrg((Long)orgId));
            long currencyId = mainBook.getLong("basecurrency");
            DynamicObject currency = currencyId2Currency.computeIfAbsent(currencyId, v -> BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency"));
            dataEntity.set("currency", (Object)currency);
            long periodType = mainBook.getLong("periodtype");
            FaFindPeriodHelper findPeriodHelper = periodType2PeriodHelper.computeIfAbsent(periodType, v -> new FaFindPeriodHelper(Long.valueOf(periodType)));
            Date clearDate = dataEntity.getDate("cleardate");
            Long periodIdByDate = findPeriodHelper.findPeriodIdByDate(clearDate);
            String key = orgId + "_" + periodIdByDate;
            List clearApplyList = orgAndBizPeriod2ClearApplyBills.computeIfAbsent(key, k -> new ArrayList(4));
            clearApplyList.add(dataEntity);
        }
        this.queryFinDataAndProcessData(org2MainBook, orgAndBizPeriod2ClearApplyBills);
    }

    private void queryFinDataAndProcessData(Map<Long, DynamicObject> org2MainBook, Map<String, List<DynamicObject>> orgAndBizPeriod2ClearApplyBills) {
        for (Map.Entry<String, List<DynamicObject>> map : orgAndBizPeriod2ClearApplyBills.entrySet()) {
            String key = map.getKey();
            String[] orgIdAndPeriodId = key.split("_");
            Long orgId = Long.valueOf(orgIdAndPeriodId[0]);
            long periodId = Long.parseLong(orgIdAndPeriodId[1]);
            List<DynamicObject> clearApplyList = map.getValue();
            HashMap<String, Long> number2MasterId = new HashMap<String, Long>(16);
            for (DynamicObject clearApply : clearApplyList) {
                DynamicObjectCollection applyEntry = clearApply.getDynamicObjectCollection("clrapplybill_entry");
                number2MasterId.putAll(applyEntry.stream().collect(Collectors.toMap(k -> k.getString(Fa.dot((String[])new String[]{"realcard", "number"})), v -> v.getLong(Fa.dot((String[])new String[]{"realcard", "masterid"})))));
            }
            HashMap<String, ClearApplyFinData> number2Data = new HashMap<String, ClearApplyFinData>(number2MasterId.size());
            DailyDepreImpl dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "clrapplybill");
            long depreUseId = org2MainBook.get(orgId).getLong("depreuse");
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
            Map orgPredictResult = dailyDepreImpl.predictPeriodDepe((Object)orgId, Long.valueOf(depreUseId), period, false, true, number2MasterId.keySet());
            String resultKey = orgId + "_" + depreUseId + "_" + periodId;
            Map depResult = (Map)orgPredictResult.get(resultKey);
            for (Map.Entry result : depResult.entrySet()) {
                String number = (String)result.getKey();
                Map finData = (Map)result.getValue();
                ClearApplyFinData clearApplyFinData = new ClearApplyFinData(new BigDecimal(finData.get("originalval").toString()), new BigDecimal(finData.get("accumdepre").toString()), new BigDecimal(finData.get("decval").toString()), new BigDecimal(finData.get("preresidualval").toString()));
                number2Data.put(number, clearApplyFinData);
                number2MasterId.remove(number);
            }
            if (!number2MasterId.isEmpty()) {
                DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)FIN_CARD_QUERY_FIELDS, (QFilter[])new QFilter[]{new QFilter("realcardmasterid", "in", number2MasterId.values()), new QFilter("bizperiod", "<=", (Object)periodId), new QFilter("endperiod", ">", (Object)periodId)});
                for (DynamicObject finCard : finCards) {
                    ClearApplyFinData clearApplyFinData = new ClearApplyFinData(finCard.getBigDecimal("originalval"), finCard.getBigDecimal("accumdepre"), finCard.getBigDecimal("decval"), finCard.getBigDecimal("preresidualval"));
                    number2Data.put(finCard.getString("number"), clearApplyFinData);
                }
            }
            this.calcClearApplyFinValue(clearApplyList, number2Data);
        }
    }

    private void calcClearApplyFinValue(List<DynamicObject> clearApplyList, Map<String, ClearApplyFinData> number2Data) {
        for (DynamicObject clearApplyBill : clearApplyList) {
            DynamicObject currency = clearApplyBill.getDynamicObject("currency");
            DynamicObjectCollection clearApplyEntry = clearApplyBill.getDynamicObjectCollection("clrapplybill_entry");
            for (DynamicObject entry : clearApplyEntry) {
                BigDecimal assetQty = entry.getBigDecimal(Fa.dot((String[])new String[]{"realcard", "assetamount"}));
                BigDecimal clearQty = entry.getBigDecimal("clearqty");
                BigDecimal rate = clearQty.divide(assetQty, 10, 4);
                String number = entry.getString(Fa.dot((String[])new String[]{"realcard", "number"}));
                ClearApplyFinData clearApplyFinData = number2Data.get(number);
                BigDecimal clearOriginalVal = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)currency, (BigDecimal)clearApplyFinData.getClearOriginalVal().multiply(rate));
                entry.set("clearoriginalval", (Object)clearOriginalVal);
                BigDecimal clearAccDepre = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)currency, (BigDecimal)clearApplyFinData.getClearAccumDepre().multiply(rate));
                entry.set("clearaccumdepre", (Object)clearAccDepre);
                BigDecimal clearDecVal = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)currency, (BigDecimal)clearApplyFinData.getClearDecVal().multiply(rate));
                entry.set("cleardecval", (Object)clearDecVal);
                BigDecimal clearPreResidualVal = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)currency, (BigDecimal)clearApplyFinData.getClearPreResidualVal().multiply(rate));
                entry.set("clearpreresidualval", (Object)clearPreResidualVal);
                BigDecimal clearNetWorth = clearOriginalVal.subtract(clearAccDepre);
                entry.set("clearnetworth", (Object)clearNetWorth);
                BigDecimal cleaNetAmount = clearOriginalVal.subtract(clearAccDepre).subtract(clearDecVal);
                entry.set("clearnetamount", (Object)cleaNetAmount);
            }
        }
    }
}

