/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.merge.impl.FaMergeBillServiceImpl;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class FaClearBillAdjust2BizDateValidator
extends AbstractValidator {
    static String selectBookFields = Fa.comma((String[])new String[]{"depreuse", "curperiod", "periodtype"});
    static String selectPeriodFields = Fa.comma((String[])new String[]{"id", "begindate", "enddate"});

    public void validate() {
        HashMap<Long, DynamicObjectCollection> orgId2AssetBooks = new HashMap<Long, DynamicObjectCollection>(4);
        HashMap<Long, DynamicObjectCollection> orgId2Periods = new HashMap<Long, DynamicObjectCollection>(4);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Long depreUseId;
            Object period2;
            DynamicObjectCollection periods;
            DynamicObjectCollection books;
            DynamicObject clearBillDy = dataEntity.getDataEntity();
            DynamicObjectCollection clearEntries = clearBillDy.getDynamicObjectCollection("detail_entry");
            Long orgId = clearBillDy.getLong("org.id");
            HashMap<Long, Set<DynamicObject>> depreUseId2ClearEntry = new HashMap<Long, Set<DynamicObject>>(16);
            HashMap<String, Map<String, Object>> depUseIdRCardMasterIdInfoMap = new HashMap<String, Map<String, Object>>(16);
            for (DynamicObject clearEntry : clearEntries) {
                Long depreUseId2 = clearEntry.getLong(Fa.id((String)"depreuse"));
                HashSet<DynamicObject> clearEntrySet = (HashSet<DynamicObject>)depreUseId2ClearEntry.get(depreUseId2);
                if (clearEntrySet == null) {
                    clearEntrySet = new HashSet<DynamicObject>(256);
                    depreUseId2ClearEntry.put(depreUseId2, clearEntrySet);
                }
                clearEntrySet.add(clearEntry);
                Long rCardMasterId = clearEntry.getLong(Fa.dot((String[])new String[]{"realcard", "masterid"}));
                String key = depreUseId2 + "_" + rCardMasterId;
                HashMap<String, Object> valueMap = new HashMap<String, Object>(2);
                valueMap.put("number", clearEntry.getString(Fa.dot((String[])new String[]{"realcard", "number"})));
                valueMap.put("bizdate", clearEntry.getDate("bizdate"));
                depUseIdRCardMasterIdInfoMap.put(key, valueMap);
            }
            if (orgId2AssetBooks.containsKey(orgId)) {
                books = (DynamicObjectCollection)orgId2AssetBooks.get(orgId);
            } else {
                QFilter[] bookFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
                books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectBookFields, (QFilter[])bookFilters);
                orgId2AssetBooks.put(orgId, books);
            }
            HashMap<Long, Long> depreuseId2CurPeriodId = new HashMap<Long, Long>(3, 1.0f);
            for (DynamicObject book : books) {
                depreuseId2CurPeriodId.put(book.getLong("depreuse"), book.getLong("curperiod"));
            }
            if (orgId2Periods.containsKey(orgId)) {
                periods = (DynamicObjectCollection)orgId2Periods.get(orgId);
            } else {
                QFilter[] periodFilters = new QFilter[]{new QFilter("id", "in", depreuseId2CurPeriodId.values())};
                periods = QueryServiceHelper.query((String)"bd_period", (String)selectPeriodFields, (QFilter[])periodFilters);
                orgId2Periods.put(orgId, periods);
            }
            HashMap<Long, DynamicObject> peroidId2PeriodMap = new HashMap<Long, DynamicObject>(periods.size(), 1.0f);
            for (Object period2 : periods) {
                peroidId2PeriodMap.put(period2.getLong("id"), (DynamicObject)period2);
            }
            HashMap depreUseId2PeriodMap = new HashMap(books.size(), 1.0f);
            period2 = depreuseId2CurPeriodId.entrySet().iterator();
            while (period2.hasNext()) {
                Map.Entry dcEntry = (Map.Entry)period2.next();
                depreUseId2PeriodMap.put(dcEntry.getKey(), peroidId2PeriodMap.get(dcEntry.getValue()));
            }
            HashSet<String> depreUseIdRealIdSet = new HashSet<String>(256);
            for (Map.Entry dcClearEntry : depreUseId2ClearEntry.entrySet()) {
                depreUseId = (Long)dcClearEntry.getKey();
                Long periodId = (Long)depreuseId2CurPeriodId.get(depreUseId);
                Set dcClearEntrySet = (Set)dcClearEntry.getValue();
                HashSet<Long> realIds = new HashSet<Long>(dcClearEntrySet.size());
                for (DynamicObject dcClearEntryDy : dcClearEntrySet) {
                    realIds.add(dcClearEntryDy.getLong("realcard.id"));
                }
                SqlBuilder sbSqlAdjust = new SqlBuilder();
                sbSqlAdjust.append("SELECT d.frealcardid realcardid  FROM t_fa_depreadjustbill m,t_fa_depreadjustentry d where m.fid = d.fid ", new Object[0]).append(" and m.forgid = ? ", new Object[]{orgId}).append(" and m.fdepreuseid = ? ", new Object[]{depreUseId}).append(" and m.fperiodid  = ? ", new Object[]{periodId}).appendIn(" and d.frealcardid ", realIds.toArray());
                DataSet adjustDS = DB.queryDataSet((String)"FaClearBillAdjust2BizDateValidatorQueryAdjustRealIds", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbSqlAdjust);
                Throwable throwable = null;
                try {
                    for (Row row : adjustDS) {
                        depreUseIdRealIdSet.add(depreUseId + "_" + row.getLong("realcardid"));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (adjustDS == null) continue;
                    if (throwable != null) {
                        try {
                            adjustDS.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    adjustDS.close();
                }
            }
            this.checkBizDateByMergeBill(dataEntity, depUseIdRCardMasterIdInfoMap);
            if (depreUseIdRealIdSet.size() == 0) {
                return;
            }
            for (DynamicObject clearEntry : clearEntries) {
                depreUseId = clearEntry.getLong("depreuse.id");
                Long realId = clearEntry.getLong("realcard.id");
                String key = depreUseId + "_" + realId;
                if (!depreUseIdRealIdSet.contains(key)) continue;
                Date bizDate = clearEntry.getDate("bizdate");
                DynamicObject period3 = (DynamicObject)depreUseId2PeriodMap.get(depreUseId);
                Date beginDate = period3.getDate("begindate");
                Date endDate = period3.getDate("enddate");
                boolean isInPeriod = beginDate.compareTo(bizDate) <= 0 && bizDate.compareTo(endDate) <= 0;
                if (isInPeriod) continue;
                String depreUseName = clearEntry.getString("depreuse.name");
                String realNumber = clearEntry.getString("realcard.number");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014[%1$s],\u8d44\u4ea7\u7f16\u7801[%2$s]\u672c\u671f\u505a\u4e86\u6298\u65e7\u8c03\u6574\uff0c\u4e1a\u52a1\u65e5\u671f\u53ea\u80fd\u5728\u5f53\u671f\u671f\u95f4", (String)"FaClearBillAdjust2BizDateValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreUseName, realNumber));
            }
            this.checkClearBefHasAdjustDevalue(dataEntity, depreUseId2ClearEntry, depreuseId2CurPeriodId);
        }
    }

    private void checkBizDateByMergeBill(ExtendedDataEntity dataEntity, Map<String, Map<String, Object>> depUseIdRCardMasterIdInfoMap) {
        HashSet<String> nonCompliantNumberSet = new HashSet<String>(16);
        HashSet<Long> realCardMasterIds = new HashSet<Long>(depUseIdRCardMasterIdInfoMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : depUseIdRCardMasterIdInfoMap.entrySet()) {
            String[] splitArray = entry.getKey().split("_");
            realCardMasterIds.add(Long.valueOf(splitArray[1]));
        }
        FaMergeBillServiceImpl mergeBillService = new FaMergeBillServiceImpl();
        Map mergeBills = mergeBillService.findCardLatestMergedPeriod(realCardMasterIds);
        for (Map.Entry<String, Map<String, Object>> entry : depUseIdRCardMasterIdInfoMap.entrySet()) {
            Date mergeBeginDate;
            Date bizDate = (Date)entry.getValue().get("bizdate");
            String cardNumber = (String)entry.getValue().get("number");
            DynamicObject latestMergedPeriod = (DynamicObject)mergeBills.get(entry.getKey());
            if (latestMergedPeriod == null || DateUtil.compareShortDate((Date)bizDate, (Date)(mergeBeginDate = latestMergedPeriod.getDate("begindate"))) != -1) continue;
            nonCompliantNumberSet.add(cardNumber);
        }
        if (CollectionUtils.isNotEmpty(nonCompliantNumberSet)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801[%s]\u6e05\u7406\u7684\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8be5\u5361\u7247\u6700\u8fd1\u4e00\u6b21\u5408\u5e76\u5355\u8bb0\u8d26\u65e5\u671f\u6240\u5728\u671f\u95f4\u7684\u7b2c\u4e00\u5929\u3002", (String)"FaClearBillAdjust2BizDateValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), nonCompliantNumberSet.stream().collect(Collectors.joining(", "))));
        }
    }

    private void checkClearBefHasAdjustDevalue(ExtendedDataEntity dataEntity, Map<Long, Set<DynamicObject>> depreUseId2ClearEntry, Map<Long, Long> depreuseId2CurPeriodId) {
        DynamicObject clearBillDy = dataEntity.getDataEntity();
        Long orgId = clearBillDy.getLong(Fa.id((String)"org"));
        DynamicObjectCollection clearEntries = clearBillDy.getDynamicObjectCollection("detail_entry");
        for (Map.Entry<Long, Set<DynamicObject>> dcClearEntry : depreUseId2ClearEntry.entrySet()) {
            Long depreUseId = dcClearEntry.getKey();
            Long periodId = depreuseId2CurPeriodId.get(depreUseId);
            Set<DynamicObject> dcClearEntrySet = dcClearEntry.getValue();
            HashSet<Long> realIds = new HashSet<Long>(dcClearEntrySet.size());
            for (DynamicObject dcClearEntryDy : dcClearEntrySet) {
                realIds.add(dcClearEntryDy.getLong("realcard.id"));
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkClearBefHasAdjustDevalue", (String)"fa_asset_devalue", (String)Fa.dot((String[])new String[]{"changebillentry", "realcardmasterid"}), (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("devalueperiod", "=", (Object)periodId), new QFilter(Fa.dot((String[])new String[]{"changebillentry", "realcardmasterid"}), "in", realIds), new QFilter(Fa.dot((String[])new String[]{"changebillentry", "isadjustdepre"}), "=", (Object)true)}, null);
            if (dataSet.isEmpty()) continue;
            HashSet<Long> hasAfterAdjustDevalueCardIds = new HashSet<Long>(realIds.size());
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                hasAfterAdjustDevalueCardIds.add(next.getLong(Fa.dot((String[])new String[]{"changebillentry", "realcardmasterid"})));
            }
            for (DynamicObject clearEntry : clearEntries) {
                if (clearEntry.getLong(Fa.id((String)"depreuse")) != depreUseId.longValue() || !hasAfterAdjustDevalueCardIds.contains(clearEntry.getLong(Fa.id((String)"realcard")))) continue;
                String depreUseName = clearEntry.getString(Fa.dot((String[])new String[]{"depreuse", "name"}));
                String realNumber = clearEntry.getString(Fa.dot((String[])new String[]{"realcard", "number"}));
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014[%1$s],\u8d44\u4ea7\u7f16\u7801[%2$s]\u5f53\u671f\u5b58\u5728\u6298\u65e7\u8c03\u6574\u540e\u7684\u51cf\u503c\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u505a\u6e05\u7406\u3002", (String)"FaClearBillAdjust2BizDateValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreUseName, realNumber));
            }
        }
    }
}

