/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.FaClearBillAuditCompFieldValidator;
import kd.fi.fa.opplugin.clear.FaClearBillOpUtils;
import kd.fi.fa.utils.FaOpUtils;

public class FaClearBillAuditOp
extends AbstractBizCtrOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("detail_entry");
        fieldKeys.add("fincard");
        fieldKeys.add("depreuse");
        fieldKeys.add("realcard");
        fieldKeys.add("cleardate");
        fieldKeys.add("clearqty");
        fieldKeys.add("isclearall");
        fieldKeys.add("clearperiod");
        fieldKeys.add("detail_entry.assetqty");
        fieldKeys.add("detail_entry.clearqty");
        fieldKeys.add("detail_entry.assetvalue");
        fieldKeys.add("detail_entry.decval");
        fieldKeys.add("detail_entry.preresidualval");
        fieldKeys.add("detail_entry.netamount");
        fieldKeys.add("detail_entry.compfieldsv");
        fieldKeys.add("detail_entry.realcardmasterid");
        fieldKeys.add("org");
        fieldKeys.add(Fa.dot((String[])new String[]{"detail_entry", "realcard"}));
        fieldKeys.add("changemode");
        fieldKeys.add("basecurrency");
        fieldKeys.add("addupdepre");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
                HashMap<String, String> orgIdAndPeriodId2SumHasVouMsg = new HashMap<String, String>(this.dataEntities.length);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String bookNames = FaOpUtils.checkAssetBookDate(dataEntity.getDataEntity(), "org", "cleardate");
                    if (!bookNames.isEmpty()) {
                        String msgCaption = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4", (String)"FaClearBillAuditOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, String.format("%s:%s", msgCaption, bookNames));
                        continue;
                    }
                    String msg = FaClearBillOpUtils.checkDepreSumVouncher(orgId2SumMutilVou, dataEntity.getDataEntity(), orgIdAndPeriodId2SumHasVouMsg);
                    if (msg == null) continue;
                    this.addMessage(dataEntity, msg);
                }
            }
        });
        e.addValidator((AbstractValidator)new FaClearBillAuditCompFieldValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        FaOpUtils.doOp(e, "fa_clearbill");
    }
}

