/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.clear.ClearBillGeneratorHelper;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaOpUtils;

public class FaClearBillSaveValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, List> orgId2AssetBooks = new HashMap<Long, List>(4);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean iscurr;
            List assetBooks;
            int entrySize = dataEntity.getDataEntity().getDynamicObjectCollection("detail_entry").size();
            if (entrySize == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e05\u7406\u5355\u7684\u5206\u5f55\u4e3a\u7a7a\u3002", (String)"FaClearBillSaveValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            DynamicObject bill = dataEntity.getDataEntity();
            long orgId = bill.getLong("org_id");
            Date clearDate = bill.getDate("cleardate");
            if (orgId2AssetBooks.containsKey(orgId)) {
                assetBooks = (List)orgId2AssetBooks.get(orgId);
            } else {
                assetBooks = FaBizUtils.getAsstBooksByOrg((Long)orgId);
                orgId2AssetBooks.put(orgId, assetBooks);
            }
            if (assetBooks.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u8d26\u7c3f,\u4e0d\u80fd\u64cd\u4f5c", (String)"FaClearBillSaveValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            for (DynamicObject dyn : assetBooks) {
                String status = dyn.getString("status");
                if (!status.equals("B")) continue;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\uff1a%s\u672a\u542f\u7528\uff0c\u8bf7\u542f\u7528\u540e\u518d\u8bd5", (String)"FaOpUtils_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), dyn.getString("name"));
                this.addMessage(dataEntity, errorMsg, ErrorLevel.Error);
                return;
            }
            if (clearDate != null && !(iscurr = FaBizUtils.isCurrentDate((Date)clearDate, (List)assetBooks))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u591a\u4e2a\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7684\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"FaClearBillSaveValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            long clearPeriod = ((DynamicObject)assetBooks.get(0)).getLong("curperiod");
            int rowIndex = 0;
            Map<Long, Date> endDates = this.getEndDateAssbookByOrg(assetBooks);
            for (DynamicObject everyRow : bill.getDynamicObjectCollection("detail_entry")) {
                ++rowIndex;
                DynamicObject realCardObj = everyRow.getDynamicObject("realcard");
                if (realCardObj == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c,\u5361\u7247\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u68c0\u67e5\u6570\u636e\u3002", (String)"FaClearBillSaveValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex));
                }
                String number = realCardObj.getString("number");
                Date realAccountDate = realCardObj.getDate("realaccountdate");
                Date bizDate = everyRow.getDate("bizdate");
                long depreuseId = everyRow.getLong(Fa.id((String)"depreuse"));
                DynamicObject finCard = everyRow.getDynamicObject("fincard");
                String depreuseName = finCard.getString(Fa.dot((String[])new String[]{"depreuse", "name"}));
                long addPeriod = finCard.getLong("period_id");
                long cardBizPeriod = finCard.getLong("bizperiod_id");
                boolean clearAll = "1".equals(everyRow.getString("isclearall"));
                Date finaccountdate = finCard.getDate("finaccountdate");
                boolean enableCurPeriodBiz = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)orgId);
                if (addPeriod == cardBizPeriod && clearPeriod == addPeriod && !clearAll && !enableCurPeriodBiz) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u5361\u7247\u65b0\u589e\u5f53\u671f\u4e0d\u80fd\u505a\u90e8\u5206\u6e05\u7406\u3002", (String)"FaClearBillSaveValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (bizDate == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaClearBillSaveValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (DateUtil.compareShortDate((Date)bizDate, (Date)realAccountDate) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u542f\u7528\u65e5\u671f\u3002", (String)"FaClearBillSaveValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (DateUtil.compareShortDate((Date)bizDate, (Date)finaccountdate) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u3002", (String)"FaClearBillSaveValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                Date endDate = endDates.get(depreuseId);
                if (DateUtil.compareShortDate((Date)bizDate, (Date)endDate) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u3002", (String)"FaClearBillSaveValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
            }
            String result = ClearBillGeneratorHelper.getAdjustClearCard((DynamicObject)bill);
            if (!result.isEmpty()) {
                this.addMessage(dataEntity, result);
                continue;
            }
            DynamicObjectCollection clearEntries = bill.getDynamicObjectCollection("detail_entry");
            List finCards = clearEntries.stream().map(v -> v.getDynamicObject("fincard")).collect(Collectors.toList());
            boolean finCardIsNull = false;
            for (DynamicObject finCard : finCards) {
                if (finCard != null) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355", (String)"FaClearBillSaveValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                finCardIsNull = true;
            }
            if (finCardIsNull) continue;
            try {
                FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "detail_entry", "realcard.masterid", "fa_clearbill");
            }
            catch (Exception e) {
                this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
            }
        }
    }

    private Map<Long, Date> getEndDateAssbookByOrg(List<DynamicObject> assetBooks) {
        HashMap<Long, Date> result = new HashMap<Long, Date>(assetBooks.size());
        for (DynamicObject assetbook : assetBooks) {
            Date endDate = assetbook.getDate("enddate");
            result.put(assetbook.getLong("depreuse"), endDate);
        }
        return result;
    }
}

