/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.clear.ClearBillGeneratorHelper;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.restartrealbill.utils.CommonCheckUtils;
import kd.fi.fa.utils.FaOpUtils;

public class FaClearBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> realCardIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            realCardIds.addAll(dataEntity.getDataEntity().getDynamicObjectCollection("detail_entry").stream().map(v -> v.getLong(Fa.id((String)"realcard"))).collect(Collectors.toSet()));
        }
        Map<Long, Date> splitDate4CardId = this.getSplitDate4CardId(realCardIds);
        HashMap<Long, List> orgId2AssetBooks = new HashMap<Long, List>(4);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String result;
            String msg;
            List assetBooks;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Date changedate = dynamicObject.getDate("cleardate");
            long orgId = dynamicObject.getLong("org_id");
            if (orgId2AssetBooks.containsKey(orgId)) {
                assetBooks = (List)orgId2AssetBooks.get(orgId);
            } else {
                assetBooks = FaBizUtils.getAsstBooksByOrg((Long)orgId);
                orgId2AssetBooks.put(orgId, assetBooks);
            }
            if (assetBooks.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u8d26\u7c3f,\u4e0d\u80fd\u64cd\u4f5c", (String)"FaClearBillSubmitValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            boolean iscurr = FaBizUtils.isCurrentDate((Date)changedate, (List)assetBooks);
            if (!iscurr) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u591a\u4e2a\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7684\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"FaClearBillSubmitValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            long clearPeriod = ((DynamicObject)assetBooks.get(0)).getLong("curperiod");
            if (FaClearSourceEnum.ADDNEW.toString().equalsIgnoreCase(dynamicObject.getString("clearsource"))) {
                int entrySize = dynamicObject.getDynamicObjectCollection("detail_entry").size();
                if (entrySize == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e05\u7406\u5355\u7684\u5206\u5f55\u4e3a\u7a7a\u3002", (String)"FaClearBillSubmitValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    continue;
                }
                try {
                    FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "detail_entry", "realcard_Id", "fa_clearbill");
                }
                catch (Exception e) {
                    this.addMessage(dataEntity, e.getMessage(), ErrorLevel.Error);
                }
            }
            if ((msg = FaOpUtils.checkAssetBookStruts(assetBooks)) != null) {
                this.addMessage(dataEntity, msg, ErrorLevel.Error);
                continue;
            }
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection clearEntries = bill.getDynamicObjectCollection("detail_entry");
            List finCards = clearEntries.stream().map(v -> v.getDynamicObject("fincard")).collect(Collectors.toList());
            boolean finCardIsNull = false;
            for (DynamicObject finCard : finCards) {
                if (finCard != null) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u5236\u5355", (String)"FaClearBillSubmitValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                finCardIsNull = true;
            }
            if (finCardIsNull) continue;
            HashMap<Object, String> realCardId2NameMap = new HashMap<Object, String>();
            int rowIndex = 0;
            HashMap<Long, Boolean> realCardId2IsAllClearMap = new HashMap<Long, Boolean>();
            Map<Long, Date> endDates = this.getEndDateAssbookByOrg(assetBooks);
            HashMap<Long, BigDecimal> realCardIdAndAmount = new HashMap<Long, BigDecimal>();
            for (DynamicObject everyRow : dynamicObject.getDynamicObjectCollection("detail_entry")) {
                DynamicObject realCardObj = everyRow.getDynamicObject("realcard");
                Long realPk = (Long)realCardObj.getPkValue();
                Date realAccountDate = realCardObj.getDate("realaccountdate");
                Date bizDate = everyRow.getDate("bizdate");
                DynamicObject finCardObj = everyRow.getDynamicObject("fincard");
                BigDecimal originalval = finCardObj.getBigDecimal("originalval");
                BigDecimal rowAssetValue = everyRow.getBigDecimal("assetvalue");
                BigDecimal rowAssetQty = realCardObj.getBigDecimal("assetamount");
                BigDecimal rowClearValue = everyRow.getBigDecimal("clearqty");
                Long realCardPk = (Long)realCardObj.getPkValue();
                String number = realCardObj.getString("number");
                DynamicObject depreuse = everyRow.getDynamicObject("depreuse");
                String depreuseName = depreuse.getString("name");
                long depreuseId = depreuse.getLong("id");
                Date finaccountdate = finCardObj.getDate("finaccountdate");
                realCardId2NameMap.put(realPk, number);
                ++rowIndex;
                long addPeriod = finCardObj.getLong("period_id");
                long cardBizPeriod = finCardObj.getLong("bizperiod_id");
                boolean clearAll = "1".equals(everyRow.getString("isclearall"));
                if (addPeriod == cardBizPeriod && clearPeriod == addPeriod && !clearAll && !FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)orgId)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u5361\u7247\u65b0\u589e\u5f53\u671f\u4e0d\u80fd\u505a\u90e8\u5206\u6e05\u7406\u3002", (String)"FaClearBillSubmitValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (bizDate == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaClearBillSubmitValidator_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (DateUtil.compareShortDate((Date)bizDate, (Date)realAccountDate) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u542f\u7528\u65e5\u671f\u3002", (String)"FaClearBillSubmitValidator_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (DateUtil.compareShortDate((Date)bizDate, (Date)finaccountdate) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u3002", (String)"FaClearBillSubmitValidator_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                Date endDate = endDates.get(depreuseId);
                if (DateUtil.compareShortDate((Date)bizDate, (Date)endDate) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u3002", (String)"FaClearBillSubmitValidator_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (splitDate4CardId.containsKey(realCardPk) && DateUtil.compareShortDate((Date)splitDate4CardId.get(realCardPk), (Date)bizDate) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8be5\u5361\u7247\u6700\u8fd1\u4e00\u6b21\u62c6\u5206\u5355\u8bb0\u8d26\u65e5\u671f\u3002", (String)"FaClearBillSubmitValidator_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (rowAssetQty.compareTo(BigDecimal.ZERO) > 0) {
                    if (rowClearValue.compareTo(BigDecimal.ZERO) <= 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u6e05\u7406\u6570\u91cf\u9700\u5927\u4e8e\u96f6\u3002", (String)"FaClearBillSubmitValidator_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                        continue;
                    }
                    if (rowClearValue.compareTo(rowAssetQty) > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u6e05\u7406\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u8d44\u4ea7\u6570\u91cf\u3002", (String)"FaClearBillSubmitValidator_12", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                        continue;
                    }
                }
                if (rowAssetValue.compareTo(originalval) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u6e05\u7406\u539f\u503c\u5e94\u8be5\u5c0f\u4e8e\u7b49\u4e8e\u8d22\u52a1\u5361\u7247\u8d44\u4ea7\u539f\u503c\u3002", (String)"FaClearBillSubmitValidator_13", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                    continue;
                }
                if (realCardIdAndAmount.get(realCardPk) != null) {
                    BigDecimal oneAmount = (BigDecimal)realCardIdAndAmount.get(realCardPk);
                    if (oneAmount.compareTo(rowClearValue) != 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u6e05\u7406\u6570\u91cf\u4e0e\u53e6\u4e00\u4e2a\u8d26\u7c3f\u5bf9\u5e94\u5361\u7247\u6e05\u7406\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"FaClearBillSubmitValidator_15", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
                        continue;
                    }
                } else {
                    realCardIdAndAmount.put(realCardPk, rowClearValue);
                }
                if (rowClearValue.compareTo(BigDecimal.ONE) != 0 || rowAssetValue.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal rate = rowAssetValue.divide(originalval, 10, RoundingMode.HALF_UP);
                this.checkMultipleAssetBooksClearMethod(realCardId2IsAllClearMap, realPk, rate, dataEntity, rowIndex, number, depreuseName);
            }
            if (realCardId2NameMap.size() > 0) {
                Set<Long> realCardIdSet = realCardId2NameMap.keySet();
                Set<Long> existsFaReStartRealBillRealCardId = CommonCheckUtils.existsFaReStartRealBill(clearPeriod, orgId, realCardIdSet);
                if (existsFaReStartRealBillRealCardId.size() > 0) {
                    HashSet<String> numberSet = new HashSet<String>(existsFaReStartRealBillRealCardId.size());
                    for (Long realCardId : existsFaReStartRealBillRealCardId) {
                        String number = (String)realCardId2NameMap.get(realCardId);
                        numberSet.add(number);
                    }
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\uff0c\u6e05\u7406\u5f53\u671f\u5b58\u5728\u91cd\u542f\u5355\u3002", (String)"FaClearBillSubmitValidator_18", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", numberSet));
                    this.addErrorMessage(dataEntity, errorMsg);
                }
            }
            if ((result = ClearBillGeneratorHelper.getAdjustClearCard((DynamicObject)bill)).isEmpty()) continue;
            this.addMessage(dataEntity, result);
        }
    }

    private void checkMultipleAssetBooksClearMethod(Map<Long, Boolean> realCardId2IsAllClearMap, Long realPk, BigDecimal rate, ExtendedDataEntity dataEntity, int rowIndex, String number, String depreuseName) {
        Boolean isAllClear = rate.compareTo(BigDecimal.ONE) == 0 ? Boolean.TRUE : Boolean.FALSE;
        Boolean preIsAllClearFlag = realCardId2IsAllClearMap.get(realPk);
        if (Objects.isNull(preIsAllClearFlag)) {
            realCardId2IsAllClearMap.put(realPk, isAllClear);
        } else if (!isAllClear.equals(preIsAllClearFlag)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d44\u4ea7\u7f16\u7801\uff1a%2$s\uff0c%3$s\uff0c\u4e0d\u5141\u8bb8\u6709\u7684\u8d26\u7c3f\u5b8c\u5168\u6e05\u7406\uff0c\u6709\u7684\u8d26\u7c3f\u90e8\u5206\u6e05\u7406\u3002", (String)"FaClearBillSubmitValidator_17", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex, number, depreuseName));
        }
    }

    private Map<Long, Date> getSplitDate4CardId(Set<Long> realCardIds) {
        if (realCardIds.isEmpty()) {
            return new HashMap<Long, Date>(0);
        }
        String aftRealCardField = Fa.dot((String[])new String[]{"assetsplitentry", "subassetsplitentry", "aft_realcard"});
        QFilter realFilter = new QFilter(aftRealCardField, "in", realCardIds).and("billstatus", "=", (Object)"C");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fa_assetsplitbill", (String)Fa.comma((String[])new String[]{"splitdate", aftRealCardField}), (QFilter[])new QFilter[]{realFilter});
        HashMap<Long, Date> cardId2Date = new HashMap<Long, Date>(collection.size());
        for (DynamicObject c : collection) {
            Date splitDate4Bill;
            Date splitDate4Map;
            Long realCardId = c.getLong(aftRealCardField);
            if (cardId2Date.containsKey(realCardId) && DateUtil.compareShortDate((Date)(splitDate4Map = (Date)cardId2Date.get(realCardId)), (Date)(splitDate4Bill = c.getDate("splitdate"))) > 0) continue;
            cardId2Date.put(c.getLong(aftRealCardField), c.getDate("splitdate"));
        }
        return cardId2Date;
    }

    private Map<Long, Date> getEndDateAssbookByOrg(List<DynamicObject> assetBooks) {
        HashMap<Long, Date> result = new HashMap<Long, Date>(assetBooks.size());
        for (DynamicObject assetBook : assetBooks) {
            Date endDate = assetBook.getDate("enddate");
            result.put(assetBook.getLong("depreuse"), endDate);
        }
        return result;
    }
}

