/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.impl.FaFinCardDaoOrmImpl;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.operate.IFaOpHandler;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaDevalueAssetValidator;
import kd.fi.fa.opplugin.FaMigrateDateValidator;

public class FaDevalueAssetAuditPlugin
extends AbstractBusyRecordServicePlugin
implements IFaOpHandler {
    private static final String[] selector = new String[]{"id", "realcard", "decval", "networth", "netamount", "monthdeprechg", "isneeddepre"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("devalueperiod");
        fieldKeys.add("realcard");
        fieldKeys.add("fincard");
        fieldKeys.add("depreuse");
        fieldKeys.add("changebillentry");
        fieldKeys.add("changebillentry.bizdate");
        fieldKeys.add("decval");
        fieldKeys.add("devalueperiod");
        fieldKeys.add("businessdate");
        fieldKeys.add("decval");
        fieldKeys.add("org");
        fieldKeys.add("changebillentry.compfieldsv");
        fieldKeys.add("isadjustdepre");
        fieldKeys.add("changebillentry.realcardmasterid");
        fieldKeys.add("changebillentry.realcard");
        fieldKeys.add("currency");
        fieldKeys.add("changebillentry.changemode");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator((AbstractValidator)new FaDevalueAssetValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        FunctionMutexHelperV2Utils.doFaOpWithWithBookPcChildLock((String)operationKey, (String)"fa_asset_devalue", (DynamicObject[])e.getDataEntities(), null, (IFaOpHandler)this);
    }

    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        switch (operationKey) {
            case "audit": {
                this.doAudit(dataEntities);
                break;
            }
            case "unaudit": {
                this.doUnAudit(dataEntities);
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String billKey;
        long depreuseId;
        long orgId;
        long depreuseId2;
        long orgId2;
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(10);
        HashSet<Long> depreUseIds = new HashSet<Long>(10);
        HashSet<String> billKeySet = new HashSet<String>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            orgId2 = bill.getLong("org_id");
            depreuseId2 = bill.getLong("depreuse_id");
            orgIds.add(orgId2);
            depreUseIds.add(depreuseId2);
            billKeySet.add("" + orgId2 + "-" + depreuseId2);
        }
        DynamicObjectCollection bookIds = QueryServiceHelper.query((String)"fa_assetbook", (String)"id, org, depreuse", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("depreuse", "in", depreUseIds)});
        HashMap<String, Long> billBookIdMap = new HashMap<String, Long>(dataEntities.length);
        for (DynamicObject book : bookIds) {
            orgId2 = book.getLong("org");
            depreuseId2 = book.getLong("depreuse");
            String billKey2 = "" + orgId2 + "-" + depreuseId2;
            if (!billKeySet.contains(billKey2)) continue;
            long id = book.getLong("id");
            billBookIdMap.put(billKey2, id);
        }
        MainEntityType changeBillType = EntityMetadataCache.getDataEntityType((String)"fa_assetbook");
        DynamicObject[] assetBooks = BusinessDataServiceHelper.load((Object[])billBookIdMap.values().toArray(), (DynamicObjectType)changeBillType);
        HashMap<String, DynamicObject> billBookMap = new HashMap<String, DynamicObject>(dataEntities.length);
        HashMap bookAdjustCardMap = new HashMap(8);
        for (DynamicObject book : assetBooks) {
            orgId = book.getLong("org_id");
            depreuseId = book.getLong("depreuse_id");
            billKey = "" + orgId + "-" + depreuseId;
            billBookMap.put(billKey, book);
            String selectFields = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"entryentity", "realcard"}), "auditdate"});
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId), new QFilter("period", "=", (Object)book.getLong(Fa.id((String)"curperiod")))};
            Iterator depreAdjustBills = QueryServiceHelper.query((String)"fa_depreadjustbill", (String)selectFields, (QFilter[])filters);
            if (depreAdjustBills == null || depreAdjustBills.size() <= 0) continue;
            Set realIdSet = depreAdjustBills.stream().map(v -> v.get(Fa.dot((String[])new String[]{"entryentity", "realcard"}))).collect(Collectors.toSet());
            bookAdjustCardMap.put(billKey, realIdSet);
        }
        for (DynamicObject bill : dataEntities) {
            orgId = bill.getLong("org_id");
            depreuseId = bill.getLong("depreuse_id");
            billKey = "" + orgId + "-" + depreuseId;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("changebillentry");
            HashSet<Long> finIdSet = new HashSet<Long>();
            for (DynamicObject row : entries) {
                long realCardId = row.getLong("realcard_id");
                Set adjustCards = (Set)bookAdjustCardMap.get(billKey);
                if (adjustCards != null && adjustCards.contains(realCardId)) continue;
                finIdSet.add(row.getLong("fincard_id"));
            }
            if (finIdSet.size() <= 0) continue;
            DynamicObject bookObj = (DynamicObject)billBookMap.get(billKey);
            DepreBook bookBox = new DepreBook(bookObj);
            bookBox.depreFinCardsAndRecordLog("fa_asset_devalue", finIdSet, false, false, false);
        }
    }

    private void doUnAudit(DynamicObject[] dataEntities) {
        HashSet<Object> deValueBillIds = new HashSet<Object>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            long periodId = dataEntity.getLong("devalueperiod.id");
            long depreuseId = dataEntity.getLong("depreuse_id");
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("changebillentry");
            HashSet realCardIds = new HashSet();
            entries.forEach(v -> realCardIds.add(v.getLong("realcard.id")));
            Map resultMap = new FaFinCardDaoOrmImpl().restoreCard(periodId, depreuseId, realCardIds.toArray(), v -> this.handle(dataEntity, v, false), selector);
            this.updateEntryFinCard(dataEntity, resultMap);
            deValueBillIds.add(dataEntity.getPkValue());
            FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)dataEntity, (String)"changebillentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.DEVALUE, (BizStatusEnum)BizStatusEnum.READY);
        }
        QFilter[] filters = new QFilter[]{new QFilter("entityname", "=", (Object)"fa_asset_devalue"), new QFilter("changebillid", "in", deValueBillIds)};
        DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])filters);
    }

    private void updateEntryFinCard(DynamicObject dataEntity, Map<Long, Map<Long, Long>> resultMap) {
        long depreuseId = dataEntity.getLong("depreuse_id");
        DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("changebillentry");
        if (!ObjectUtils.isEmpty(resultMap)) {
            for (DynamicObject entry : entries) {
                Long finID;
                Map<Long, Long> depreUse2FinID = resultMap.get(entry.getDynamicObject("realcard").getPkValue());
                if (depreUse2FinID == null || (finID = depreUse2FinID.get(depreuseId)) == null || finID == 0L) continue;
                entry.set("fincard_id", (Object)finID);
            }
        }
    }

    private void doAudit(DynamicObject[] dataEntities) {
        ArrayList<? extends DynamicObject> dynamicCards = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            long periodId = dataEntity.getLong("devalueperiod.id");
            long depreuseId = dataEntity.getLong("depreuse_id");
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("changebillentry");
            HashSet<Long> realCardIds = new HashSet<Long>();
            entries.forEach(v -> realCardIds.add(v.getLong("realcard.id")));
            Map resultMap = FaFinCardDaoFactory.getInstance().copyFinCards(periodId, depreuseId, realCardIds.toArray(), v -> this.handle(dataEntity, v, true), selector, null);
            this.updateEntryFinCard(dataEntity, resultMap);
            dynamicCards.addAll(this.buildDynamicCard(realCardIds, dataEntity));
            FaModiRealStatsUtils.update_oneBill_bizStatus((DynamicObject)dataEntity, (String)"changebillentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.READY, (BizStatusEnum)BizStatusEnum.DEVALUE);
        }
        if (!dynamicCards.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dynamicCards.toArray(new DynamicObject[0]));
        }
    }

    private Collection<? extends DynamicObject> buildDynamicCard(Set<Long> realCardIds, DynamicObject dataEntity) {
        Object depreUseId = dataEntity.get("depreuse_id");
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", dataEntity.get("org_id")), new QFilter("depreuse", "=", depreUseId)});
        Date periodBeginDate = dataEntity.getDate("devalueperiod.beginDate");
        DynamicObjectCollection alreadyDynamic = QueryServiceHelper.query((String)"fa_card_dynamic", (String)"realcard", (QFilter[])new QFilter[]{new QFilter("depreuse", "=", depreUseId), new QFilter("realcard", "in", realCardIds)});
        Set alreadyIds = alreadyDynamic.stream().map(v -> v.getLong("realcard")).collect(Collectors.toSet());
        realCardIds = new HashSet<Long>(realCardIds);
        realCardIds.removeAll(alreadyIds);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_card_dynamic");
        ArrayList<DynamicObject> dynamicCards = new ArrayList<DynamicObject>(realCardIds.size());
        DynamicObjectCollection cardEntry = dataEntity.getDynamicObjectCollection("changebillentry");
        for (DynamicObject card : cardEntry) {
            long cardId = card.getLong("realcard_id");
            if (!realCardIds.contains(cardId)) continue;
            Date bizDate = card.getDate("bizdate");
            DynamicObject dynamicCard = new DynamicObject((DynamicObjectType)type);
            dynamicCard.set("realcard", (Object)cardId);
            dynamicCard.set("assetbook", book.get("id"));
            dynamicCard.set("depreuse", depreUseId);
            dynamicCard.set("entityname", (Object)"fa_asset_devalue");
            dynamicCard.set("changebillid", dataEntity.getPkValue());
            dynamicCard.set("date", (Object)bizDate);
            dynamicCards.add(dynamicCard);
        }
        return dynamicCards;
    }

    private void handle(DynamicObject dataEntity, DynamicObject finCard, boolean isAudit) {
        DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("changebillentry");
        for (DynamicObject entry : entries) {
            if (entry.getLong("realcard_id") != finCard.getLong("realcardmasterid")) continue;
            BigDecimal decval = entry.getBigDecimal("decval");
            BigDecimal accumdevalue = finCard.getBigDecimal("decval");
            BigDecimal networth = finCard.getBigDecimal("networth");
            accumdevalue = isAudit ? accumdevalue.add(decval) : accumdevalue.subtract(decval);
            BigDecimal decvalChg = isAudit ? finCard.getBigDecimal("monthdeprechg").add(decval) : finCard.getBigDecimal("monthdeprechg").subtract(decval);
            BigDecimal netAmount = networth.subtract(accumdevalue);
            finCard.set("decval", (Object)accumdevalue);
            finCard.set("netamount", (Object)netAmount);
            finCard.set("monthdeprechg", (Object)decvalChg);
            if (!entry.getBoolean("isadjustdepre")) {
                finCard.set("isneeddepre", (Object)true);
            }
            entry.set("fincard_id", finCard.getPkValue());
            break;
        }
    }
}

