/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaFindPeriodHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaDispatchBillSaveOp;

public class FaDispatchBillSubmitOp
extends FaDispatchBillSaveOp {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("originalval");
        e.getFieldKeys().add("totaldepre");
        e.getFieldKeys().add("networth");
        e.getFieldKeys().add("netamount");
        e.getFieldKeys().add("decval");
        e.getFieldKeys().add("preresidualval");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, DynamicObject> org2MainBook = new HashMap<Long, DynamicObject>(4);
        HashMap<String, List<DynamicObject>> orgAndBizPeriod2DisPatchBills = new HashMap<String, List<DynamicObject>>(4);
        HashMap<Long, FaFindPeriodHelper> periodType2PeriodHelper = new HashMap<Long, FaFindPeriodHelper>(4);
        for (DynamicObject dataEntity : dataEntities) {
            long orgId = dataEntity.getLong(Fa.id((String)"org"));
            DynamicObject mainBook = org2MainBook.computeIfAbsent(orgId, v -> FaUtils.getMainBookByOrg((Long)orgId));
            long periodType = mainBook.getLong("periodtype");
            FaFindPeriodHelper findPeriodHelper = periodType2PeriodHelper.computeIfAbsent(periodType, v -> new FaFindPeriodHelper(Long.valueOf(periodType)));
            Date dispatchDate = dataEntity.getDate("dispatchdate");
            Long periodIdByDate = findPeriodHelper.findPeriodIdByDate(dispatchDate);
            String key = orgId + "_" + periodIdByDate;
            List dispatchBillList = orgAndBizPeriod2DisPatchBills.computeIfAbsent(key, k -> new ArrayList(4));
            dispatchBillList.add(dataEntity);
        }
        this.queryFinDataAndProcessData(org2MainBook, orgAndBizPeriod2DisPatchBills);
    }

    private void queryFinDataAndProcessData(Map<Long, DynamicObject> org2MainBook, Map<String, List<DynamicObject>> orgAndBizPeriod2DisPatchBills) {
        for (Map.Entry<String, List<DynamicObject>> map : orgAndBizPeriod2DisPatchBills.entrySet()) {
            Map clearPredictResult;
            List<DynamicObject> dispatchBillList = map.getValue();
            HashSet<Long> realCardIdSet = new HashSet<Long>(dispatchBillList.size());
            HashSet<String> numberSet = new HashSet<String>(dispatchBillList.size());
            for (DynamicObject dispatchBill : dispatchBillList) {
                DynamicObjectCollection dispatchEntry = dispatchBill.getDynamicObjectCollection("dispatchentry");
                for (DynamicObject row : dispatchEntry) {
                    realCardIdSet.add(row.getLong(Fa.dot((String[])new String[]{"realcard", "id"})));
                    numberSet.add(row.getString(Fa.dot((String[])new String[]{"realcard", "number"})));
                }
            }
            String key = map.getKey();
            String[] orgIdAndPeriodId = key.split("_");
            Long orgId = Long.valueOf(orgIdAndPeriodId[0]);
            long periodId = Long.parseLong(orgIdAndPeriodId[1]);
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter bizPeriodFilter = new QFilter("bizperiod", "<=", (Object)periodId);
            QFilter endPeriodFilter = new QFilter("endperiod", ">", (Object)periodId);
            QFilter clearPeriodFilter = new QFilter("clearperiod", "=", (Object)0L);
            long depreUseId = org2MainBook.get(orgId).getLong("depreuse");
            QFilter depreUseFilter = new QFilter("depreuse", "=", (Object)depreUseId);
            QFilter numberFilter = new QFilter("number", "in", numberSet);
            QFilter[] filters = new QFilter[]{orgFilter, bizPeriodFilter, endPeriodFilter, depreUseFilter, numberFilter, clearPeriodFilter};
            DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"number", "preresidualval", "decval", "originalval", "realcard", "accumdepre"}), (QFilter[])filters);
            Map<String, DynamicObject> numberToCard = finCards.stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v));
            Map<String, Object> finInfo = this.getAdjustData(orgId, depreUseId, periodId, realCardIdSet, numberSet);
            if (finInfo.size() == finCards.size()) {
                clearPredictResult = new HashMap(0);
            } else {
                DailyDepreImpl dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "fa_dispatch");
                DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
                clearPredictResult = dailyDepreImpl.clearPrePeriodDepe((Object)orgId, Long.valueOf(depreUseId), period, numberSet, realCardIdSet);
            }
            for (DynamicObject dispatchBill : dispatchBillList) {
                DynamicObjectCollection dispatchEntry = dispatchBill.getDynamicObjectCollection("dispatchentry");
                for (DynamicObject entry : dispatchEntry) {
                    Object finCardAccumDepreObj;
                    Map amountMap;
                    Object accumDepreObj;
                    String number = entry.getString(Fa.dot((String[])new String[]{"realcard", "number"}));
                    DynamicObject card = numberToCard.get(number);
                    if (card == null) continue;
                    BigDecimal originalVal = card.getBigDecimal("originalval");
                    entry.set("originalval", (Object)originalVal);
                    BigDecimal decVal = card.getBigDecimal("decval");
                    entry.set("decval", (Object)decVal);
                    BigDecimal preResidualVal = card.getBigDecimal("preresidualval");
                    entry.set("preresidualval", (Object)preResidualVal);
                    Object finAccum = finInfo.get(number);
                    BigDecimal totalDepre = finAccum != null ? (BigDecimal)finAccum : (clearPredictResult.get(number) != null ? ((accumDepreObj = (amountMap = (Map)clearPredictResult.get(number)).get("accumdepre")) == null ? BigDecimal.ZERO : (BigDecimal)accumDepreObj) : ((finCardAccumDepreObj = card.get("accumdepre")) == null ? BigDecimal.ZERO : (BigDecimal)finCardAccumDepreObj));
                    entry.set("totaldepre", (Object)totalDepre);
                    entry.set("networth", (Object)originalVal.subtract(totalDepre));
                    entry.set("netamount", (Object)originalVal.subtract(totalDepre).subtract(decVal));
                }
            }
        }
    }

    private Map<String, Object> getAdjustData(Long orgId, Long depreUseId, Long periodId, Set<Long> realCardIds, Set<String> numberSet) {
        DynamicObject[] finCards;
        HashMap<String, Object> finCardInfo = new HashMap<String, Object>(16);
        if (realCardIds.size() == 0) {
            return finCardInfo;
        }
        SqlBuilder sbSqlAdjust = new SqlBuilder();
        sbSqlAdjust.append("SELECT d.frealcardid realcardid  FROM t_fa_depreadjustbill m,t_fa_depreadjustentry d where m.fid = d.fid ", new Object[0]).append(" and m.forgid = ? ", new Object[]{orgId}).append(" and m.fdepreuseid = ? ", new Object[]{depreUseId}).append(" and m.fperiodid  = ? ", new Object[]{periodId}).append(" and m.fbillstatus  = ? ", new Object[]{"C"}).appendIn(" and d.frealcardid ", realCardIds.toArray());
        HashSet<Long> adjustRealSet = new HashSet<Long>(realCardIds.size());
        try (DataSet adjustDS = DB.queryDataSet((String)"resetBeforeSaveQueryAdjustRealIds", (DBRoute)FaConstants.faDBRoute, (SqlBuilder)sbSqlAdjust);){
            for (Row row : adjustDS) {
                adjustRealSet.add(row.getLong("realcardid"));
            }
        }
        if (adjustRealSet.size() == 0) {
            return finCardInfo;
        }
        QFilter[] finAjustFilters = new QFilter[]{new QFilter("realcard", "in", (Object)adjustRealSet.toArray()), new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("bizperiod", "=", (Object)periodId)};
        String selectFields = Fa.comma((String[])new String[]{"number", "accumdepre", "realcardmasterid"});
        for (DynamicObject finCard : finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectFields, (QFilter[])finAjustFilters)) {
            long realCardId = finCard.getLong("realcardmasterid");
            if (!adjustRealSet.contains(realCardId)) continue;
            finCardInfo.put(finCard.getString("number"), finCard.get("accumdepre"));
            numberSet.remove(finCard.getString("number"));
            realCardIds.remove(realCardId);
        }
        return finCardInfo;
    }
}

