/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class FaFinCardCommonValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, Long> masterId2SrcBillIdMap = new HashMap<Long, Long>(this.getDataEntities().length);
        HashMap<Long, Long> srcBillId2ClearPeriodIdMap = new HashMap<Long, Long>(this.getDataEntities().length);
        HashMap<Long, DynamicObject> peroid2PeriodDyMap = new HashMap<Long, DynamicObject>(this.getDataEntities().length);
        if (this.getOperateKey().equals("save") || this.getOperateKey().equals("submit")) {
            HashSet<Long> realMasterIds = new HashSet<Long>(this.getDataEntities().length);
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                DynamicObject finCard = dataEntity.getDataEntity();
                DynamicObject realCard = finCard.getDynamicObject("realcard");
                if (realCard == null) continue;
                realMasterIds.add(realCard.getLong("masterid"));
            }
            String selectFields = Fa.comma((String[])new String[]{"masterid", "srcbillid", "srcbillentityname"});
            QFilter[] filters = new QFilter[]{new QFilter("masterid", "in", realMasterIds), new QFilter("isbak", "=", (Object)Character.valueOf('0'))};
            DynamicObjectCollection realCardList = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
            for (DynamicObject realCard : realCardList) {
                String srcBillEneityName = realCard.getString("srcbillentityname");
                if (!srcBillEneityName.equals("fa_dispatch_in")) continue;
                masterId2SrcBillIdMap.put(realCard.getLong("masterid"), realCard.getLong("srcbillid"));
            }
            if (masterId2SrcBillIdMap.size() > 0) {
                String selectClearFields = Fa.comma((String[])new String[]{"srcbill", "clearsource", "clearperiod"});
                QFilter[] clearFilters = new QFilter[]{new QFilter("srcbill", "in", masterId2SrcBillIdMap.values())};
                Iterator clearBillList = QueryServiceHelper.query((String)"fa_clearbill", (String)selectClearFields, (QFilter[])clearFilters);
                Iterator iterator = clearBillList.iterator();
                while (iterator.hasNext()) {
                    DynamicObject clearBill = (DynamicObject)iterator.next();
                    srcBillId2ClearPeriodIdMap.put(clearBill.getLong("srcbill"), clearBill.getLong("clearperiod"));
                }
            }
            if (srcBillId2ClearPeriodIdMap.size() > 0) {
                Set periodIds = srcBillId2ClearPeriodIdMap.values().stream().collect(Collectors.toSet());
                DynamicObjectCollection periodList = PeriodUtil.getBdPeriods(periodIds);
                for (DynamicObject periodDy : periodList) {
                    peroid2PeriodDyMap.put(periodDy.getLong("id"), periodDy);
                }
            }
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Long clearPeriodId;
            Long srcBillId;
            DynamicObject realCard;
            DynamicObject finCard = dataEntity.getDataEntity();
            realCard = finCard.getDynamicObject("realcard");
            boolean fromDatabase = finCard.getDataEntityState().getFromDatabase();
            String entityName = finCard.getDataEntityType().getName();
            boolean isImport = false;
            if (finCard.containsProperty("isimport")) {
                isImport = finCard.getBoolean("isimport");
            }
            if (realCard == null) {
                if ("fa_initcard_fin".equals(entityName) && isImport && !fromDatabase) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\u3002", (String)"FaFinCardCommonValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean mergedCard = realCard.getBoolean("mergedcard");
            if (mergedCard) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247\u4e0d\u5141\u8bb8\u5355\u72ec\u64cd\u4f5c\u8d22\u52a1\u5361\u7247\u3002", (String)"FaFinCardCommonValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if ((srcBillId = (Long)masterId2SrcBillIdMap.get(realCard.getLong("masterid"))) == null || srcBillId == 0L || (clearPeriodId = (Long)srcBillId2ClearPeriodIdMap.get(srcBillId)) == null || clearPeriodId == 0L) continue;
            DynamicObject periodDy = (DynamicObject)peroid2PeriodDyMap.get(clearPeriodId);
            if (periodDy == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8c03\u62e8\u4ea7\u751f\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8c03\u62e8\u786e\u8ba4\u4f1a\u8ba1\u671f\u95f4id[%1$s]\u627e\u4e0d\u5230\u6570\u636e\u3002", (String)"FaFinCardCommonValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), clearPeriodId));
                continue;
            }
            Date beginDate = periodDy.getDate("begindate");
            Date endDate = periodDy.getDate("enddate");
            Date finaccountdate = finCard.getDate("finaccountdate");
            if (!finaccountdate.before(beginDate) && !finaccountdate.after(endDate)) continue;
            String beginDateStr = DateUtil.getShortDate().format(beginDate);
            String endDateStr = DateUtil.getShortDate().format(endDate);
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8c03\u62e8\u4ea7\u751f\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u5fc5\u987b\u5728\u8c03\u62e8\u5355\u786e\u8ba4\u671f\u95f4\u5185[%1$s\uff0c%2$s]\u3002", (String)"FaFinCardCommonValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), beginDateStr, endDateStr));
        }
    }
}

