/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.lease.LeaseFutureBizChecker;
import kd.fi.fa.business.operate.FaFinCardCmd;
import kd.fi.fa.business.operate.IFaOpHandler;
import kd.fi.fa.business.utils.FaRptMediateUtil;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaAbstractFinCardOp;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;
import kd.fi.fa.opplugin.validator.FaFinCardAssetBookValidator;

public class FaFinCardOperationPlugin
extends FaAbstractFinCardOp
implements IFaOpHandler {
    private static final String BARCODE = "barcode";
    private static final String OP_SUBMIT = "submit";
    private final Map<Object, DynamicObject> periodByDateMap = new HashMap<Object, DynamicObject>();

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("assetbook");
        fieldKeys.add("realcard");
        fieldKeys.add(Fa.dot((String[])new String[]{"realcard", "srcbillentityname"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"realcard", "srcbillid"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"realcard", "initialcard"}));
        fieldKeys.add("accumdepre");
        fieldKeys.add("originalamount");
        fieldKeys.add("originalval");
        fieldKeys.add("finaccountdate");
        fieldKeys.add("addupyeardepre");
        fieldKeys.add("period");
        fieldKeys.add("depreuse");
        fieldKeys.add("endperiod");
        fieldKeys.add("bizperiod");
        fieldKeys.add("clearperiod");
        fieldKeys.add("decval");
        fieldKeys.add("preresidualval");
        fieldKeys.add("preusingamount");
        fieldKeys.add("depredamount");
        fieldKeys.add("depremethod");
        fieldKeys.add(BARCODE);
        fieldKeys.add("billstatus");
        fieldKeys.add("networth");
        fieldKeys.add("netamount");
        fieldKeys.add("monthdepre");
        fieldKeys.add("org");
        fieldKeys.add("assetcat");
        fieldKeys.add("createtime");
        fieldKeys.add("creator");
        fieldKeys.add("number");
        fieldKeys.add("realcardmasterid");
        fieldKeys.add(Fa.dot((String[])new String[]{"realcard", "masterid"}));
        fieldKeys.add("basecurrency");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaFinCardAssetBookValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                List finCards = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
                FinCardValidator validator = FinCardValidator.getInstanceForSeparateCard(finCards);
                Map errInfo = new HashMap(0);
                if ("unaudit".equals(this.getOperateKey())) {
                    errInfo = validator.validateFinCardForUnAudit();
                } else if ("audit".equals(this.getOperateKey())) {
                    errInfo = validator.validateFinCardForAudit();
                }
                for (int i = 0; i < this.getDataEntities().length; ++i) {
                    List errMsg = (List)errInfo.get(i);
                    if (errMsg == null || errMsg.isEmpty()) continue;
                    ExtendedDataEntity dataEntity = this.getDataEntities()[i];
                    errMsg.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
                }
            }
        });
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("audit".equals(operationKey) || "unaudit".equals(operationKey)) {
            FunctionMutexHelperV2Utils.doFaOpWithWithBookPcChildLock((String)operationKey, (String)"fa_card_fin", (DynamicObject[])e.getDataEntities(), null, (IFaOpHandler)this);
        } else if (OP_SUBMIT.equals(operationKey)) {
            QFilter filter = new QFilter("enable", "=", (Object)"A");
            QFilter[] filters = new QFilter[]{filter};
            if (QueryServiceHelper.exists((String)"bas_imageconfig", (QFilter[])filters) && QueryServiceHelper.exists((String)"bos_imagestrategy", (QFilter[])filters)) {
                this.generateImageNumberBatchAsyn(e.getDataEntities());
            }
            this.setFinPeriodValue(e.getDataEntities());
        }
    }

    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        if (operationKey.equals("audit")) {
            FaFinCardOperationPlugin.audit(Arrays.asList(dataEntities));
        } else if (operationKey.equals("unaudit")) {
            FaFinCardOperationPlugin.unaudit(Arrays.asList(dataEntities));
        }
    }

    protected static boolean existLeaseChangeBill(DynamicObject finCard) {
        DynamicObject realCard = finCard.getDynamicObject("realcard");
        String srcBillEntityName = realCard.getString("srcbillentityname");
        if (!"fa_lease_contract".equals(srcBillEntityName) && !"fa_lease_contract_init".equals(srcBillEntityName)) {
            return false;
        }
        long srcBillId = realCard.getLong("srcbillid");
        return LeaseFutureBizChecker.existFutureLeaseChangeBill(null, (Object)srcBillId, null);
    }

    public static Map<Long, List<DynamicObject>> classify(DynamicObject[] finCards) {
        return Stream.of(finCards).collect(Collectors.groupingBy(v -> v.getLong("assetbook_id")));
    }

    public static void unaudit(List<DynamicObject> finCardObjs) {
        FaFinCardCmd cmd = new FaFinCardCmd(finCardObjs.stream().map(v -> (Long)v.get("id")).distinct().toArray());
        cmd.doUnaudit();
        FaRptMediateUtil.deleteByUnaudit((String)"fa_card_fin", (DynamicObject[])finCardObjs.toArray(new DynamicObject[0]));
    }

    public static void audit(List<DynamicObject> finCardObjs) {
        Object[] pks = finCardObjs.stream().map(v -> (Long)v.get("id")).distinct().toArray();
        FaFinCardCmd cmd = new FaFinCardCmd(pks);
        cmd.doAudit();
        FaRptMediateUtil.generateByAssetCardAudit((Object[])pks);
    }

    private void generateImageNumberBatchAsyn(DynamicObject[] dataEntities) {
        ArrayList<ImageInfo> imageInfoList = new ArrayList<ImageInfo>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String pkId = dataEntity.getPkValue().toString();
            Date createTime = dataEntity.getDate("createtime");
            String creator = String.valueOf(dataEntity.getLong(Fa.id((String)"creator")));
            String orgId = String.valueOf(dataEntity.getLong(Fa.id((String)"org")));
            String bizPeriodIdStr = String.valueOf(dataEntity.getLong(Fa.id((String)"bizperiod")));
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setCreatetime(createTime);
            imageInfo.setCreator(creator);
            imageInfo.setOrgId(orgId);
            imageInfo.setBilltype(dataEntity.getDynamicObjectType().getName());
            imageInfo.setBillNo(pkId + "-" + bizPeriodIdStr);
            imageInfo.setBillId(pkId);
            imageInfoList.add(imageInfo);
        }
        ImageServiceHelper.createImageInfoBatchAsyn(imageInfoList);
    }

    private Boolean checkRealCardStatus(DynamicObject finCard) {
        DynamicObject realCard = finCard.getDynamicObject("realcard");
        realCard = FaRealCardDaoFactory.getInstance().queryOne("masterid,bizstatus", realCard.getPkValue());
        String bizstatus = realCard.getString("bizstatus");
        return !"DRAWBACKING".equals(bizstatus) && !"TRANSFERING".equals(bizstatus);
    }

    private void setFinPeriodValue(DynamicObject[] dataEntities) {
        for (DynamicObject finCard : dataEntities) {
            DynamicObject assetBook = finCard.getDynamicObject("assetbook");
            String periodByDateMapKey = finCard.getDate("finaccountdate").toString() + assetBook.getLong("periodtype_Id");
            DynamicObject pd = null;
            if (this.periodByDateMap.get(periodByDateMapKey) != null) {
                pd = this.periodByDateMap.get(periodByDateMapKey);
            } else {
                pd = PeriodUtil.getPeriodFullObjByDate((Date)finCard.getDate("finaccountdate"), (long)assetBook.getLong("periodtype_Id"));
                this.periodByDateMap.put(periodByDateMapKey, pd);
            }
            if (finCard.getBoolean("realCard.initialcard")) {
                finCard.set("bizperiod_id", (Object)0L);
                finCard.set("period_id", (Object)0L);
                continue;
            }
            if (pd == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u542f\u7528\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4", (String)"FaFinCardOperationPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            long periodId = pd.getLong("id");
            finCard.set("period_id", (Object)periodId);
            finCard.set("bizperiod_id", (Object)periodId);
            finCard.set("bizperiod", (Object)pd);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

