/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaFinCardUtil;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaAbstractFinCardOp;
import kd.fi.fa.opplugin.LeasePushCardValidator;
import kd.fi.fa.opplugin.validator.FaFinCardAssetBookValidator;
import kd.fi.fa.utils.FaAssetCardUtils;

public class FaFinCardSaveOp
extends FaAbstractFinCardOp {
    private static final String getFMT() {
        return ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u5fc5\u987b\u665a\u4e8e\u542f\u7528\u65e5\u671f(%2$s)", (String)"FaFinCardSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(Fa.join((String)".", (String[])new String[]{"realcard", "sourceflag"}));
        fieldKeys.add(Fa.join((String)".", (String[])new String[]{"realcard", "masterid"}));
        fieldKeys.add("org");
        fieldKeys.add("depreuse");
        fieldKeys.add("number");
        fieldKeys.add("decval");
        fieldKeys.add("assetcat");
        fieldKeys.add("assetbook");
        fieldKeys.add("bizperiod");
        fieldKeys.add("period");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                List finCards = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
                FinCardValidator validator = FinCardValidator.getInstanceForSeparateCard(finCards);
                OperateOption option = this.getOption();
                if (option.containsVariable("ignore_validate_initial_fincard") && "true".equals(option.getVariableValue("ignore_validate_initial_fincard"))) {
                    validator.setValidateSave(Boolean.FALSE.booleanValue());
                }
                Map errInfo = validator.validateFinCardForSave();
                for (int i = 0; i < this.getDataEntities().length; ++i) {
                    List errMsg = (List)errInfo.get(i);
                    if (errMsg == null || errMsg.isEmpty()) continue;
                    ExtendedDataEntity dataEntity = this.getDataEntities()[i];
                    errMsg.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
                }
            }
        });
        e.addValidator((AbstractValidator)new LeasePushCardValidator());
        e.addValidator((AbstractValidator)new FaFinCardAssetBookValidator());
    }

    private void supplementRealCardMasterId(DynamicObject[] finCards, DynamicObjectCollection realCards) {
        HashMap<String, DynamicObject> realCardsMap = new HashMap<String, DynamicObject>(realCards.size());
        for (DynamicObject realCard : realCards) {
            realCardsMap.put(realCard.getString("org") + "-" + realCard.getString("number"), realCard);
        }
        for (DynamicObject finCard : finCards) {
            DynamicObject realCard;
            Long finRealCardMasterId = finCard.getLong("realcardmasterid");
            if (finRealCardMasterId != null && finRealCardMasterId != 0L || (realCard = (DynamicObject)realCardsMap.get(finCard.getString("org_id") + "-" + finCard.getString("number"))) == null) continue;
            Long realCardMasterId = realCard.getLong("masterid");
            finCard.set("realcardmasterid", (Object)realCardMasterId);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orgIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<String> numbersFinSet = new HashSet<String>(dataEntities.length);
        HashSet<Long> depreuseIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<Boolean> isImportSet = new HashSet<Boolean>(dataEntities.length);
        isImportSet.add(true);
        for (DynamicObject fincard : dataEntities) {
            DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(fincard);
            FinCardCalc.setNetWorth((IObjWrapper)objWrapper);
            FinCardCalc.setNetAmount((IObjWrapper)objWrapper);
            orgIdSet.add(fincard.getLong("org_id"));
            numbersFinSet.add(fincard.getString("number"));
            depreuseIdSet.add(fincard.getLong("depreuse_id"));
            isImportSet.add(fincard.getBoolean("isimport"));
            boolean curPeriodSplitEnable = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)fincard.getLong("org_id"));
            if (!curPeriodSplitEnable || FaFinCardUtil.isInitFinCard((long)fincard.getLong(Fa.id((String)"period")))) continue;
            fincard.set("originaldata", (Object)true);
            fincard.set("isneeddepre", (Object)false);
        }
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)String.join((CharSequence)",", "id", "org", "headusedept", "assetcat", "billno", "number", "sourceflag", "realaccountdate", "billstatus", "masterid"), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdSet), new QFilter("number", "in", numbersFinSet)});
        this.supplementRealCardMasterId(dataEntities, realCards);
        HashSet<String> numbersSet = new HashSet<String>();
        HashMap<String, DynamicObject> realCardsMap = new HashMap<String, DynamicObject>(realCards.size());
        for (DynamicObject realCard : realCards) {
            realCardsMap.put(realCard.getString("org") + "-" + realCard.getString("number"), realCard);
            numbersSet.add(realCard.getString("number"));
            if (realCard.getString("sourceflag").equals("IMPORT")) continue;
            return;
        }
        if (isImportSet.size() > 1) {
            return;
        }
        if (realCardsMap.size() < 1 || numbersSet.size() < 1 || depreuseIdSet.size() < 1) {
            return;
        }
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"number", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdSet), new QFilter("depreuse", "in", depreuseIdSet), new QFilter("number", "in", numbersSet)});
        Set existNumbers = finCards.stream().map(t -> t.getString("number")).collect(Collectors.toSet());
        for (DynamicObject finCard : dataEntities) {
            String realCardStates;
            DynamicObject realCard = (DynamicObject)realCardsMap.get(finCard.getString("org_id") + "-" + finCard.getString("number"));
            if (realCard == null || !(realCardStates = realCard.getString("billstatus")).equals(BillStatus.C.name()) || existNumbers.contains(finCard.getString("number"))) continue;
            Date realcardDate = realCard.getDate("realaccountdate");
            Date finDate = finCard.getDate("finaccountdate");
            if (finDate.before(realcardDate)) continue;
            long realCardId = realCard.getLong("id");
            finCard.set("realcard_id", (Object)realCardId);
            finCard.set("billno", (Object)realCard.getString("billno"));
            finCard.set("assetcat_id", (Object)realCard.getLong("assetcat"));
            finCard.set("depredept_id", (Object)realCard.getLong("headusedept"));
            DynamicObjectCollection billHeads = finCard.getDynamicObjectCollection("billhead_lk");
            DynamicObject billHead = billHeads.addNew();
            Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
            billHead.set("seq", (Object)1);
            billHead.set("billhead_lk_stableid", (Object)realCardTableId);
            billHead.set("billhead_lk_sbillid", (Object)realCardId);
            billHead.set("billhead_lk_sid", (Object)realCardId);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        FaAssetCardUtils.updateAssetCardFinEntry4FinSave(e.getDataEntities());
    }
}

