/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.DepredAmountValidator;
import kd.fi.fa.opplugin.FaFinCardValidator;

public class FaFinCardSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("assetbook");
        fieldKeys.add("org");
        fieldKeys.add("finaccountdate");
        fieldKeys.add("realcard");
        fieldKeys.add("originalamount");
        fieldKeys.add("barcode");
        fieldKeys.add("depremethod");
        fieldKeys.add("depredamount");
        fieldKeys.add("originalval");
        fieldKeys.add("preusingamount");
        fieldKeys.add("networth");
        fieldKeys.add("netamount");
        fieldKeys.add("period");
        fieldKeys.add("clearPeriod");
        fieldKeys.add("decVal");
        fieldKeys.add("preResidualVal");
        fieldKeys.add("assetbook");
        fieldKeys.add("assetcat");
        fieldKeys.add("monthorigvalchg");
        fieldKeys.add("yearorigvalchg");
        fieldKeys.add("accumdepre");
        fieldKeys.add("bizperiod");
        fieldKeys.add("workloadunit");
        fieldKeys.add("realcardmasterid");
        fieldKeys.add("isneeddepre");
        fieldKeys.add("originaldata");
        fieldKeys.add("endperiod");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaFinCardValidator());
        e.addValidator((AbstractValidator)new DepredAmountValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject bill : dataEntities = e.getDataEntities()) {
            boolean curPeriodSplitEnable;
            BigDecimal originalval = bill.getBigDecimal("originalval");
            bill.set("monthorigvalchg", (Object)originalval);
            bill.set("yearorigvalchg", (Object)originalval);
            DynamicObject realCard = bill.getDynamicObject("realcard");
            Long finRealCardMasterId = bill.getLong("realcardmasterid");
            if (realCard != null && (finRealCardMasterId == null || finRealCardMasterId == 0L)) {
                bill.set("realcardmasterid", (Object)realCard.getLong("masterid"));
            }
            if (curPeriodSplitEnable = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)bill.getLong(Fa.id((String)"org")))) {
                bill.set("isneeddepre", (Object)false);
                bill.set("originaldata", (Object)true);
            }
            this.handleAutoCalFields(bill);
        }
    }

    private void handleAutoCalFields(DynamicObject finCard) {
        BigDecimal netAmount;
        IObjWrapper wrapper = this.buildWrapperObj(finCard);
        BigDecimal netWorth = finCard.getBigDecimal("networth");
        if (BigDecimal.ZERO.compareTo(netWorth) == 0) {
            FinCardCalc.setNetWorth((IObjWrapper)wrapper);
        }
        if (BigDecimal.ZERO.compareTo(netAmount = finCard.getBigDecimal("netamount")) == 0) {
            FinCardCalc.setNetAmount((IObjWrapper)wrapper);
        }
    }

    private IObjWrapper buildWrapperObj(DynamicObject finCard) {
        return new DynamicObjectWrapper(finCard);
    }
}

