/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaAbstractFinCardOp;
import kd.fi.fa.opplugin.FaFinCardOperationPlugin;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;
import kd.fi.fa.utils.FaAssetCardUtils;

public class FaInitFinDeleteOpPlugin
extends FaAbstractFinCardOp {
    private static final String queryAllFin2Fields = Fa.comma((String[])new String[]{"fid", "billstatus"});

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operationName = this.getValidateContext().getOperateName();
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    boolean exists;
                    Optional checkResult;
                    DynamicObject initFinCard = dataEntity.getDataEntity();
                    DynamicObject assetBook = initFinCard.getDynamicObject("assetbook");
                    if ("C".equals(assetBook.getString("status"))) {
                        this.addMessage(dataEntity, operationName, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FaInitFinDeleteOpPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    DynamicObject real = initFinCard.getDynamicObject("realcard");
                    Long realCardid = real.getLong("id");
                    String selectFields = Fa.dot((String[])new String[]{"clrapplybill_entry", "realcard"});
                    QFilter[] filters = new QFilter[]{new QFilter("assetunit", "=", real.get("assetunit.id")), new QFilter("billstatus", "!=", (Object)BillStatus.C)};
                    DynamicObjectCollection clearApplyBills = QueryServiceHelper.query((String)"fa_clearapplybill", (String)selectFields, (QFilter[])filters);
                    for (DynamicObject clearApplyBill : clearApplyBills) {
                        if (realCardid.longValue() != clearApplyBill.getLong("clrapplybill_entry.realcard")) continue;
                        String errorMsg = ResManager.loadKDString((String)"\u5361\u7247\u5728\u6e05\u7406\u7533\u8bf7\u5355\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c", (String)"FaInitFinDeleteOpPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                        this.addMessage(dataEntity, errorMsg, ErrorLevel.Error);
                        break;
                    }
                    if ((checkResult = FaInitFinDeleteOpPlugin.this.checkFutureBiz(initFinCard)).isPresent()) {
                        String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff1a%s", (String)"FaInitFinDeleteOpPlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get());
                        this.addMessage(dataEntity, operationName, msg, ErrorLevel.Error);
                    }
                    DynamicObject realCard = initFinCard.getDynamicObject("realcard");
                    String sourceFlag = realCard.getString("sourceflag");
                    if (SourceFlagEnum.INITLEASECONTRACT.name().equalsIgnoreCase(sourceFlag) && (exists = QueryServiceHelper.exists((String)"fa_asset_transfer", (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"assettransferentry", "realcard"}), "=", realCard.getPkValue())}))) {
                        String msg = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff1a\u8d44\u4ea7\u79fb\u4ea4\u5355: %s\u3002", (String)"FaInitFinDeleteOpPlugin_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), realCard.getString("billno"));
                        this.addMessage(dataEntity, operationName, msg, ErrorLevel.Error);
                    }
                    if (!FaFinCardOperationPlugin.existLeaseChangeBill(initFinCard)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5361\u7247\u7684\u4e0a\u6e38\u79df\u8d41\u5408\u540c\u5b58\u5728\u79df\u8d41\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FaInitFinDeleteOpPlugin_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
                List finCards = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
                FinCardValidator validator = FinCardValidator.getInstanceForSeparateCard(finCards);
                Map errInfo = validator.validateInitFinCardForDelete();
                for (int i = 0; i < this.getDataEntities().length; ++i) {
                    List errMsg = (List)errInfo.get(i);
                    if (errMsg == null || errMsg.isEmpty()) continue;
                    ExtendedDataEntity dataEntity = this.getDataEntities()[i];
                    errMsg.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
                }
            }
        });
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }

    private Optional<String> checkFutureBiz(DynamicObject finCard) {
        DynamicObject realCard = finCard.getDynamicObject("realcard");
        realCard = FaRealCardDaoFactory.getInstance().queryOne("masterid", realCard.getPkValue());
        DynamicObject[] realCards = FaRealCardDaoFactory.getInstance().query("id", new QFilter("masterid", "=", (Object)realCard.getLong("masterid")));
        Set realCardPkSet = Arrays.stream(realCards).map(v -> (Long)v.get("id")).collect(Collectors.toSet());
        Object orgId = finCard.get("org.id");
        FutureBizChecker futureBizChecker = new FutureBizChecker(null, orgId, realCardPkSet, null, BusyTypeDetailEnum.REAL_FIN_CHG);
        futureBizChecker.setFromFin(true);
        return futureBizChecker.checkWhenun();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("realcard");
        e.getFieldKeys().add(Fa.dot((String[])new String[]{"realcard", "srcbillentityname"}));
        e.getFieldKeys().add(Fa.dot((String[])new String[]{"realcard", "srcbillid"}));
        e.getFieldKeys().add("depreuse");
        e.getFieldKeys().add("assetbook");
        e.getFieldKeys().add("finaccountdate");
        e.getFieldKeys().add("period");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("depreuse");
        e.getFieldKeys().add("endperiod");
        e.getFieldKeys().add("id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        FaAssetCardUtils.deleteAssetCardFinEntry4FinDelete(dataEntities);
        ArrayList<Object> pks = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            pks.add(dataEntity.getPkValue());
        }
        IFaFinCardDao dao = FaFinCardDaoFactory.getInstance();
        String selector = Fa.join((Object[])new String[]{"id", "realcard", "period", Fa.dot((String[])new String[]{"realcard", "masterid"}), "bizperiod", "depreuse", "org", Fa.dot((String[])new String[]{"assetbook", "startperiod"})}, (String)",");
        DynamicObject[] finCards = dao.query(selector, new QFilter("id", "in", pks));
        this.deleteNonInitFinCard(e, finCards);
        new DepreSplitSum().deductForFinCard(finCards, false);
        HashSet<Object> realCardPKs = new HashSet<Object>(finCards.length);
        for (DynamicObject finCard : finCards) {
            Object realCardPK = finCard.getDynamicObject("realcard").getPkValue();
            realCardPKs.add(realCardPK);
        }
        if (!realCardPKs.isEmpty()) {
            DynamicObject[] realCardEntity;
            for (DynamicObject dyn : realCardEntity = FaRealCardDaoFactory.getInstance().query("bizstatus", new QFilter("id", "in", realCardPKs))) {
                dyn.set("bizstatus", (Object)BizStatusEnum.ADD);
            }
            SaveServiceHelper.save((DynamicObject[])realCardEntity);
        }
        this.deleteBotp(pks.toArray(new Object[0]));
    }

    private void deleteBotp(Object[] finCardIdArr) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(finCardIdArr.length);
        for (Object finCardId : finCardIdArr) {
            params.add(new Object[]{finCardId});
        }
        try (TXHandle tx = TX.requiresNew();){
            DBRoute routeFa = DBRoute.of((String)"fa");
            String deleteFinTc = "delete from t_fa_card_fin_tc where ftid = ?;";
            try {
                DB.executeBatch((DBRoute)routeFa, (String)deleteFinTc, params);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        tx = TX.requiresNew();
        var4_5 = null;
        try {
            DBRoute routeSys = DBRoute.of((String)"sys");
            String deleteSysBotp = "delete from t_botp_billtracker where ftbillid = ?;";
            try {
                DB.executeBatch((DBRoute)routeSys, (String)deleteSysBotp, params);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void deleteNonInitFinCard(BeginOperationTransactionArgs e, DynamicObject[] finCards) {
        IFaFinCardDao dao = FaFinCardDaoFactory.getInstance();
        String selector = Fa.join((Object[])new String[]{"id", "realcard", Fa.dot((String[])new String[]{"realcard", "masterid"}), "bizperiod", "depreuse", "org", "period"}, (String)",");
        HashMap<Long, HashSet<Long>> depreUseId2RealCardIds = new HashMap<Long, HashSet<Long>>(2);
        for (DynamicObject finCard : finCards) {
            long depreUse = finCard.getLong(Fa.id((String)"depreuse"));
            HashSet<Long> realCardIds = (HashSet<Long>)depreUseId2RealCardIds.get(depreUse);
            if (realCardIds == null) {
                realCardIds = new HashSet<Long>(8);
                depreUseId2RealCardIds.put(depreUse, realCardIds);
            }
            realCardIds.add(finCard.getLong(Fa.dot((String[])new String[]{"realcard", "masterid"})));
        }
        for (Map.Entry entry : depreUseId2RealCardIds.entrySet()) {
            DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])new QFilter[]{new QFilter("depreuse", "=", entry.getKey()), new QFilter("realcard", "in", entry.getValue())});
        }
        HashMap real_depreuses = new HashMap();
        for (DynamicObject finCard : finCards) {
            Long bizPeriodId = finCard.getLong("bizperiod.id");
            if (bizPeriodId != 0L) continue;
            Object realCardPK = finCard.getDynamicObject("realcard").getPkValue();
            if (!real_depreuses.containsKey(realCardPK)) {
                real_depreuses.put(realCardPK, new HashSet());
            }
            Set depreuseIdLst = (Set)real_depreuses.get(realCardPK);
            depreuseIdLst.add(finCard.getDynamicObject("depreuse").getPkValue());
        }
        DynamicObject[] dynamicObjectArray = dao.query(selector, new QFilter("realcard", "in", real_depreuses.keySet()).toArray());
        HashSet<Object> notInitFinCardPKs = new HashSet<Object>();
        for (DynamicObject finCard : dynamicObjectArray) {
            Long bizPeriodId;
            Set toHandleDepreUseSet = (Set)real_depreuses.get(finCard.getLong("realcard.id"));
            if (!toHandleDepreUseSet.contains(finCard.getLong("depreuse.id")) || (bizPeriodId = Long.valueOf(finCard.getLong("bizperiod.id"))) == 0L) continue;
            notInitFinCardPKs.add(finCard.getPkValue());
        }
        if (!notInitFinCardPKs.isEmpty()) {
            dao.delete(new QFilter("id", "in", notInitFinCardPKs));
        }
    }
}

