/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.opplugin.FaRealCheckClearApplyValidator;
import kd.fi.fa.opplugin.validator.FaProductLineValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaIntialRealCardOperationPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(FaIntialRealCardOperationPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String oerateName = e.getOperationKey();
        if ("save".equals(oerateName)) {
            DynamicObject[] daynamicObjects;
            for (DynamicObject dataEntity : daynamicObjects = e.getDataEntities()) {
                dataEntity.set("billstatus", (Object)BillStatus.C.toString());
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String operateName = this.getOperateKey();
                HashMap<String, Boolean> org2HasEndInitBook = new HashMap<String, Boolean>();
                ArrayList<Long> realCardIdList = new ArrayList<Long>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject realCard = dataEntity.getDataEntity();
                    boolean fromDatabase = realCard.getDataEntityState().getFromDatabase();
                    if (!fromDatabase) continue;
                    long realCardId = realCard.getLong("id");
                    realCardIdList.add(realCardId);
                }
                QFilter finFilter = new QFilter("realcard", "in", realCardIdList);
                DynamicObjectCollection finCardList = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard", (QFilter[])finFilter.toArray());
                Set hasFinCardIdSet = finCardList.stream().map(v -> v.getLong("realcard")).collect(Collectors.toSet());
                block9: for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    DynamicObject realCardObj = extendedDataEntity.getDataEntity();
                    switch (operateName) {
                        case "save": {
                            String orgIdStr = realCardObj.getString("org_id");
                            Long orgId = realCardObj.getLong("org_id");
                            long realCardId = realCardObj.getLong("id");
                            Boolean hasEndInitBook = (Boolean)org2HasEndInitBook.get(orgIdStr);
                            if (hasEndInitBook == null) {
                                QFilter filterOrg = new QFilter("org.id", "=", (Object)orgId);
                                QFilter filterEnable = new QFilter("status", "=", (Object)"C");
                                boolean isHasEndInitBook = QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])new QFilter[]{filterOrg, filterEnable});
                                org2HasEndInitBook.put(orgIdStr, isHasEndInitBook);
                                hasEndInitBook = isHasEndInitBook;
                            }
                            if (hasEndInitBook.booleanValue()) {
                                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5bf9\u5e94\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"FaIntialRealCardOperationPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            }
                            if (!hasFinCardIdSet.contains(realCardId)) continue block9;
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8d22\u52a1\u5361\u7247\uff0c\u4e0d\u53ef\u4ee5\u4fee\u6539\u3002", (String)"FaIntialRealCardOperationPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            continue block9;
                        }
                        case "delete": {
                            if (!FaOpUtils.checkFinCard(realCardObj)) continue block9;
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u3002", (String)"FaIntialRealCardOperationPlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }
        });
        e.addValidator((AbstractValidator)new FaRealCheckClearApplyValidator(this.billEntityType));
        e.addValidator((AbstractValidator)new FaProductLineValidator());
    }

    public java.util.Date stripTime(java.util.Date d) {
        return Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(d));
    }
}

