/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FaInventoryDifferSavePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObjectCollection dynamicObjectCollection;
                    DynamicObject dobj = dataEntity.getDataEntity();
                    boolean fromDatabase = dobj.getDataEntityState().getFromDatabase();
                    if (!fromDatabase && FaInventoryDifferSavePlugin.this.validateExistRecord(dobj)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76d8\u70b9\u8bb0\u5f55\u5df2\u751f\u6210\u8fc7\u76d8\u70b9\u5dee\u5f02\u3002", (String)"FaInventoryDifferSavePlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if ((dynamicObjectCollection = dobj.getDynamicObjectCollection("fa_invdiffererentry")).size() == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76d8\u70b9\u5dee\u5f02\u5206\u5f55\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaInventoryDifferSavePlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    } else {
                        ArrayList recordsIds = new ArrayList();
                        dynamicObjectCollection.forEach(r -> recordsIds.add(r.getLong("inventoryrecord.id")));
                        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                        qFilters.add(new QFilter("id", "in", recordsIds).and("billstate", "!=", (Object)"C"));
                        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fa_inventory_record", (String)"number", (QFilter[])qFilters.toArray(new QFilter[0]));
                        List numbers = collection.stream().map(obj -> obj.getString("number")).collect(Collectors.toList());
                        if (!numbers.isEmpty()) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u8d44\u4ea7\u7f16\u7801\u4e3a%s\u7684\u76d8\u70b9\u8bb0\u5f55\u672a\u5ba1\u6838\u3002", (String)"FaInventoryDifferSavePlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[]{numbers}));
                        }
                    }
                    for (DynamicObject entry : dynamicObjectCollection) {
                        DynamicObject changemode = entry.getDynamicObject("changemode");
                        if (null == changemode || changemode.getBoolean("isleaf")) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76d8\u70b9\u5dee\u5f02\u5206\u5f55\u884c\u589e\u51cf\u65b9\u5f0f\u4e0d\u80fd\u9009\u62e9\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"FaInventoryDifferSavePlugin_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public boolean validateExistRecord(DynamicObject dobj) {
        DynamicObjectCollection dyns = dobj.getDynamicObjectCollection("fa_invdiffererentry");
        ArrayList recordsIds = new ArrayList();
        dyns.forEach(r -> recordsIds.add(r.getLong("inventoryrecord.id")));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("fa_invdiffererentry.inventoryrecord", "in", recordsIds));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fa_invdiffer", (String)"fa_invdiffererentry", (QFilter[])qFilters.toArray(new QFilter[0]));
        return dynamicObject != null && dynamicObject.getDynamicObjectCollection("fa_invdiffererentry").size() > 0;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills.length == 0) {
            return;
        }
        for (DynamicObject dyn : bills) {
            dyn.set("assetqty", (Object)1);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        for (DynamicObject dyn : e.getDataEntities()) {
            boolean fromDatabase = dyn.getDataEntityState().getFromDatabase();
            if (fromDatabase) continue;
            DynamicObjectCollection dynamicObjects = dyn.getDynamicObjectCollection("fa_invdiffererentry");
            HashSet<Long> recordsIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                recordsIds.add(dynamicObject.getLong("inventoryrecord.id"));
            }
            DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])recordsIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_inventory_record"));
            Arrays.stream(loads).forEach(r -> r.set("inventorystate", (Object)"C"));
            SaveServiceHelper.update((DynamicObject[])loads);
        }
    }
}

