/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.fa.business.utils.MigrateServiceUtils;
import kd.fi.fa.common.util.DateUtil;

public class FaMigrateDateValidator
extends AbstractValidator {
    public static final Map<String, String> entity2FieldMap = new HashMap<String, String>(8, 1.0f);
    public static final Map<String, Map<String, String>> entity2EntryFieldMap;
    public static final Map<String, String> entity2FieldMapChg;
    public static final Map<String, String> entity2FieldMapClr;

    public void validate() {
        if (this.dataEntities.length == 0) {
            return;
        }
        DynamicObject firstEntity = this.dataEntities[0].getDataEntity();
        IDataEntityType entityType = firstEntity.getDataEntityType();
        String entityName = entityType.getName();
        if (!entity2FieldMap.containsKey(entityName)) {
            return;
        }
        String operateKey = super.getOperateKey();
        if (!operateKey.equals("submit") && !operateKey.equals("unaudit")) {
            return;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(this.dataEntities.length, 1.0f);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            orgIdSet.add(entity.getLong("org.id"));
        }
        Map orgId2DateMap = MigrateServiceUtils.getMigratePeriodDate(orgIdSet);
        block1: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            Long orgId = entity.getLong("org.id");
            Map migrateOrgData = (Map)orgId2DateMap.get(orgId);
            if (migrateOrgData == null) continue;
            Date migrateEndDate = (Date)migrateOrgData.get("enddate");
            if (entityName.equals("fa_depreadjustbill")) {
                Long billPeriodId = entity.getLong("period.id");
                Long migratePeriodid = (Long)migrateOrgData.get("periodId");
                if (billPeriodId <= migratePeriodid) {
                    String migrateEndDateStr = DateUtil.getShortDate().format(migrateEndDate);
                    String errStr = String.format(ResManager.loadKDString((String)"\u6298\u65e7\u671f\u95f4\u53ea\u80fd\u5728\u5f02\u6784\u8fc1\u79fb\u65e5\u671f%s\u5bf9\u5e94\u671f\u95f4\u4e4b\u540e\u3002", (String)"FaMigrateDateValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), migrateEndDateStr);
                    this.addMessage(dataEntity, errStr, ErrorLevel.Error);
                }
            } else {
                Date changeDate = entity.getDate(entity2FieldMap.get(entityName));
                if (changeDate.getTime() <= migrateEndDate.getTime()) {
                    String migrateEndDateStr = DateUtil.getShortDate().format(migrateEndDate);
                    String errStr = String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u53ea\u80fd\u5728\u5f02\u6784\u8fc1\u79fb\u65e5\u671f\u5bf9\u5e94\u671f\u95f4\u6700\u540e\u4e00\u5929%s\u4e4b\u540e\u3002", (String)"FaMigrateDateValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), migrateEndDateStr);
                    this.addMessage(dataEntity, errStr, ErrorLevel.Error);
                }
            }
            if (!operateKey.equals("submit") || !entity2EntryFieldMap.containsKey(entityName)) continue;
            Map<String, String> entity2FieldMap2 = entity2EntryFieldMap.get(entityName);
            DynamicObjectCollection clearEntryCol = entity.getDynamicObjectCollection(entity2FieldMap2.get("entry"));
            for (DynamicObject clearEntry : clearEntryCol) {
                Date bizDate = clearEntry.getDate(entity2FieldMap2.get("bizdate"));
                if (bizDate.getTime() > migrateEndDate.getTime()) continue;
                String migrateEndDateStr = DateUtil.getShortDate().format(migrateEndDate);
                String errStr = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u53ea\u80fd\u5728\u5f02\u6784\u8fc1\u79fb\u65e5\u671f\u5bf9\u5e94\u671f\u95f4\u6700\u540e\u4e00\u5929%s\u4e4b\u540e\u3002", (String)"FaMigrateDateValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), migrateEndDateStr);
                this.addMessage(dataEntity, errStr, ErrorLevel.Error);
                continue block1;
            }
        }
    }

    static {
        entity2FieldMap.put("fa_change_dept", "changedate");
        entity2FieldMap.put("fa_clearbill", "cleardate");
        entity2FieldMap.put("fa_asset_devalue", "businessdate");
        entity2FieldMap.put("fa_assetsplitbill", "splitdate");
        entity2FieldMap.put("fa_mergebill", "mergedate");
        entity2FieldMap.put("fa_restartrealbill", "restartdate");
        entity2FieldMap.put("fa_depreadjustbill", "period");
        entity2EntryFieldMap = new HashMap<String, Map<String, String>>(2, 1.0f);
        entity2FieldMapChg = new HashMap<String, String>(2, 1.0f);
        entity2FieldMapClr = new HashMap<String, String>(2, 1.0f);
        entity2FieldMapChg.put("entry", "fieldentry");
        entity2FieldMapChg.put("bizdate", "bizdate1");
        entity2FieldMapClr.put("entry", "detail_entry");
        entity2FieldMapClr.put("bizdate", "bizdate");
        entity2EntryFieldMap.put("fa_change_dept", entity2FieldMapChg);
        entity2EntryFieldMap.put("fa_clearbill", entity2FieldMapClr);
    }
}

