/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.opplugin.FaPurchaseCompleteBuildUtils;
import kd.fi.fa.opplugin.FaUseDeptCheckValidator;
import kd.fi.fa.opplugin.validator.FaPurchaseBillMaterialAndProductLineValidator;

public class FaPurcharseBillOperationPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeies = e.getFieldKeys();
        fieldKeies.add("sourcebillsign");
        fieldKeies.add("assetsentry");
        fieldKeies.add("totalamount");
        fieldKeies.add("notaxamount");
        fieldKeies.add("taxamount");
        fieldKeies.add("buildway");
        fieldKeies.add("ismainline");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                String operateKey = this.getOperateKey();
                if ("unaudit".equals(this.getOperateKey())) {
                    for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
                        DynamicObjectCollection assetsentry = (DynamicObjectCollection)extendedDataEntity.getValue("assetsentry");
                        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"fa_purchasebill", (Long[])new Long[]{(Long)extendedDataEntity.getValue("id")});
                        HashSet cardIds = (HashSet)targetBills.get("fa_card_real");
                        boolean isExist = QueryServiceHelper.exists((String)"fa_card_real", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)cardIds)});
                        if (!isExist) continue;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u91c7\u8d2d\u8f6c\u56fa\u5355\u5df2\u7ecf\u751f\u6210\u5b9e\u7269\u5361\u7247\uff0c\u53cd\u5ba1\u6838\u5931\u8d25", (String)"FaPurcharseBillOperationPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                }
                if ("audit".equals(operateKey) || "save".equals(operateKey)) {
                    for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
                        DynamicObject purchaseBill = extendedDataEntity.getDataEntity();
                        String msg = FaPurchaseCompleteBuildUtils.checkAndMainLine(purchaseBill);
                        if (msg == null) continue;
                        this.addErrorMessage(extendedDataEntity, msg);
                    }
                }
            }
        });
        e.addValidator((AbstractValidator)new FaUseDeptCheckValidator());
        e.addValidator((AbstractValidator)new FaPurchaseBillMaterialAndProductLineValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dyn : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection dynColl = dyn.getDynamicObjectCollection("assetsentry");
            dynColl.forEach(action -> action.set("totalamount", (Object)action.getBigDecimal("notaxamount").add(action.getBigDecimal("taxamount"))));
        }
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey)) {
            for (DynamicObject dyn : dataEntities) {
                FaPurchaseCompleteBuildUtils.setDefaultMainLine(dyn);
            }
        }
    }
}

