/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.FaRecalculate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.utils.FaOpUtils;

public class FaRecalculateAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizdate");
        fieldKeys.add("org");
        fieldKeys.add("recalculateentry");
        fieldKeys.add("depreuse");
        fieldKeys.add("bforivalue");
        fieldKeys.add("bfnetworth");
        fieldKeys.add("bfnetamount");
        fieldKeys.add("bfpreresidualval");
        fieldKeys.add("bfaccumdepre");
        fieldKeys.add("bfaddupyeardepre");
        fieldKeys.add("bfyearorigvalchg");
        fieldKeys.add("bfmonthorigvalchg");
        fieldKeys.add("bfmonthdepre");
        fieldKeys.add("monthdepre");
        fieldKeys.add("recalculateentry.realcard");
        fieldKeys.add("recalculateentry.fincard");
        fieldKeys.add("recalculateentry.orivalue");
        fieldKeys.add("recalculateentry.networth");
        fieldKeys.add("recalculateentry.netamount");
        fieldKeys.add("recalculateentry.preresidualval");
        fieldKeys.add("recalculateentry.accumdepre");
        fieldKeys.add("recalculateentry.addupyeardepre");
        fieldKeys.add("recalculateentry.yearorigvalchg");
        fieldKeys.add("recalculateentry.monthorigvalchg");
        fieldKeys.add("recalculateentry.bfdepredamount");
        fieldKeys.add("recalculateentry.depredamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    FaOpUtils.checkDoOperable(dataEntity.getDataEntity(), "recalculateentry", "realcard.masterid", "fa_recalculate");
                }
            }
        });
    }

    public static String[] getSelects() {
        ArrayList<String> selects = new ArrayList<String>();
        selects.add("realcard");
        selects.add("networth");
        selects.add("netamount");
        selects.add("decval");
        selects.add("accumdepre");
        selects.add("monthorigvalchg");
        selects.add("yearorigvalchg");
        selects.add("addidepreamount");
        selects.add("depredamount");
        selects.add("isneeddepre");
        selects.add("originalval");
        selects.add("monthdepre");
        selects.add("depredamount");
        return selects.toArray(new String[0]);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String key = e.getOperationKey();
        IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
        DynamicObject[] workloadEntries = e.getDataEntities();
        if (key.equals("audit")) {
            for (DynamicObject workloadBill : workloadEntries) {
                List<Long> realMasterids = FaRecalculateAuditOp.getAllEntityRealMasterid(workloadBill.getDynamicObjectCollection("recalculateentry"), "realcard");
                List<Long> realIds = FaRecalculateAuditOp.getIdByMasterid(realMasterids);
                IBizSetCardDataHandler handle = card -> FaRecalculateAuditOp.updateCard(card, workloadBill, true);
                long depreuseId = workloadBill.getLong("depreuse_id");
                long periodId = PeriodUtil.getBizPeriodPK((Object)workloadBill.getLong("org_id"), (Date)workloadBill.getDate("bizdate"), (Long)depreuseId);
                Map mainRealID2FinID = fCardDao.copyFinCards(periodId, depreuseId, realIds.toArray(), handle, FaRecalculateAuditOp.getSelects(), null);
                Set<Long> keyset = mainRealID2FinID.keySet();
                Map<Long, Long> masterid2id = FaRecalculateAuditOp.getMasteridById(keyset);
                for (DynamicObject entity : workloadBill.getDynamicObjectCollection("recalculateentry")) {
                    Map depreuse2Fin;
                    long finid;
                    Long entMaster = entity.getDynamicObject("realcard").getLong("masterid");
                    if (!masterid2id.containsKey(entMaster) || (finid = ((Long)(depreuse2Fin = (Map)mainRealID2FinID.get(masterid2id.get(entMaster))).get(workloadBill.getLong("depreuse_id"))).longValue()) == 0L) continue;
                    entity.set("fincard_id", (Object)finid);
                }
            }
        } else {
            for (DynamicObject workloadBill : workloadEntries) {
                List<Long> realmasterids = FaRecalculateAuditOp.getAllEntityRealMasterid(workloadBill.getDynamicObjectCollection("recalculateentry"), "realcard");
                List<Long> deleteRealIds = FaRecalculateAuditOp.getIdByMasterid(realmasterids);
                IBizSetCardDataHandler deleteHandle = card -> FaRecalculateAuditOp.updateCard(card, workloadBill, false);
                long depreuseId = workloadBill.getLong("depreuse_id");
                long periodId = PeriodUtil.getBizPeriodPK((Object)workloadBill.getLong("org_id"), (Date)workloadBill.getDate("bizdate"), (Long)depreuseId);
                fCardDao.restoreCard(periodId, depreuseId, deleteRealIds.toArray(), deleteHandle, FaRecalculateAuditOp.getSelects());
            }
        }
    }

    public static List<Long> getAllEntityRealMasterid(DynamicObjectCollection entity, String realName) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject entityRow : entity) {
            DynamicObject realcard = entityRow.getDynamicObject(realName);
            if (realcard == null) continue;
            ids.add(realcard.getLong("id"));
        }
        return ids;
    }

    public static List<Long> getIdByMasterid(List<Long> masterids) {
        QFilter masterF = new QFilter("masterid", "in", masterids);
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])new QFilter[]{masterF});
        return FaRecalculateAuditOp.getIdByCol(ids, "id");
    }

    public static List<Long> getIdByCol(DynamicObjectCollection ids, String idname) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject id : ids) {
            idList.add(id.getLong(idname));
        }
        return idList;
    }

    public static void updateCard(DynamicObject card, DynamicObject recalculateentry, boolean isAudit) {
        DynamicObject depreuse = recalculateentry.getDynamicObject("depreuse");
        DynamicObjectCollection workLoadEntities = recalculateentry.getDynamicObjectCollection("recalculateentry");
        long cardMasterid = card.getDynamicObject("realcard").getLong("masterid");
        for (DynamicObject workloadEntity : workLoadEntities) {
            BigDecimal depredmount;
            BigDecimal monthDepre;
            BigDecimal monthValChg;
            BigDecimal yearValChg;
            BigDecimal yearDepre;
            BigDecimal accumDepre;
            BigDecimal prepesidual;
            BigDecimal netamount;
            BigDecimal newworth;
            BigDecimal orivalue;
            if (workloadEntity.getDynamicObject("realcard").getLong("masterid") != cardMasterid || depreuse.getLong("id") != card.getLong("depreuse_id")) continue;
            if (isAudit) {
                orivalue = workloadEntity.getBigDecimal("orivalue");
                newworth = workloadEntity.getBigDecimal("networth");
                netamount = workloadEntity.getBigDecimal("netamount");
                prepesidual = workloadEntity.getBigDecimal("preresidualval");
                accumDepre = workloadEntity.getBigDecimal("accumdepre");
                yearDepre = workloadEntity.getBigDecimal("addupyeardepre");
                yearValChg = workloadEntity.getBigDecimal("yearorigvalchg");
                monthValChg = workloadEntity.getBigDecimal("monthorigvalchg");
                monthDepre = workloadEntity.getBigDecimal("monthdepre");
                depredmount = workloadEntity.getBigDecimal("depredamount");
                card.set("originalval", (Object)orivalue);
                card.set("networth", (Object)newworth);
                card.set("netamount", (Object)netamount);
                card.set("preresidualval", (Object)prepesidual);
                card.set("accumdepre", (Object)accumDepre);
                card.set("addupyeardepre", (Object)yearDepre);
                card.set("yearorigvalchg", (Object)yearValChg);
                card.set("monthorigvalchg", (Object)monthValChg);
                card.set("monthdepre", (Object)monthDepre);
                card.set("depredamount", (Object)depredmount);
            } else {
                orivalue = workloadEntity.getBigDecimal("bforivalue");
                newworth = workloadEntity.getBigDecimal("bfnetworth");
                netamount = workloadEntity.getBigDecimal("bfnetamount");
                prepesidual = workloadEntity.getBigDecimal("bfpreresidualval");
                accumDepre = workloadEntity.getBigDecimal("bfaccumdepre");
                yearDepre = workloadEntity.getBigDecimal("bfaddupyeardepre");
                yearValChg = workloadEntity.getBigDecimal("bfyearorigvalchg");
                monthValChg = workloadEntity.getBigDecimal("bfmonthorigvalchg");
                monthDepre = workloadEntity.getBigDecimal("bfmonthdepre");
                depredmount = workloadEntity.getBigDecimal("bfdepredamount");
                card.set("originalval", (Object)orivalue);
                card.set("networth", (Object)newworth);
                card.set("netamount", (Object)netamount);
                card.set("preresidualval", (Object)prepesidual);
                card.set("accumdepre", (Object)accumDepre);
                card.set("addupyeardepre", (Object)yearDepre);
                card.set("yearorigvalchg", (Object)yearValChg);
                card.set("monthorigvalchg", (Object)monthValChg);
                card.set("monthdepre", (Object)monthDepre);
                card.set("depredamount", (Object)depredmount);
            }
            card.set("isneeddepre", (Object)true);
        }
    }

    public static Map<Long, Long> getMasteridById(Set<Long> ids) {
        DynamicObjectCollection id2masterid = QueryServiceHelper.query((String)"fa_card_real", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<Long, Long> id2master = new HashMap<Long, Long>();
        for (DynamicObject card : id2masterid) {
            id2master.put(card.getLong("masterid"), card.getLong("id"));
        }
        return id2master;
    }
}

