/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaRepairAccDepreAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("depreuse");
        e.getFieldKeys().add("bizperiod");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("yeardepreadjust");
        e.getFieldKeys().add("finid");
        e.getFieldKeys().add("bfyeardepre");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Map<Long, ExtendedDataEntity> map = Arrays.stream(this.getDataEntities()).collect(Collectors.toMap(v -> v.getDataEntity().getLong("finid"), v -> v));
                DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"id", "addupyeardepre"}), (QFilter[])new QFilter[]{new QFilter("id", "in", map.keySet())});
                for (DynamicObject finCard : finCards) {
                    DynamicObject repair;
                    BigDecimal bfYearDepre;
                    BigDecimal realYearDepre = finCard.getBigDecimal("addupyeardepre");
                    ExtendedDataEntity dataEntity = map.get(finCard.getLong("id"));
                    if (dataEntity == null || (bfYearDepre = (repair = dataEntity.getDataEntity()).getBigDecimal("bfyeardepre")).compareTo(realYearDepre) == 0) continue;
                    String depreUseName = repair.getString(Fa.dot((String[])new String[]{"depreuse", "name"}));
                    String number = repair.getString("number");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e3a\uff1a%1$s\uff0c\u8d44\u4ea7\u7f16\u7801\u4e3a\uff1a%2$s\u7684\u5361\u7247\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u53d1\u751f\u53d8\u5316\u3002", (String)"FaRepairAccDepreAuditOpPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), depreUseName, number));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(bills.length);
        Set numbers = Arrays.stream(bills).map(v -> v.getString("number")).collect(Collectors.toSet());
        for (DynamicObject bill : bills) {
            map.put(bill.getLong(Fa.id((String)"org")) + "-" + bill.getLong(Fa.id((String)"depreuse")) + "-" + bill.getString("number"), bill);
        }
        DynamicObjectCollection fincards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"id", "bizperiod", Fa.dot((String[])new String[]{"bizperiod", "periodyear"}), "number", "depreuse", "addupyeardepre", "org"}), (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(fincards.size());
        for (DynamicObject fincard : fincards) {
            int repairYear;
            String key = fincard.getLong("org") + "-" + fincard.getLong("depreuse") + "-" + fincard.getString("number");
            DynamicObject bill = (DynamicObject)map.get(key);
            if (bill == null) continue;
            long bizPeriodId = fincard.getLong("bizperiod");
            int bizYear = fincard.getInt(Fa.dot((String[])new String[]{"bizperiod", "periodyear"}));
            if (bizYear != (repairYear = bill.getInt(Fa.dot((String[])new String[]{"bizperiod", "periodyear"}))) || bizPeriodId < bill.getLong(Fa.id((String)"bizperiod"))) continue;
            BigDecimal addUpYearDepre = fincard.getBigDecimal("addupyeardepre");
            Object[] param = new Object[]{addUpYearDepre.subtract(bill.getBigDecimal("yeardepreadjust")), fincard.getLong("id")};
            paramList.add(param);
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set faddupyeardepre = ? where fid = ?", paramList);
        }
    }
}

