/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class InvdifferOperationPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity invdifferBill : this.getDataEntities()) {
                    String billStatus = invdifferBill.getDataEntity().getString("billstatus");
                    if ("D".equals(billStatus) || "E".equals(billStatus)) continue;
                    this.addErrorMessage(invdifferBill, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5904\u7406\u5b8c\u6210\u6216\u90e8\u5206\u5904\u7406\u624d\u80fd\u53d6\u6d88\u5904\u7406\u3002", (String)"InvdifferOperationPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperateOption operateOption;
        int[] selectRows = (int[])SerializationUtils.deSerializeFromBase64((String)this.getOption().getVariableValue("selectRows"));
        if (e.getDataEntities().length == 0) {
            return;
        }
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d6\u6d88\u5904\u7406\u7684\u76d8\u70b9\u8bb0\u5f55\u3002", (String)"InvdifferOperationPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        String sourceEntityNumber = this.billEntityType.getName();
        HashSet<Object> billIds = new HashSet<Object>(16);
        HashSet entryIds = new HashSet(16);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            billIds.add(dataEntity.getPkValue());
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("fa_invdiffererentry");
            Arrays.stream(selectRows).forEach(index -> {
                DynamicObject entryDiffer = (DynamicObject)collection.get(index);
                if (entryDiffer != null && entryDiffer.getString("handlestatus").equals("C")) {
                    entryIds.add(entryDiffer.getPkValue());
                }
            });
        }
        if (entryIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u201c\u53d6\u6d88\u5904\u7406\u201d\u7684\u76d8\u70b9\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvdifferOperationPlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        HashMap<String, HashSet> targetBillIds = new HashMap<String, HashSet>(16);
        List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)sourceEntityNumber, (String)"fa_invdiffererentry", (Long[])billIds.toArray(new Long[0]), (Long[])entryIds.toArray(new Long[0]), null);
        for (BFRow bfRow : bfRows) {
            BFRowId bfRowId = bfRow.getId();
            ConvertDataService reader = new ConvertDataService();
            TableDefine tableDefine = reader.loadTableDefine(bfRowId.getMainTableId());
            targetBillIds.computeIfAbsent(tableDefine.getEntityNumber(), v -> new HashSet(bfRows.size())).add(bfRowId.getBillId());
        }
        String realCard_EntityNumber = "fa_card_real";
        String clearBill_EntityNumber = "fa_clearbill";
        DynamicObject realCard = new DynamicObject();
        HashSet realCard_Ids = new HashSet(16);
        if (targetBillIds.containsKey(realCard_EntityNumber)) {
            realCard_Ids = (HashSet)targetBillIds.get(realCard_EntityNumber);
            QFilter qFilter = new QFilter("id", "in", (Object)realCard_Ids);
            qFilter.and("billstatus", "!=", (Object)"A");
            List realBillNoList = QueryServiceHelper.query((String)realCard_EntityNumber, (String)"billno", (QFilter[])qFilter.toArray()).stream().map(v -> v.getString("billno")).collect(Collectors.toList());
            if (!realBillNoList.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u5b9e\u7269\u5361\u7247\u201c%s\u201d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"InvdifferOperationPlugin_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), realBillNoList));
            }
        }
        HashSet clearBill_Ids = new HashSet(16);
        if (targetBillIds.containsKey(clearBill_EntityNumber)) {
            clearBill_Ids = (HashSet)targetBillIds.get(clearBill_EntityNumber);
            QFilter qFilter = new QFilter("id", "in", (Object)clearBill_Ids);
            qFilter.and("billstatus", "!=", (Object)"A");
            List clearBillNoList = QueryServiceHelper.query((String)clearBill_EntityNumber, (String)"billno", (QFilter[])qFilter.toArray()).stream().map(v -> v.getString("billno")).collect(Collectors.toList());
            if (!clearBillNoList.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u6e05\u7406\u5355\u201c%s\u201d\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"InvdifferOperationPlugin_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), clearBillNoList));
            }
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        Object[] billIdArr = new Object[dataEntities.length];
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(10);
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection invdiffererentry = bill.getDynamicObjectCollection("fa_invdiffererentry");
            List entries = invdiffererentry.stream().filter(v -> entryIds.contains(v.getPkValue())).collect(Collectors.toList());
            for (DynamicObject entry : entries) {
                entry.set("handlestatus", (Object)"A");
            }
            long count = invdiffererentry.stream().filter(invdiffer -> invdiffer.getString("handlestatus").equals("A")).count();
            if (count != (long)invdiffererentry.size()) {
                bill.set("billstatus", (Object)"E");
            } else {
                bill.set("billstatus", (Object)"C");
            }
            saveData.add(bill);
        }
        if (billIdArr.length > 0) {
            OperationServiceHelper.executeOperate((String)"save", (String)"fa_invdiffer", (DynamicObject[])saveData.toArray(new DynamicObject[0]), null);
        }
        if (realCard_Ids.isEmpty() && clearBill_Ids.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0b\u6e38\u6570\u636e\uff0c\u8bf7\u5148\u505a\u76d8\u76c8\u76d8\u4e8f\u5904\u7406\u3002", (String)"InvdifferOperationPlugin_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (!clearBill_Ids.isEmpty()) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue("deleteClearBillByUnAudit", "true");
            String errorClearDetail = "";
            OperationResult clearDelResult = OperationServiceHelper.executeOperate((String)"delete", (String)clearBill_EntityNumber, (Object[])clearBill_Ids.toArray(), (OperateOption)operateOption);
            if (clearDelResult.getSuccessPkIds().size() < clearBill_Ids.size()) {
                for (IOperateInfo errInfo : clearDelResult.getAllErrorOrValidateInfo()) {
                    errorClearDetail = errInfo.getMessage();
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5220\u9664\u4e0b\u6e38\u6e05\u7406\u5355\u5931\u8d25\u3002%s", (String)"InvdifferOperationPlugin_6", (String)"fi-fa-opplugin", (Object[])new Object[0]), errorClearDetail));
            }
        }
        if (!realCard_Ids.isEmpty()) {
            operateOption = OperateOption.create();
            String errorRealDetail = "";
            operateOption.setVariableValue("deleteRealCardByInvdiffer", "true");
            OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)realCard_EntityNumber, (Object[])realCard_Ids.toArray(), (OperateOption)operateOption);
            if (delResult.getSuccessPkIds().size() < realCard_Ids.size()) {
                for (IOperateInfo errInfo : delResult.getAllErrorOrValidateInfo()) {
                    errorRealDetail = errInfo.getMessage();
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5220\u9664\u4e0b\u6e38\u5b9e\u7269\u5361\u7247\u5355\u636e\u5931\u8d25\u3002%s", (String)"InvdifferOperationPlugin_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), errorRealDetail));
            }
        }
    }
}

