/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.MonthClose;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.periodclose.PeriodCloseFacade;
import kd.fi.fa.business.utils.MigrateServiceUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class MonthCloseCenterBackOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(MonthCloseCenterBackOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("depreuse");
        fieldKeys.add("curperiod");
        fieldKeys.add("startperiod");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        long typeID = 0L;
        HashSet<Long> ordIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject fakeAssetBook : dataEntities) {
            long orgID = (Long)fakeAssetBook.getDynamicObject("org").getPkValue();
            ordIds.add(orgID);
            typeID = fakeAssetBook.get("depreuse") instanceof DynamicObject ? (Long)fakeAssetBook.getDynamicObject("depreuse").getPkValue() : Long.parseLong(fakeAssetBook.get("depreuse").toString());
        }
        QFilter org = new QFilter("org", "in", ordIds);
        QFilter type = new QFilter("depreuse", "=", (Object)typeID);
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"org,id", (QFilter[])new QFilter[]{org, type});
        Object[] ids = assetBooks.stream().map(b -> b.getLong("id")).distinct().toArray();
        DynamicObject[] assetBookArray = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_assetbook"));
        Map<Long, DynamicObject> orgAssetBookMap = Arrays.stream(assetBookArray).collect(Collectors.toMap(b -> b.getLong("org.id"), b -> b));
        Map migrateData = MigrateServiceUtils.getMigratePeriodDate(ordIds);
        for (DynamicObject fakeAssetBook : dataEntities) {
            try {
                Long migratePeriodid;
                OperateErrorInfo errorinfo;
                long orgID = (Long)fakeAssetBook.getDynamicObject("org").getPkValue();
                long selectP = fakeAssetBook.get("curperiod") instanceof DynamicObject ? fakeAssetBook.getLong("curperiod.id") : fakeAssetBook.getLong("curperiod");
                DynamicObject assetBook = orgAssetBookMap.get(orgID);
                long bookID = assetBook.getLong("id");
                long cp = assetBook.getLong(Fa.id((String)"startperiod"));
                boolean isCanAntiClose = true;
                if (selectP < cp) {
                    this.operationResult.setSuccess(false);
                    errorinfo = new OperateErrorInfo();
                    errorinfo.setMessage(ResManager.loadKDString((String)"\u9009\u62e9\u671f\u95f4\u5c0f\u4e8e\u542f\u7528\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"MonthCloseCenterBackOpPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    errorinfo.setErrorLevel(ErrorLevel.FatalError.name());
                    this.operationResult.addErrorInfo(errorinfo);
                    isCanAntiClose = false;
                } else if (selectP > assetBook.getLong(Fa.id((String)"curperiod"))) {
                    this.operationResult.setSuccess(false);
                    errorinfo = new OperateErrorInfo();
                    errorinfo.setMessage(ResManager.loadKDString((String)"\u9009\u62e9\u671f\u95f4\u5927\u4e8e\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"MonthCloseCenterBackOpPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    errorinfo.setErrorLevel(ErrorLevel.FatalError.name());
                    this.operationResult.addErrorInfo(errorinfo);
                    isCanAntiClose = false;
                }
                Map migrateOrgData = (Map)migrateData.get(orgID);
                if (migrateOrgData != null && selectP <= (migratePeriodid = (Long)migrateOrgData.get("periodId"))) {
                    Date migrateEndDate = (Date)migrateOrgData.get("enddate");
                    String migrateEndDateStr = DateUtil.getShortDate().format(migrateEndDate);
                    this.operationResult.setSuccess(false);
                    OperateErrorInfo errorinfo2 = new OperateErrorInfo();
                    String errorStr = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u53cd\u7ed3\u8d26\u5230\u5f02\u6784\u8fc1\u79fb\u65e5\u671f%1$s\u5bf9\u5e94\u671f\u95f4\u4ee5\u53ca\u4e4b\u524d\u7684\u671f\u95f4\u3002", (String)"MonthCloseCenterBackOpPlugin_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), migrateEndDateStr);
                    errorinfo2.setMessage(errorStr);
                    errorinfo2.setErrorLevel(ErrorLevel.FatalError.name());
                    this.operationResult.addErrorInfo(errorinfo2);
                    isCanAntiClose = false;
                }
                while (isCanAntiClose) {
                    try {
                        if (assetBook.getLong("startperiod.id") == assetBook.getLong("curperiod.id")) {
                            this.handleFail(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e3a\u542f\u7528\u671f\u95f4", (String)"MonthCloseCenterBackOpPlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            isCanAntiClose = false;
                            continue;
                        }
                        new PeriodCloseFacade().periodUnClose(Long.valueOf(bookID));
                        this.operationResult.setSuccess(true);
                        DynamicObject period = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"curperiod", (QFilter[])new QFilter("id", "=", (Object)bookID).toArray());
                        long curp = cp = period.getLong("curperiod");
                        isCanAntiClose = selectP < curp;
                    }
                    catch (Exception ex) {
                        this.handleFail(ex.getMessage());
                        isCanAntiClose = false;
                    }
                }
            }
            catch (Exception ex) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setMessage(ex.getMessage());
                errorInfo.setErrorLevel(ErrorLevel.Error.name());
                this.operationResult.addErrorInfo(errorInfo);
                throw new KDBizException(ex.toString());
            }
        }
    }

    DynamicObject getFakeAssetBook(BeginOperationTransactionArgs e) {
        DynamicObject fakeAssetBook = e.getDataEntities()[0];
        return fakeAssetBook;
    }

    private void handleFail(String errMsg) {
        this.operationResult.setSuccess(false);
        OperateErrorInfo errorinfo = new OperateErrorInfo();
        errorinfo.setMessage(errMsg);
        errorinfo.setErrorLevel(ErrorLevel.FatalError.name());
        this.operationResult.addErrorInfo(errorinfo);
    }
}

