/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SplitBillDataWriteBackPlugin
extends AbstractOperationServicePlugIn {
    private static final String AL_GO = "kd.fi.fa.opplugin.SplitBillDataWriteBackPlugin";
    private static final Log log = LogFactory.getLog(SplitBillDataWriteBackPlugin.class);
    private static final DBRoute FA_DB_ROUTE = DBRoute.of((String)"fa");

    public void initialize(InitOperationArgs e) {
        this.updateVoucherFlag();
        this.updateOtherInfo();
    }

    public void updateOtherInfo() {
        DataSet baseDataSet = this.getBaseDataSet();
        DataSet assetSplitEntryDepreUseIdDS = this.getAssetSplitEntryDepreUseIdDataSet();
        this.updateAssetSplitEntry(assetSplitEntryDepreUseIdDS);
        DataSet finish = baseDataSet.leftJoin(assetSplitEntryDepreUseIdDS).on("fentryid", "fentryid").select(baseDataSet.getRowMeta().getFieldNames(), new String[]{"fdepreuseid"}).finish();
        this.updateAssetSplitEntryD(finish);
    }

    private void updateAssetSplitEntryD(DataSet dataSet) {
        log.info("\u5f00\u59cb\u66f4\u65b0\u62c6\u5206\u5355\u62c6\u5206\u540e\u7684\u6570\u636e");
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Row row : dataSet) {
            int fseq = row.getInteger("fseq") == null ? 0 : row.getInteger("fseq");
            String fissourcecard = row.getString("fissourcecard") == null ? "0" : row.getString("fissourcecard");
            long fassetcatid = row.getLong("fassetcatid") == null ? 0L : row.getLong("fassetcatid");
            String fbarcode = row.getString("fbarcode") == null ? " " : row.getString("fbarcode");
            Date frealaccountdate = row.getDate("frealaccountdate");
            long foriginmethodid = row.getLong("foriginmethodid") == null ? 0L : row.getLong("foriginmethodid");
            long fsupplierid = row.getLong("fsupplierid") == null ? 0L : row.getLong("fsupplierid");
            long fstoreplaceid = row.getLong("fstoreplaceid") == null ? 0L : row.getLong("fstoreplaceid");
            long fusestatusid = row.getLong("fusestatusid") == null ? 0L : row.getLong("fusestatusid");
            long fheadusepersonid = row.getLong("fheadusepersonid") == null ? 0L : row.getLong("fheadusepersonid");
            long fheadusedeptid = row.getLong("fheadusedeptid") == null ? 0L : row.getLong("fheadusedeptid");
            long fcostcentrerid = row.getLong("fcostcentrerid") == null ? 0L : row.getLong("fcostcentrerid");
            long fproductlineid = row.getLong("fproductlineid") == null ? 0L : row.getLong("fproductlineid");
            String fisfacility = row.getString("fisfacility") == null ? "0" : row.getString("fisfacility");
            String fisstoraged = row.getString("fisstoraged") == null ? "0" : row.getString("fisstoraged");
            long fdepreuseid = row.getLong("fdepreuseid") == null ? 0L : row.getLong("fdepreuseid");
            Date ffinaccountdate = row.getDate("ffinaccountdate");
            BigDecimal fpreusingamount = row.getBigDecimal("fpreusingamount") == null ? BigDecimal.ZERO : row.getBigDecimal("fpreusingamount");
            BigDecimal fmonthaccumdeprechg = row.getBigDecimal("fmonthaccumdeprechg") == null ? BigDecimal.ZERO : row.getBigDecimal("fmonthaccumdeprechg");
            long fdetailid = row.getLong("fdetailid") == null ? 0L : row.getLong("fdetailid");
            updateParams.add(new Object[]{fseq, fissourcecard, fassetcatid, fbarcode, frealaccountdate, foriginmethodid, fsupplierid, fstoreplaceid, fusestatusid, fheadusepersonid, fheadusedeptid, fcostcentrerid, fproductlineid, fisfacility, fisstoraged, fdepreuseid, ffinaccountdate, fpreusingamount, fmonthaccumdeprechg, fdetailid});
        }
        if (updateParams.isEmpty()) {
            log.info("\u66f4\u65b0\u62c6\u5206\u5355\u62c6\u5206\u540e\u7684\u6570\u636e\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a0 \u6761");
            return;
        }
        String updateSql = "UPDATE t_fa_assetsplitentry_d SET findex = ?, fissourcecard = ?, fassetcatid = ?, fbarcode = ?, frealaccountdate = ?, foriginmethodid = ?, fsupplierid = ?, fstoreplaceid = ?, fusestatusid = ?, fheadusepersonid = ?, fheadusedeptid = ?, fcostcentrerid = ?, fproductlineid = ?, fisfacility = ?, fisstoraged = ?, fdepreuseid = ?, ffinaccountdate = ?, fpreusingamount = ?, fmonthaccumdeprechg = ? WHERE fdetailid = ? ";
        DB.executeBatch((DBRoute)FA_DB_ROUTE, (String)updateSql, updateParams);
        log.info("\u66f4\u65b0\u62c6\u5206\u5355\u62c6\u5206\u540e\u7684\u6570\u636e\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a" + updateParams.size() + " \u6761");
    }

    private DataSet getAssetSplitEntryDepreUseIdDataSet() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT", new Object[0]);
        sqlBuilder.append("a.fentryid,", new Object[0]);
        sqlBuilder.append("b.fdepreuseid", new Object[0]);
        sqlBuilder.append("FROM t_fa_assetsplitentry a", new Object[0]);
        sqlBuilder.append("LEFT JOIN t_fa_card_fin b", new Object[0]);
        sqlBuilder.append("ON a.ffincardid = b.fid", new Object[0]);
        sqlBuilder.append("WHERE a.ffincardid IS NOT NULL AND b.fdepreuseid IS NOT NULL", new Object[0]);
        return DB.queryDataSet((String)AL_GO, (DBRoute)FA_DB_ROUTE, (SqlBuilder)sqlBuilder);
    }

    private void updateAssetSplitEntry(DataSet assetSplitEntryDepreUseIdDS) {
        log.info("\u5f00\u59cb\u66f4\u65b0\u62c6\u5206\u524d\u5206\u5f55\u7684\u6298\u65e7\u7528\u9014");
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Row row : assetSplitEntryDepreUseIdDS.copy()) {
            Long fdepreuseid = row.getLong("fdepreuseid");
            Long fentryid = row.getLong("fentryid");
            updateParams.add(new Object[]{fdepreuseid, fentryid});
        }
        if (updateParams.isEmpty()) {
            log.info("\u66f4\u65b0\u62c6\u5206\u524d\u5206\u5f55\u7684\u6298\u65e7\u7528\u9014\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a0 \u6761");
            return;
        }
        String updateSql = "UPDATE t_fa_assetsplitentry SET fdepreuseid = ? WHERE fentryid = ? ";
        DB.executeBatch((DBRoute)FA_DB_ROUTE, (String)updateSql, updateParams);
        log.info("\u66f4\u65b0\u62c6\u5206\u524d\u5206\u5f55\u7684\u6298\u65e7\u7528\u9014\u7ed3\u675f, \u4e00\u5171\u66f4\u65b0\u6570\u636e\uff1a" + updateParams.size() + " \u6761");
    }

    private DataSet getBaseDataSet() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT", new Object[0]);
        sqlBuilder.append("c.fdetailid,", new Object[0]);
        sqlBuilder.append("c.fentryid,", new Object[0]);
        sqlBuilder.append("c.fseq,", new Object[0]);
        sqlBuilder.append("CASE WHEN c.fseq = 1 THEN 1 ELSE 0 END fissourcecard,", new Object[0]);
        sqlBuilder.append("CASE WHEN c.fseq = 1 then c.faccumdepre - b.faccumdepre ELSE c.faccumdepre END fmonthaccumdeprechg,", new Object[0]);
        sqlBuilder.append("d.fassetcatid,", new Object[0]);
        sqlBuilder.append("e.fbarcode,", new Object[0]);
        sqlBuilder.append("e.frealaccountdate,", new Object[0]);
        sqlBuilder.append("e.foriginmethodid,", new Object[0]);
        sqlBuilder.append("e.fsupplierid,", new Object[0]);
        sqlBuilder.append("e.fstoreplaceid,", new Object[0]);
        sqlBuilder.append("e.fusestatusid,", new Object[0]);
        sqlBuilder.append("e.fheadusepersonid,", new Object[0]);
        sqlBuilder.append("e.fheadusedeptid,", new Object[0]);
        sqlBuilder.append("e.fcostcentrerid,", new Object[0]);
        sqlBuilder.append("e.fproductlineid,", new Object[0]);
        sqlBuilder.append("e.fisfacility,", new Object[0]);
        sqlBuilder.append("e.fisstoraged,", new Object[0]);
        sqlBuilder.append("c.ffinaccountdate,", new Object[0]);
        sqlBuilder.append("c.fpreusingamount", new Object[0]);
        sqlBuilder.append("FROM t_fa_assetsplitbill a", new Object[0]);
        sqlBuilder.append("LEFT JOIN t_fa_assetsplitentry b", new Object[0]);
        sqlBuilder.append("ON a.fid = b.fid", new Object[0]);
        sqlBuilder.append("LEFT JOIN t_fa_assetsplitentry_d c", new Object[0]);
        sqlBuilder.append("ON b.fentryid = c.fentryid", new Object[0]);
        sqlBuilder.append("LEFT JOIN t_fa_card_fin d", new Object[0]);
        sqlBuilder.append("ON b.ffincardid = d.fid", new Object[0]);
        sqlBuilder.append("LEFT JOIN t_fa_card_real e", new Object[0]);
        sqlBuilder.append("ON b.frealcardid = e.fid", new Object[0]);
        sqlBuilder.append("WHERE a.fbillstatus IN ('A','B','C');", new Object[0]);
        return DB.queryDataSet((String)AL_GO, (DBRoute)FA_DB_ROUTE, (SqlBuilder)sqlBuilder);
    }

    private void updateVoucherFlag() {
        log.info("\u5f00\u59cb\u66f4\u65b0\u8bb0\u8d26\u6807\u8bc6");
        SqlBuilder updateSqlBuilder = new SqlBuilder();
        updateSqlBuilder.append("UPDATE t_fa_assetsplitbill", new Object[0]);
        updateSqlBuilder.append("SET fvoucherflag = 'A'", new Object[0]);
        updateSqlBuilder.append("WHERE fvoucherflag IS NULL", new Object[0]);
        updateSqlBuilder.append("OR fvoucherflag = ' ' OR fvoucherflag = ''", new Object[0]);
        DB.execute((DBRoute)FA_DB_ROUTE, (SqlBuilder)updateSqlBuilder);
        log.info("\u66f4\u65b0\u8bb0\u8d26\u6807\u8bc6\u7ed3\u675f");
    }
}

