/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.fi.fa.business.dao.impl.AssetCardToFinCardHandler;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaFinCardOperationPlugin;
import kd.fi.fa.opplugin.assetcard.AbstractAssetCardValidator;
import kd.fi.fa.opplugin.assetcard.AbstractAssetFinCardValidator;
import kd.fi.fa.utils.FaAssetCardUtils;

public abstract class AbstractAssetCardOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AbstractAssetCardOp.class);
    private static final String OPERATE_SAVE = "save";
    private static final String OPERATE_SUBMIT = "submit";
    private static final String OPERATE_DELETE = "delete";
    private static final DBRoute DB_ROUTE_FA = DBRoute.of((String)"fa");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("assetunit");
        fieldKeys.add("mergedcard");
        fieldKeys.add(Fa.dot((String[])new String[]{"finentry", "fincard"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"finentry", "seq"}));
        fieldKeys.add(Fa.dot((String[])new String[]{"finentry", "originalfincard"}));
        fieldKeys.add("productline");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        OperateOption option = this.getOption();
        option.setVariableValue("assetCardOperate", "1");
        AssetCardToFinCardHandler handler = new AssetCardToFinCardHandler(option);
        handler.handle(e.getDataEntities());
        e.addValidator((AbstractValidator)new AbstractAssetCardValidator());
        AbstractAssetFinCardValidator finCardValidator = new AbstractAssetFinCardValidator(this.getFinValidateFunc());
        e.addValidator((AbstractValidator)finCardValidator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] realCards = e.getDataEntities();
        DynamicObject[] finCards = this.getFinCards(e);
        this.handleFinCards(realCards, finCards);
        String operationType = (String)this.operateMeta.get("type");
        if (OPERATE_SAVE.equals(operationType) || OPERATE_SUBMIT.equals(operationType)) {
            this.updateFinEntry(realCards, finCards);
            this.createBotpRelation(finCards);
        } else if (OPERATE_DELETE.equals(operationType)) {
            this.deleteBotpRelation(finCards);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        new DataEntityCacheManager("t_fa_card_fin").removeByDt();
    }

    protected abstract Function<FinCardValidator, Map<Integer, List<String>>> getFinValidateFunc();

    protected abstract void handleFinCardsByBook(DynamicObject[] var1, DynamicObject[] var2);

    private void handleFinCards(DynamicObject[] assetCards, DynamicObject[] finCards) {
        Map<Long, List<DynamicObject>> finCardsGroupByBook = FaFinCardOperationPlugin.classify(finCards);
        for (Map.Entry<Long, List<DynamicObject>> entry : finCardsGroupByBook.entrySet()) {
            List<DynamicObject> bookFinCard = entry.getValue();
            this.handleFinCardsByBook(assetCards, bookFinCard.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject[] getFinCards(BeginOperationTransactionArgs e) {
        Object[] realCardIds = Arrays.stream(e.getDataEntities()).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> assetCardFinList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dy : dataEntities) {
            DynamicObjectCollection assetCardFins = dy.getDynamicObjectCollection("finentry");
            for (DynamicObject entry : assetCardFins) {
                DynamicObject finCard = entry.getDynamicObject("fincard");
                assetCardFinList.add(finCard);
            }
        }
        return FaAssetCardUtils.getFinCardsForOperate(this.getOption(), realCardIds, assetCardFinList);
    }

    private void updateFinEntry(DynamicObject[] assetCards, DynamicObject[] finCards) {
        List finCardList;
        HashMap<Long, List> realFinCardMap = new HashMap<Long, List>(finCards.length);
        for (DynamicObject finCard : finCards) {
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            finCardList = realFinCardMap.computeIfAbsent(realCardId, v -> new ArrayList());
            finCardList.add(finCard);
        }
        for (DynamicObject assetCard : assetCards) {
            DynamicObjectCollection finEntry;
            long assetCardId = assetCard.getLong("id");
            finCardList = (List)realFinCardMap.get(assetCardId);
            if (finCardList == null || finCardList.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b9e\u7269\u5361\u7247\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\uff0c\u5b9e\u7269\u5361\u7247id[%s]\u3002", (String)"AbstractAssetCardOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), assetCardId));
            }
            boolean fromDatabase = assetCard.getDataEntityState().getFromDatabase();
            if (fromDatabase) {
                finEntry = assetCard.getDynamicObjectCollection("finentry");
                for (DynamicObject entry : finEntry) {
                    DynamicObject finCard = entry.getDynamicObject("fincard");
                    entry.set("originalfincard", (Object)finCard);
                    entry.set("originalfincard_id", finCard.getPkValue());
                }
                continue;
            }
            finEntry = assetCard.getDynamicObjectCollection("finentry");
            List<Long> finEntryIds = this.getFinEntryIds(finEntry);
            finEntry.clear();
            int seq = 1;
            for (DynamicObject finCard : finCardList) {
                DynamicObject row = finEntry.addNew();
                if (!finEntryIds.isEmpty()) {
                    row.set("id", (Object)finEntryIds.get(finCardList.indexOf(finCard)));
                }
                row.set("seq", (Object)seq);
                row.set("fincard", (Object)finCard);
                row.set("fincard_id", finCard.getPkValue());
                row.set("originalfincard", (Object)finCard);
                row.set("originalfincard_id", finCard.getPkValue());
            }
        }
    }

    private void createBotpRelation(DynamicObject[] finCards) {
        DBRoute dbRouteFa = DBRoute.of((String)"fa");
        List finCardPks = Arrays.stream(finCards).map(v -> v.getLong("id")).collect(Collectors.toList());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fid from t_fa_card_fin_lk where ", new Object[0]);
        sqlBuilder.appendIn(" fid ", finCardPks.toArray());
        DataSet existBotpCard = DB.queryDataSet((String)"fi/fa/assetCard/createBotp", (DBRoute)dbRouteFa, (SqlBuilder)sqlBuilder);
        HashSet<DynamicObject[]> existBotpCardSet = new HashSet<DynamicObject[]>(32);
        for (Row row : existBotpCard) {
            DynamicObject[] finCardId = row.getLong("fid");
            existBotpCardSet.add(finCardId);
        }
        logger.info("\u5df2\u7ecf\u5b58\u5728botp\u5173\u7cfb\u7684\u5361\u7247\u4e0d\u518d\u91cd\u590d\u751f\u6210\uff1a{}", existBotpCardSet);
        List genBotpCardIds = finCardPks.stream().filter(v -> !existBotpCardSet.contains(v)).collect(Collectors.toList());
        if (genBotpCardIds.isEmpty()) {
            return;
        }
        HashMap<Long, Long> cardIdMap = new HashMap<Long, Long>(32);
        for (DynamicObject finCard : finCards) {
            long finCardId = finCard.getLong("id");
            if (finCardId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u73b0\u5f02\u5e38\u6570\u636e\uff0c\u8d22\u52a1\u5361\u7247id\u4e3a0\u3002", (String)"AbstractAssetCardOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            if (realCardId == 0L) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d22\u52a1\u5361\u7247[%s]\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\u3002", (String)"AbstractAssetCardOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), finCardId));
            }
            cardIdMap.put(finCardId, realCardId);
        }
        Long realCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_real", (String)"fa_card_real").getTableId();
        Long finCardTableId = EntityMetadataCache.loadTableDefine((String)"fa_card_fin", (String)"fa_card_fin").getTableId();
        long[] ids = DB.genGlobalLongIds((int)(genBotpCardIds.size() * 3));
        int idIndex = 0;
        ArrayList<Object[]> paramsOfLk = new ArrayList<Object[]>(finCards.length);
        ArrayList<Object[]> paramsOfTc = new ArrayList<Object[]>(finCards.length);
        ArrayList<Object[]> paramsOfBillTracker = new ArrayList<Object[]>(finCards.length);
        Date createTime = new Date();
        for (Long finCardId : genBotpCardIds) {
            Long realCardId = (Long)cardIdMap.get(finCardId);
            paramsOfLk.add(new Object[]{finCardId, ids[idIndex++], 1, realCardTableId, realCardId, realCardId});
            paramsOfTc.add(new Object[]{ids[idIndex++], finCardId, finCardTableId, finCardId, realCardId, realCardTableId, realCardId});
            paramsOfBillTracker.add(new Object[]{ids[idIndex++], realCardTableId, realCardId, finCardTableId, finCardId, createTime});
        }
        String insertLk = "INSERT INTO t_fa_card_fin_lk (fid, fpkid, fseq, fstableid, fsbillid, fsid) VALUES(?, ?, ?, ?, ?, ?);";
        String insertTc = "INSERT INTO t_fa_card_fin_tc (fid, ftbillid, fttableid, ftid, fsbillid, fstableid, fsid) VALUES(?, ?, ?, ?, ?, ?, ?);";
        String insertBillTracker = "INSERT INTO t_botp_billtracker (fid, fstableid, fsbillid, fttableid, ftbillid, fcreatetime) VALUES(?, ?, ?, ?, ?, ?);";
        try (TXHandle h1 = TX.required();){
            try {
                logger.info("\u5f00\u59cb\u63d2\u5165\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\uff1a\u8d22\u52a1\u5e93");
                DB.executeBatch((DBRoute)dbRouteFa, (String)insertLk, paramsOfLk);
                DB.executeBatch((DBRoute)dbRouteFa, (String)insertTc, paramsOfTc);
                logger.info("\u63d2\u5165\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\u5b8c\u6210\uff1a\u8d22\u52a1\u5e93");
                try (TXHandle h2 = TX.requiresNew();){
                    try {
                        logger.info("\u5f00\u59cb\u63d2\u5165\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\uff1a\u7cfb\u7edf\u5e93");
                        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertBillTracker, paramsOfBillTracker);
                        logger.info("\u63d2\u5165\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\u5b8c\u6210\uff1a\u7cfb\u7edf\u5e93");
                    }
                    catch (Exception e2) {
                        logger.error("\u8d44\u4ea7\u5361\u7247\u521b\u5efabotp\u5173\u7cfb\u51fa\u9519\uff08\u7cfb\u7edf\u5e93\uff09", (Throwable)e2);
                        h2.markRollback();
                        throw e2;
                    }
                }
            }
            catch (Exception e1) {
                logger.error("\u8d44\u4ea7\u5361\u7247\u521b\u5efabotp\u5173\u7cfb\u51fa\u9519\uff08\u8d22\u52a1\u5e93\uff09", (Throwable)e1);
                h1.markRollback();
                throw e1;
            }
        }
    }

    private void deleteBotpRelation(DynamicObject[] finCards) {
        if (finCards.length == 0) {
            return;
        }
        Object[] finCardIds = Arrays.stream(finCards).map(v -> v.getLong("id")).toArray();
        SqlBuilder deleteLkSql = new SqlBuilder();
        deleteLkSql.append("delete from t_fa_card_fin_lk where ", new Object[0]);
        deleteLkSql.appendIn(" fid ", finCardIds);
        SqlBuilder deleteTcSql = new SqlBuilder();
        deleteTcSql.append("delete from t_fa_card_fin_tc where ", new Object[0]);
        deleteTcSql.appendIn(" ftbillid ", finCardIds);
        SqlBuilder deleteBillTrackerSql = new SqlBuilder();
        deleteBillTrackerSql.append("delete from t_botp_billtracker where ", new Object[0]);
        deleteBillTrackerSql.appendIn(" ftbillid ", finCardIds);
        try (TXHandle h1 = TX.required();){
            try {
                logger.info("\u5f00\u59cb\u5220\u9664\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\uff1a\u8d22\u52a1\u5e93");
                DB.execute((DBRoute)DB_ROUTE_FA, (SqlBuilder)deleteLkSql);
                DB.execute((DBRoute)DB_ROUTE_FA, (SqlBuilder)deleteTcSql);
                logger.info("\u5220\u9664\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\u5b8c\u6210\uff1a\u8d22\u52a1\u5e93");
                try (TXHandle h2 = TX.requiresNew();){
                    try {
                        logger.info("\u5f00\u59cb\u5220\u9664\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\uff1a\u7cfb\u7edf\u5e93");
                        DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)deleteBillTrackerSql);
                        logger.info("\u5220\u9664\u8d44\u4ea7\u5361\u7247botp\u5173\u7cfb\u5b8c\u6210\uff1a\u7cfb\u7edf\u5e93");
                    }
                    catch (Exception e2) {
                        logger.error("\u8d44\u4ea7\u5361\u7247\u5220\u9664botp\u5173\u7cfb\u51fa\u9519\uff08\u7cfb\u7edf\u5e93\uff09", (Throwable)e2);
                        h2.markRollback();
                        throw e2;
                    }
                }
            }
            catch (Exception e1) {
                logger.error("\u8d44\u4ea7\u5361\u7247\u5220\u9664botp\u5173\u7cfb\u51fa\u9519\uff08\u8d22\u52a1\u5e93\uff09", (Throwable)e1);
                h1.markRollback();
                throw e1;
            }
        }
    }

    private List<Long> getFinEntryIds(DynamicObjectCollection finentry) {
        ArrayList<Long> ids = new ArrayList<Long>(1);
        if (finentry != null && !finentry.isEmpty()) {
            finentry.stream().forEach(fincard -> ids.add(fincard.getLong("id")));
        }
        return ids;
    }
}

