/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.business.validator.po.FinCardValidatorParam;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaAssetCardUtils;

public class AbstractAssetFinCardValidator
extends AbstractValidator {
    private final Function<FinCardValidator, Map<Integer, List<String>>> validateFunction;

    public AbstractAssetFinCardValidator(Function<FinCardValidator, Map<Integer, List<String>>> validateFunction) {
        this.validateFunction = validateFunction;
    }

    public void validate() {
        if (this.validateFunction == null) {
            return;
        }
        Object[] realCardIds = Arrays.stream(this.getDataEntities()).map(v -> v.getDataEntity().getPkValue()).toArray();
        boolean isSplitCard = false;
        ArrayList<DynamicObject> assetCardFinList = new ArrayList<DynamicObject>(this.dataEntities.length);
        HashSet<Long> depreMethodIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject[] assetCard = dataEntity.getDataEntity();
            String sourceFlag = assetCard.getString("sourceflag");
            if (SourceFlagEnum.SPLIT.name().equals(sourceFlag)) {
                isSplitCard = true;
            }
            DynamicObjectCollection assetCardFins = assetCard.getDynamicObjectCollection("finentry");
            for (DynamicObject entry : assetCardFins) {
                DynamicObject finCard = entry.getDynamicObject("fincard");
                if (null == finCard) continue;
                depreMethodIds.add(finCard.getLong(Fa.id((String)"depremethod")));
                assetCardFinList.add(finCard);
            }
        }
        if (!depreMethodIds.isEmpty() && isSplitCard) {
            Map depreMethodCache = BusinessDataServiceHelper.loadFromCache((Object[])depreMethodIds.toArray(), (String)"fa_depremethod");
            for (DynamicObject fincard : assetCardFinList) {
                fincard.set("depremethod", depreMethodCache.get(fincard.getLong(Fa.id((String)"depremethod"))));
            }
        }
        DynamicObject[] finCards = FaAssetCardUtils.getFinCardsForOperate(this.getOption(), realCardIds, assetCardFinList);
        ArrayList<FinCardValidatorParam> validatorParams = new ArrayList<FinCardValidatorParam>();
        HashMap<Long, Integer> realCardIndexMap = new HashMap<Long, Integer>(this.dataEntities.length);
        HashMap<Long, List> realFinMap = new HashMap<Long, List>(this.dataEntities.length);
        for (DynamicObject finCard : finCards) {
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            List finCardList = realFinMap.computeIfAbsent(realCardId, v -> new ArrayList());
            finCardList.add(finCard);
        }
        for (int i = 0; i < this.getDataEntities().length; ++i) {
            ExtendedDataEntity dataEntity = this.getDataEntities()[i];
            DynamicObject realCard = dataEntity.getDataEntity();
            long realCardId = realCard.getLong("id");
            List finCardList = (List)realFinMap.get(realCardId);
            if (finCardList == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"AbstractAssetFinCardValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject finCard : finCardList) {
                FinCardValidatorParam param = new FinCardValidatorParam(realCard, finCard);
                validatorParams.add(param);
            }
            realCardIndexMap.put(realCardId, i);
        }
        FinCardValidator validator = FinCardValidator.getInstanceForAssetCard(validatorParams);
        Map<Integer, List<String>> errInfo = this.validateFunction.apply(validator);
        if (errInfo == null || errInfo.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, List<String>> entry : errInfo.entrySet()) {
            Integer paramIndex = entry.getKey();
            List<String> errMsgList = entry.getValue();
            FinCardValidatorParam param = (FinCardValidatorParam)validatorParams.get(paramIndex);
            DynamicObject realCard = param.getRealCard();
            long realCardId = realCard.getLong("id");
            Integer realCardIndex = (Integer)realCardIndexMap.get(realCardId);
            ExtendedDataEntity dataEntity = this.getDataEntities()[realCardIndex];
            errMsgList.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
        }
    }
}

