/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaAssetCardInitBackupDataValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Long> realMasterIdList = new ArrayList<Long>(this.getDataEntities().length);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject realCard = dataEntity.getDataEntity();
            boolean fromDatabase = realCard.getDataEntityState().getFromDatabase();
            if (!fromDatabase) continue;
            long masterId = realCard.getLong("masterid");
            realMasterIdList.add(masterId);
        }
        QFilter realFilter = new QFilter("masterid", "in", realMasterIdList);
        String realFields = Fa.comma((String[])new String[]{"id", "masterid"});
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)realFields, (QFilter[])realFilter.toArray());
        HashSet<Long> existRealBackupData = new HashSet<Long>(this.getDataEntities().length, 1.0f);
        HashMap<Long, Long> realIdMasterIdMap = new HashMap<Long, Long>(realCards.size(), 1.0f);
        for (DynamicObject realCard : realCards) {
            long id = realCard.getLong("id");
            long masterId = realCard.getLong("masterid");
            if (realIdMasterIdMap.containsValue(masterId)) {
                existRealBackupData.add(masterId);
            }
            realIdMasterIdMap.put(id, masterId);
        }
        QFilter finFilter = new QFilter("realcard", "in", realIdMasterIdMap.keySet());
        String finFields = Fa.comma((String[])new String[]{"id", "realcard", "depreuse"});
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)finFields, (QFilter[])finFilter.toArray());
        HashSet<Long> existFinBackupData = new HashSet<Long>(this.getDataEntities().length, 1.0f);
        HashSet<String> tempSet = new HashSet<String>(finCards.size(), 1.0f);
        for (DynamicObject finCard : finCards) {
            long depreUseId = finCard.getLong("depreuse");
            long realCardId = finCard.getLong("realcard");
            Long realMasterId = (Long)realIdMasterIdMap.get(realCardId);
            String key = depreUseId + "_" + realMasterId;
            if (tempSet.add(key)) continue;
            existFinBackupData.add(realMasterId);
        }
        if (existRealBackupData.isEmpty() && existFinBackupData.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject realCard = dataEntity.getDataEntity();
            long masterId = realCard.getLong("masterid");
            if (existRealBackupData.contains(masterId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5b58\u5728\u5907\u4efd\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaAssetCardInitBackupDataValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (!existFinBackupData.contains(masterId)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5b58\u5728\u5907\u4efd\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaAssetCardInitBackupDataValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }
}

