/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.opplugin.assetcard.AbstractAssetCardOp;

public class FaAssetCardInitDeleteOp
extends AbstractAssetCardOp {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("finentry.fincard.assetbook.status");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operationName = this.getValidateContext().getOperateName();
                HashMap errInfo = new HashMap(this.getDataEntities().length);
                ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>(this.getDataEntities().length);
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    DynamicObject assetCard = dataEntity.getDataEntity();
                    DynamicObjectCollection finentry = assetCard.getDynamicObjectCollection("finentry");
                    for (DynamicObject entry : finentry) {
                        DynamicObject finCard = entry.getDynamicObject("fincard");
                        finCards.add(finCard);
                        DynamicObject assetBook = finCard.getDynamicObject("assetbook");
                        if (FaAssetCardInitDeleteOp.this.queryBookStatus(assetBook.getLong("masterid")).booleanValue()) {
                            this.addMessage(dataEntity, operationName, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FaAssetCardInitDeleteOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                            continue;
                        }
                        Optional checkResult = FaAssetCardInitDeleteOp.this.checkFutureBiz(finCard);
                        if (!checkResult.isPresent()) continue;
                        String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff1a%s", (String)"FaAssetCardInitDeleteOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get());
                        this.addMessage(dataEntity, operationName, msg, ErrorLevel.Error);
                    }
                    FinCardValidator validator = FinCardValidator.getInstanceForSeparateCard(finCards);
                    errInfo.putAll(validator.validateInitFinCardForDelete());
                }
                for (int i = 0; i < this.getDataEntities().length; ++i) {
                    List errMsg = (List)errInfo.get(i);
                    if (errMsg == null || errMsg.isEmpty()) continue;
                    ExtendedDataEntity dataEntity = this.getDataEntities()[i];
                    errMsg.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
                }
            }
        });
    }

    @Override
    protected Function<FinCardValidator, Map<Integer, List<String>>> getFinValidateFunc() {
        return null;
    }

    @Override
    protected void handleFinCardsByBook(DynamicObject[] assetCards, DynamicObject[] finCards) {
        Object[] realcardIds = Arrays.stream(assetCards).map(dyn -> dyn.getLong("id")).toArray();
        DeleteServiceHelper.delete((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("realcard", "in", (Object)realcardIds)});
        new DepreSplitSum().deduct(finCards, true, false);
    }

    private Boolean queryBookStatus(Long masterid) {
        QFilter qStatus = new QFilter("masterid", "=", (Object)masterid);
        DynamicObject assetbook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"status", (QFilter[])new QFilter[]{qStatus});
        String status = assetbook.getString("status");
        if (status.equals("C")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Optional<String> checkFutureBiz(DynamicObject finCard) {
        DynamicObject realCard = finCard.getDynamicObject("realcard");
        realCard = FaRealCardDaoFactory.getInstance().queryOne("masterid", realCard.getPkValue());
        Map realCards = BusinessDataServiceHelper.loadFromCache((String)"fa_card_real", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)realCard.getLong("masterid"))});
        Set realCardPkSet = realCards.keySet();
        Object orgId = finCard.get("org.id");
        FutureBizChecker futureBizChecker = new FutureBizChecker(null, orgId, realCardPkSet, null, BusyTypeDetailEnum.REAL_FIN_CHG);
        futureBizChecker.setFromFin(true);
        return futureBizChecker.checkWhenun();
    }
}

